/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset != 0) {
            int n = this.bitOffset;
            int n2 = this.read();
            if (n2 < 0) {
                n2 = 0;
                this.bitOffset = 0;
            } else {
                this.seek(this.getStreamPosition() - 1L);
                n2 &= -1 << 8 - n;
            }
            this.write(n2);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write(int var1) throws IOException;

    public void writeBit(int n) throws IOException {
        this.writeBits(1L & (long)n, 1);
    }

    public void writeBits(long l, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        this.checkClosed();
        if (this.getStreamPosition() > 0L || this.bitOffset > 0) {
            n5 = this.bitOffset;
            n4 = this.read();
            if (n4 != -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                n4 = 0;
            }
            if (n + n5 < 8) {
                n3 = 8 - (n5 + n);
                n2 = -1 >>> 32 - n;
                n4 &= ~(n2 << n3);
                n4 = (int)((long)n4 | (l & (long)n2) << n3);
                this.write(n4);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = n5 + n;
                n = 0;
            } else {
                n3 = 8 - n5;
                n2 = -1 >>> 32 - n3;
                n4 &= ~n2;
                n4 = (int)((long)n4 | l >> n - n3 & (long)n2);
                this.write(n4);
                n -= n3;
            }
        }
        if (n > 7) {
            n5 = n % 8;
            for (n4 = n / 8; n4 > 0; --n4) {
                n3 = (n4 - 1) * 8 + n5;
                n2 = (int)(n3 == 0 ? l & 0xFFL : l >> n3 & 0xFFL);
                this.write(n2);
            }
            n = n5;
        }
        if (n != 0) {
            n5 = this.read();
            if (n5 == -1) {
                this.seek(this.getStreamPosition() - 1L);
            } else {
                n5 = 0;
            }
            n4 = 8 - n;
            n3 = -1 >>> 32 - n;
            n5 &= ~(n3 << n4);
            n5 = (int)((long)n5 | (l & (long)n3) << n4);
            this.write(n5);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = n;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n & 0xFF);
    }

    public void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeChar(cArray[n + n3]);
            ++n2;
        }
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeDoubles(double[] dArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeDouble(dArray[n + n3]);
            ++n2;
        }
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeFloats(float[] fArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeFloat(fArray[n + n3]);
            ++n2;
        }
    }

    public void writeInt(int n) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)n;
            this.buffer[1] = (byte)(n >> 8);
            this.buffer[2] = (byte)(n >> 16);
            this.buffer[3] = (byte)(n >> 24);
        } else {
            this.buffer[0] = (byte)(n >> 24);
            this.buffer[1] = (byte)(n >> 16);
            this.buffer[2] = (byte)(n >> 8);
            this.buffer[3] = (byte)n;
        }
        this.write(this.buffer, 0, 4);
    }

    public void writeInts(int[] nArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeInt(nArray[n + n3]);
            ++n2;
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)l;
            this.buffer[1] = (byte)(l >> 8);
            this.buffer[2] = (byte)(l >> 16);
            this.buffer[3] = (byte)(l >> 24);
            this.buffer[4] = (byte)(l >> 32);
            this.buffer[5] = (byte)(l >> 40);
            this.buffer[6] = (byte)(l >> 48);
            this.buffer[7] = (byte)(l >> 56);
        } else {
            this.buffer[0] = (byte)(l >> 56);
            this.buffer[1] = (byte)(l >> 48);
            this.buffer[2] = (byte)(l >> 40);
            this.buffer[3] = (byte)(l >> 32);
            this.buffer[4] = (byte)(l >> 24);
            this.buffer[5] = (byte)(l >> 16);
            this.buffer[6] = (byte)(l >> 8);
            this.buffer[7] = (byte)l;
        }
        this.write(this.buffer, 0, 8);
    }

    public void writeLongs(long[] lArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeLong(lArray[n + n3]);
            ++n2;
        }
    }

    public void writeShort(int n) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)n;
            this.buffer[1] = (byte)(n >> 8);
        } else {
            this.buffer[0] = (byte)(n >> 8);
            this.buffer[1] = (byte)n;
        }
        this.write(this.buffer, 0, 2);
    }

    public void writeShorts(short[] sArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeShort(sArray[n + n3]);
            ++n2;
        }
    }

    public void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2 && n3 <= 65535; ++n) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        n = 0;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                byArray[n++] = (byte)(0xC0 | 0x1F & c >> 6);
                byArray[n++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | 0xF & c >> 12);
            byArray[n++] = (byte)(0x80 | 0x3F & c >> 6);
            byArray[n++] = (byte)(0x80 | 0x3F & c);
        }
        this.writeShort(n3);
        this.write(byArray, 0, n3);
    }
}

