/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import gnu.java.lang.CPStringBuilder;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private boolean closed;
    private Stack markStack = new Stack();
    byte[] buffer = new byte[8];
    protected int bitOffset;
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long flushedPos;
    protected long streamPos;

    protected final void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
    }

    public void close() throws IOException {
        this.checkClosed();
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close();
        }
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public void flushBefore(long l) throws IOException {
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException();
        }
        if (l > this.streamPos) {
            throw new IndexOutOfBoundsException();
        }
        this.flushedPos = l;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public long length() {
        return -1L;
    }

    public void mark() {
        try {
            this.markStack.push(new Long(this.getStreamPosition()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public abstract int read() throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int readBit() throws IOException {
        this.checkClosed();
        int n = this.bitOffset + 1 & 7;
        byte by = this.readByte();
        if (n != 0) {
            this.seek(this.getStreamPosition() - 1L);
            by = (byte)(by >> 8 - n);
        }
        this.bitOffset = n;
        return by & 1;
    }

    public long readBits(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l <<= 1;
            l |= (long)this.readBit();
        }
        return l;
    }

    public boolean readBoolean() throws IOException {
        byte by = this.readByte();
        return by != 0;
    }

    public byte readByte() throws IOException {
        this.checkClosed();
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        this.readFullyPrivate(iIOByteBuffer.getData(), iIOByteBuffer.getOffset(), n);
        iIOByteBuffer.setLength(n);
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.readFullyPrivate(byArray, n, n2);
    }

    public void readFully(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            cArray[n + i] = this.readChar();
        }
    }

    public void readFully(double[] dArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.readDouble();
        }
    }

    public void readFully(float[] fArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            fArray[n + i] = this.readFloat();
        }
    }

    public void readFully(int[] nArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            nArray[n + i] = this.readInt();
        }
    }

    public void readFully(long[] lArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.readLong();
        }
    }

    public void readFully(short[] sArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            sArray[n + i] = this.readShort();
        }
    }

    public int readInt() throws IOException {
        this.readFullyPrivate(this.buffer, 0, 4);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (this.buffer[0] & 0xFF) << 0 | (this.buffer[1] & 0xFF) << 8 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[3] & 0xFF) << 24;
        }
        return ((this.buffer[0] & 0xFF) << 24) + ((this.buffer[1] & 0xFF) << 16) + ((this.buffer[2] & 0xFF) << 8) + ((this.buffer[3] & 0xFF) << 0);
    }

    public String readLine() throws IOException {
        this.checkClosed();
        int n = -1;
        boolean bl = false;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        n = this.read();
        if (n == -1) {
            return null;
        }
        block4: while (!bl) {
            switch (n) {
                case 13: {
                    long l = this.getStreamPosition();
                    n = this.read();
                    if (n == -1 || n == 10) {
                        bl = true;
                        continue block4;
                    }
                    this.seek(l);
                    bl = true;
                    continue block4;
                }
                case 10: {
                    bl = true;
                    continue block4;
                }
            }
            cPStringBuilder.append((char)n);
            n = this.read();
            if (n != -1) continue;
            bl = true;
        }
        return cPStringBuilder.toString();
    }

    public long readLong() throws IOException {
        this.readFullyPrivate(this.buffer, 0, 8);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (long)(this.buffer[0] & 0xFF) << 0 | (long)(this.buffer[1] & 0xFF) << 8 | (long)(this.buffer[2] & 0xFF) << 16 | (long)(this.buffer[3] & 0xFF) << 24 | (long)(this.buffer[4] & 0xFF) << 32 | (long)(this.buffer[5] & 0xFF) << 40 | (long)(this.buffer[6] & 0xFF) << 48 | (long)(this.buffer[7] & 0xFF) << 56;
        }
        return (long)(this.buffer[0] & 0xFF) << 56 | (long)(this.buffer[1] & 0xFF) << 48 | (long)(this.buffer[2] & 0xFF) << 40 | (long)(this.buffer[3] & 0xFF) << 32 | (long)(this.buffer[4] & 0xFF) << 24 | (long)(this.buffer[5] & 0xFF) << 16 | (long)(this.buffer[6] & 0xFF) << 8 | (long)(this.buffer[7] & 0xFF) << 0;
    }

    public short readShort() throws IOException {
        this.readFullyPrivate(this.buffer, 0, 2);
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            return (short)((short)(this.buffer[0] & 0xFF) << 0 | (short)(this.buffer[1] & 0xFF) << 8);
        }
        return (short)((short)(this.buffer[0] & 0xFF) << 8 | (short)(this.buffer[1] & 0xFF) << 0);
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readUTF() throws IOException {
        String string;
        this.checkClosed();
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            string = DataInputStream.readUTF(this);
            Object var4_3 = null;
            this.setByteOrder(byteOrder);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.setByteOrder(byteOrder);
            throw throwable;
        }
        return string;
    }

    public void reset() throws IOException {
        this.checkClosed();
        long l = (Long)this.markStack.pop();
        this.seek(l);
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("position < flushed position");
        }
        this.streamPos = l;
        this.bitOffset = 0;
    }

    public void setBitOffset(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("bitOffset not between 0 and 7 inclusive");
        }
        this.bitOffset = n;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public int skipBytes(int n) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + (long)n);
        this.bitOffset = 0;
        return n;
    }

    public long skipBytes(long l) throws IOException {
        this.checkClosed();
        this.seek(this.getStreamPosition() + l);
        this.bitOffset = 0;
        return l;
    }

    private void readFullyPrivate(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative length: " + n2);
        }
        while (n2 > 0) {
            int n3 = this.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
        this.bitOffset = 0;
    }
}

