/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import gnu.classpath.ServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.spi.RegisterableService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistry {
    final Class[] categories;
    private final LinkedList[] providers;
    private IdentityHashMap[] constraints;

    public ServiceRegistry(Iterator<Class<?>> iterator) {
        ArrayList arrayList = new ArrayList(10);
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (clazz == null) {
                throw new IllegalArgumentException();
            }
            arrayList.add(clazz);
        }
        int n = arrayList.size();
        this.categories = arrayList.toArray(new Class[n]);
        this.providers = new LinkedList[n];
    }

    public static <T> Iterator<T> lookupProviders(Class<T> clazz, ClassLoader classLoader) {
        return ServiceFactory.lookupProviders(clazz, classLoader);
    }

    public static <T> Iterator<T> lookupProviders(Class<T> clazz) {
        return ServiceFactory.lookupProviders(clazz);
    }

    public Iterator<Class<?>> getCategories() {
        return new Iterator(){
            int index = -1;

            public boolean hasNext() {
                return this.index < ServiceRegistry.this.categories.length - 1;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ServiceRegistry.this.categories[++this.index];
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private synchronized boolean registerServiceProvider(Object object, int n) {
        boolean bl;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class clazz = this.categories[n];
        if (!clazz.isInstance(object)) {
            throw new ClassCastException(clazz.getName());
        }
        LinkedList<Object> linkedList = this.providers[n];
        if (linkedList == null) {
            bl = true;
            linkedList = this.providers[n] = new LinkedList<Object>();
        } else {
            bl = false;
        }
        linkedList.add(object);
        if (object instanceof RegisterableService) {
            ((RegisterableService)object).onRegistration(this, clazz);
        }
        return bl;
    }

    public synchronized <T> boolean registerServiceProvider(T t, Class<T> clazz) {
        for (int i = 0; i < this.categories.length; ++i) {
            if (this.categories[i] != clazz) continue;
            return this.registerServiceProvider(t, i);
        }
        throw new IllegalArgumentException();
    }

    public synchronized void registerServiceProvider(Object object) {
        boolean bl = false;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.categories.length; ++i) {
            if (!this.categories[i].isInstance(object)) continue;
            bl = true;
            this.registerServiceProvider(object, i);
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized void registerServiceProviders(Iterator<?> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException();
        }
        while (iterator.hasNext()) {
            this.registerServiceProvider(iterator.next());
        }
    }

    private synchronized boolean deregisterServiceProvider(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Class clazz = this.categories[n];
        if (!clazz.isInstance(object)) {
            throw new ClassCastException(clazz.getName());
        }
        LinkedList linkedList = this.providers[n];
        if (linkedList == null) {
            return false;
        }
        boolean bl = linkedList.remove(object);
        if (linkedList.isEmpty()) {
            this.providers[n] = null;
        }
        if (bl && object instanceof RegisterableService) {
            ((RegisterableService)object).onDeregistration(this, clazz);
        }
        return bl;
    }

    public synchronized <T> boolean deregisterServiceProvider(T t, Class<T> clazz) {
        for (int i = 0; i < this.categories.length; ++i) {
            if (this.categories[i] != clazz) continue;
            return this.deregisterServiceProvider(t, i);
        }
        throw new IllegalArgumentException();
    }

    public synchronized void deregisterServiceProvider(Object object) {
        boolean bl = false;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.categories.length; ++i) {
            if (!this.categories[i].isInstance(object)) continue;
            bl = true;
            this.deregisterServiceProvider(object, i);
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized void deregisterAll(Class<?> clazz) {
        boolean bl = false;
        for (int i = 0; i < this.categories.length; ++i) {
            if (this.categories[i] != clazz) continue;
            bl = true;
            while (this.providers[i] != null) {
                this.deregisterServiceProvider(this.providers[i].get(0), i);
            }
        }
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized void deregisterAll() {
        for (int i = 0; i < this.categories.length; ++i) {
            while (this.providers[i] != null) {
                this.deregisterServiceProvider(this.providers[i].get(0), i);
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.deregisterAll();
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.providers.length; ++i) {
            LinkedList linkedList;
            if (!this.categories[i].isInstance(object) || (linkedList = this.providers[i]) == null || !linkedList.contains(object)) continue;
            return true;
        }
        return false;
    }

    private int getCategoryID(Class clazz) {
        for (int i = 0; i < this.categories.length; ++i) {
            if (this.categories[i] != clazz) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public <T> Iterator<T> getServiceProviders(Class<T> clazz, boolean bl) {
        return this.getServiceProviders(clazz, null, bl);
    }

    public synchronized <T> Iterator<T> getServiceProviders(Class<T> clazz, Filter filter, boolean bl) {
        int n = this.getCategoryID(clazz);
        LinkedList linkedList = this.providers[n];
        if (linkedList == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList arrayList = new ArrayList(linkedList.size());
        Object object = linkedList.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (filter != null && !filter.filter(e)) continue;
            arrayList.add(e);
        }
        if (bl && this.constraints != null && (object = this.constraints[n]) != null) {
            Collections.sort(arrayList, new Comparator((Map)object){
                final /* synthetic */ Map val$cons;
                {
                    this.val$cons = map;
                }

                public int compare(Object object, Object object2) {
                    if (object == object2) {
                        return 0;
                    }
                    Set set = (Set)this.val$cons.get(object);
                    if (set != null && set.contains(object2)) {
                        return -1;
                    }
                    set = (Set)this.val$cons.get(object2);
                    if (set != null && set.contains(object)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        return arrayList.iterator();
    }

    public synchronized <T> T getServiceProviderByClass(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < this.categories.length; ++i) {
            LinkedList linkedList;
            if (!this.categories[i].isAssignableFrom(clazz) || (linkedList = this.providers[i]) == null) continue;
            for (Object e : linkedList) {
                if (!clazz.isInstance(e)) continue;
                return (T)e;
            }
        }
        return null;
    }

    public synchronized <T> boolean setOrdering(Class<T> clazz, T t, T t2) {
        return this.addConstraint(this.getCategoryID(clazz), t, t2);
    }

    public synchronized <T> boolean unsetOrdering(Class<T> clazz, T t, T t2) {
        return this.removeConstraint(this.getCategoryID(clazz), t, t2);
    }

    private boolean addConstraint(int n, Object object, Object object2) {
        HashSet hashSet;
        IdentityHashMap identityHashMap;
        this.removeConstraint(n, object2, object);
        if (this.constraints == null) {
            this.constraints = new IdentityHashMap[this.categories.length];
        }
        if ((identityHashMap = this.constraints[n]) == null) {
            identityHashMap = this.constraints[n] = new IdentityHashMap();
        }
        if ((hashSet = (HashSet)identityHashMap.get(object)) == null) {
            hashSet = new HashSet();
            identityHashMap.put(object, hashSet);
        }
        return hashSet.add(object2);
    }

    private boolean removeConstraint(int n, Object object, Object object2) {
        if (object == null || object2 == null || object == object2) {
            throw new IllegalArgumentException();
        }
        if (this.constraints == null) {
            return false;
        }
        IdentityHashMap identityHashMap = this.constraints[n];
        if (identityHashMap == null) {
            return false;
        }
        Collection collection = (Collection)identityHashMap.get(object);
        if (collection == null) {
            return false;
        }
        if (!collection.remove(object2)) {
            return false;
        }
        if (identityHashMap.isEmpty()) {
            this.constraints[n] = null;
            boolean bl = false;
            for (int i = 0; i < this.constraints.length; ++i) {
                if (this.constraints[i] == null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.constraints = null;
            }
        }
        return true;
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

