/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import gnu.classpath.ServiceFactory;
import gnu.java.awt.ClasspathToolkit;
import gnu.javax.imageio.bmp.BMPImageReaderSpi;
import gnu.javax.imageio.bmp.BMPImageWriterSpi;
import gnu.javax.imageio.gif.GIFImageReaderSpi;
import gnu.javax.imageio.png.PNGImageReaderSpi;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public final class IIORegistry
extends ServiceRegistry {
    private static final HashSet defaultCategories = new HashSet();
    private static HashMap instances = new HashMap();

    public static synchronized IIORegistry getDefaultInstance() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        IIORegistry iIORegistry = (IIORegistry)instances.get(threadGroup);
        if (iIORegistry == null) {
            iIORegistry = new IIORegistry();
            instances.put(threadGroup, iIORegistry);
        }
        return iIORegistry;
    }

    private IIORegistry() {
        super(defaultCategories.iterator());
        this.registerServiceProvider(new PNGImageReaderSpi());
        this.registerServiceProvider(new GIFImageReaderSpi());
        this.registerServiceProvider(new BMPImageReaderSpi());
        this.registerServiceProvider(new BMPImageWriterSpi());
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof ClasspathToolkit) {
            ((ClasspathToolkit)toolkit).registerImageIOSpis(this);
        }
        this.registerApplicationClasspathSpis();
    }

    public void registerApplicationClasspathSpis() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator<Class<?>> iterator = this.getCategories();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            Iterator<?> iterator2 = ServiceFactory.lookupProviders(clazz, classLoader);
            while (iterator2.hasNext()) {
                this.registerServiceProvider((IIOServiceProvider)iterator2.next());
            }
        }
    }

    static {
        defaultCategories.add(ImageReaderSpi.class);
        defaultCategories.add(ImageWriterSpi.class);
        defaultCategories.add(ImageTranscoderSpi.class);
        defaultCategories.add(ImageInputStreamSpi.class);
        defaultCategories.add(ImageOutputStreamSpi.class);
    }
}

