/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageIO {
    private static File cacheDirectory;
    private static boolean useCache;

    private ImageIO() {
    }

    private static Iterator<ImageReader> getReadersByFilter(Class<ImageReaderSpi> clazz, ServiceRegistry.Filter filter, Object object) {
        try {
            Iterator<ImageReaderSpi> iterator = ImageIO.getRegistry().getServiceProviders(clazz, filter, true);
            return new ImageReaderIterator(iterator, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    private static Iterator<ImageWriter> getWritersByFilter(Class<ImageWriterSpi> clazz, ServiceRegistry.Filter filter, Object object) {
        try {
            Iterator<ImageWriterSpi> iterator = ImageIO.getRegistry().getServiceProviders(clazz, filter, true);
            return new ImageWriterIterator(iterator, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    public static File getCacheDirectory() {
        return cacheDirectory;
    }

    public static Iterator<ImageReader> getImageReadersByFormatName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        return ImageIO.getReadersByFilter(ImageReaderSpi.class, new ReaderFormatFilter(string), string);
    }

    public static Iterator<ImageReader> getImageReadersByMIMEType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        return ImageIO.getReadersByFilter(ImageReaderSpi.class, new ReaderMIMETypeFilter(string), string);
    }

    public static Iterator<ImageReader> getImageReadersBySuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        return ImageIO.getReadersByFilter(ImageReaderSpi.class, new ReaderSuffixFilter(string), string);
    }

    public static Iterator<ImageWriter> getImageWritersByFormatName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        return ImageIO.getWritersByFilter(ImageWriterSpi.class, new WriterFormatFilter(string), string);
    }

    public static Iterator<ImageWriter> getImageWritersByMIMEType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        return ImageIO.getWritersByFilter(ImageWriterSpi.class, new WriterMIMETypeFilter(string), string);
    }

    public static Iterator<ImageWriter> getImageWritersBySuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("fileSuffix may not be null");
        }
        return ImageIO.getWritersByFilter(ImageWriterSpi.class, new WriterSuffixFilter(string), string);
    }

    public static String[] getReaderFormatNames() {
        try {
            Iterator<ImageReaderSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, true);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                ImageReaderSpi imageReaderSpi = iterator.next();
                String[] stringArray = imageReaderSpi.getFormatNames();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    arrayList.add(stringArray[i]);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static String[] getReaderMIMETypes() {
        try {
            Iterator<ImageReaderSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, true);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                ImageReaderSpi imageReaderSpi = iterator.next();
                String[] stringArray = imageReaderSpi.getMIMETypes();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    arrayList.add(stringArray[i]);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    private static IIORegistry getRegistry() {
        return IIORegistry.getDefaultInstance();
    }

    public static boolean getUseCache() {
        return useCache;
    }

    public static String[] getWriterFormatNames() {
        try {
            Iterator<ImageWriterSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageWriterSpi.class, true);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                ImageWriterSpi imageWriterSpi = iterator.next();
                String[] stringArray = imageWriterSpi.getFormatNames();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    arrayList.add(stringArray[i]);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static String[] getWriterMIMETypes() {
        try {
            Iterator<ImageWriterSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageWriterSpi.class, true);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                ImageWriterSpi imageWriterSpi = iterator.next();
                String[] stringArray = imageWriterSpi.getMIMETypes();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    arrayList.add(stringArray[i]);
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static void scanForPlugins() {
        IIORegistry.getDefaultInstance().registerApplicationClasspathSpis();
    }

    public static void setCacheDirectory(File file) {
        if (file != null) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("cacheDirectory must be a directory");
            }
            file.canWrite();
        }
        cacheDirectory = file;
    }

    public static void setUseCache(boolean bl) {
        useCache = bl;
    }

    public static boolean write(RenderedImage renderedImage, String string, File file) throws IOException {
        if (renderedImage == null || string == null || file == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(renderedImage, string, new FileOutputStream(file));
    }

    public static boolean write(RenderedImage renderedImage, String string, OutputStream outputStream) throws IOException {
        if (renderedImage == null || string == null || outputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(renderedImage, string, new MemoryCacheImageOutputStream(outputStream));
    }

    public static boolean write(RenderedImage renderedImage, String string, ImageOutputStream imageOutputStream) throws IOException {
        if (renderedImage == null || string == null || imageOutputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        IIOImage iIOImage = new IIOImage(renderedImage, null, null);
        while (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            try {
                imageWriter.setOutput(imageOutputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            imageWriter.write(null, iIOImage, null);
            imageWriter.dispose();
            imageOutputStream.close();
            return true;
        }
        return false;
    }

    public static BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageReaderSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, true);
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            if (!imageReaderSpi.canDecodeInput(imageInputStream)) continue;
            ImageReader imageReader = imageReaderSpi.createReaderInstance();
            imageReader.setInput(imageInputStream);
            return imageReader.read(0, null);
        }
        return null;
    }

    public static BufferedImage read(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(uRL.openStream());
    }

    public static BufferedImage read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new MemoryCacheImageInputStream(inputStream));
    }

    public static BufferedImage read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new FileInputStream(file));
    }

    public static ImageInputStream createImageInputStream(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageInputStreamSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageInputStreamSpi.class, true);
        ImageInputStreamSpi imageInputStreamSpi = null;
        while (iterator.hasNext()) {
            ImageInputStreamSpi imageInputStreamSpi2 = iterator.next();
            if (!object.getClass().equals(imageInputStreamSpi2.getInputClass())) continue;
            imageInputStreamSpi = imageInputStreamSpi2;
            break;
        }
        return imageInputStreamSpi == null ? null : imageInputStreamSpi.createInputStreamInstance(object, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static ImageOutputStream createImageOutputStream(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageOutputStreamSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageOutputStreamSpi.class, true);
        ImageOutputStreamSpi imageOutputStreamSpi = null;
        while (iterator.hasNext()) {
            ImageOutputStreamSpi imageOutputStreamSpi2 = iterator.next();
            if (!object.getClass().equals(imageOutputStreamSpi2.getOutputClass())) continue;
            imageOutputStreamSpi = imageOutputStreamSpi2;
            break;
        }
        return imageOutputStreamSpi == null ? null : imageOutputStreamSpi.createOutputStreamInstance(object, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static ImageReader getImageReader(ImageWriter imageWriter) {
        if (imageWriter == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        String[] stringArray = imageWriterSpi.getImageReaderSpiNames();
        ImageReader imageReader = null;
        if (stringArray != null) {
            try {
                Class<?> clazz = Class.forName(stringArray[0]);
                imageReader = (ImageReader)clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return imageReader;
    }

    public static Iterator<ImageReader> getImageReaders(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageReaderSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, new ReaderObjectFilter(object), true);
        return new ImageReaderIterator(iterator);
    }

    public static Iterator<ImageWriter> getImageWriters(ImageTypeSpecifier imageTypeSpecifier, String string) {
        if (imageTypeSpecifier == null || string == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageWriterSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageWriterSpi.class, new WriterObjectFilter(imageTypeSpecifier, string), true);
        return new ImageWriterIterator(iterator);
    }

    public static ImageWriter getImageWriter(ImageReader imageReader) {
        if (imageReader == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
        String[] stringArray = imageReaderSpi.getImageWriterSpiNames();
        ImageWriter imageWriter = null;
        if (stringArray != null) {
            try {
                Class<?> clazz = Class.forName(stringArray[0]);
                imageWriter = (ImageWriter)clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return imageWriter;
    }

    public static Iterator<ImageTranscoder> getImageTranscoders(ImageReader imageReader, ImageWriter imageWriter) {
        if (imageReader == null || imageWriter == null) {
            throw new IllegalArgumentException("null argument");
        }
        final Iterator<ImageTranscoderSpi> iterator = ImageIO.getRegistry().getServiceProviders(ImageTranscoderSpi.class, new TranscoderFilter(imageReader, imageWriter), true);
        return new Iterator<ImageTranscoder>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public ImageTranscoder next() {
                return ((ImageTranscoderSpi)iterator.next()).createTranscoderInstance();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        useCache = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImageWriterIterator
    implements Iterator<ImageWriter> {
        Iterator<ImageWriterSpi> it;
        Object writerExtension;

        public ImageWriterIterator(Iterator<ImageWriterSpi> iterator, Object object) {
            this.it = iterator;
            this.writerExtension = object;
        }

        public ImageWriterIterator(Iterator<ImageWriterSpi> iterator) {
            this.it = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ImageWriter next() {
            try {
                ImageWriterSpi imageWriterSpi = this.it.next();
                return this.writerExtension == null ? imageWriterSpi.createWriterInstance() : imageWriterSpi.createWriterInstance(this.writerExtension);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImageReaderIterator
    implements Iterator<ImageReader> {
        Iterator<ImageReaderSpi> it;
        Object readerExtension;

        public ImageReaderIterator(Iterator<ImageReaderSpi> iterator, Object object) {
            this.it = iterator;
            this.readerExtension = object;
        }

        public ImageReaderIterator(Iterator<ImageReaderSpi> iterator) {
            this.it = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ImageReader next() {
            try {
                ImageReaderSpi imageReaderSpi = this.it.next();
                return this.readerExtension == null ? imageReaderSpi.createReaderInstance() : imageReaderSpi.createReaderInstance(this.readerExtension);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TranscoderFilter
    implements ServiceRegistry.Filter {
        private ImageReader reader;
        private ImageWriter writer;

        public TranscoderFilter(ImageReader imageReader, ImageWriter imageWriter) {
            this.reader = imageReader;
            this.writer = imageWriter;
        }

        public boolean filter(Object object) {
            ImageTranscoderSpi imageTranscoderSpi;
            return object instanceof ImageTranscoderSpi && (imageTranscoderSpi = (ImageTranscoderSpi)object).getReaderServiceProviderName().equals(this.reader.getOriginatingProvider().getClass().getName()) && imageTranscoderSpi.getWriterServiceProviderName().equals(this.writer.getOriginatingProvider().getClass().getName());
        }
    }

    private static final class WriterObjectFilter
    implements ServiceRegistry.Filter {
        private ImageTypeSpecifier type;
        private String formatName;

        public WriterObjectFilter(ImageTypeSpecifier imageTypeSpecifier, String string) {
            this.type = imageTypeSpecifier;
            this.formatName = string;
        }

        public boolean filter(Object object) {
            ImageWriterSpi imageWriterSpi;
            if (object instanceof ImageWriterSpi && (imageWriterSpi = (ImageWriterSpi)object).canEncodeImage(this.type)) {
                String[] stringArray = imageWriterSpi.getFormatNames();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!this.formatName.equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class WriterSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public WriterSuffixFilter(String string) {
            this.fileSuffix = string;
        }

        public boolean filter(Object object) {
            if (object instanceof ImageWriterSpi) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                String[] stringArray = imageWriterSpi.getFileSuffixes();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!this.fileSuffix.equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class WriterMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public WriterMIMETypeFilter(String string) {
            this.MIMEType = string;
        }

        public boolean filter(Object object) {
            if (object instanceof ImageWriterSpi) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                String[] stringArray = imageWriterSpi.getMIMETypes();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!this.MIMEType.equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class WriterFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public WriterFormatFilter(String string) {
            this.formatName = string;
        }

        public boolean filter(Object object) {
            if (object instanceof ImageWriterSpi) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                String[] stringArray = imageWriterSpi.getFormatNames();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!this.formatName.equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ReaderSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public ReaderSuffixFilter(String string) {
            this.fileSuffix = string;
        }

        public boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                String[] stringArray = imageReaderSpi.getFileSuffixes();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!this.fileSuffix.equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ReaderObjectFilter
    implements ServiceRegistry.Filter {
        private Object object;

        public ReaderObjectFilter(Object object) {
            this.object = object;
        }

        public boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                try {
                    if (imageReaderSpi.canDecodeInput(this.object)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static final class ReaderMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public ReaderMIMETypeFilter(String string) {
            this.MIMEType = string;
        }

        public boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                String[] stringArray = imageReaderSpi.getMIMETypes();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!this.MIMEType.equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class ReaderFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public ReaderFormatFilter(String string) {
            this.formatName = string;
        }

        public boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                String[] stringArray = imageReaderSpi.getFormatNames();
                for (int i = stringArray.length - 1; i >= 0; --i) {
                    if (!this.formatName.equals(stringArray[i])) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

