/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESedeKeySpec
implements KeySpec {
    public static final int DES_EDE_KEY_LEN = 24;
    private byte[] key;

    public DESedeKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESedeKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 24) {
            throw new InvalidKeyException("DES-EDE keys must be 24 bytes long");
        }
        this.key = new byte[24];
        System.arraycopy(byArray, n, this.key, 0, 24);
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 24) {
            throw new InvalidKeyException("DES-EDE keys must be 24 bytes long");
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < 24; ++i) {
            bl2 = false;
            for (int j = 0; j < 8; ++j) {
                bl2 ^= (byArray[i + n] & 1 << j) != 0;
            }
            bl &= bl2;
        }
        return bl;
    }

    public byte[] getKey() {
        return this.key;
    }
}

