/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher cipher;

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        this.cipher = cipher != null ? cipher : new NullCipher();
    }

    protected CipherOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void close() throws IOException {
        try {
            this.out.write(this.cipher.doFinal());
            this.out.flush();
            this.out.close();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(String.valueOf(exception));
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.cipher.update(byArray, n, n2);
        if (byArray2 != null) {
            this.out.write(byArray2);
        }
    }
}

