/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.classpath.debug.SystemLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private static final Logger logger = SystemLogger.SYSTEM;
    private final Cipher cipher;
    private byte[] outBuffer;
    private int outOffset;
    private final boolean isStream;
    private boolean eof;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
        this.isStream = cipher.getBlockSize() == 1;
        this.eof = false;
    }

    protected CipherInputStream(InputStream inputStream) {
        this(inputStream, new NullCipher());
    }

    public int available() throws IOException {
        if (this.isStream) {
            return super.available();
        }
        if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
            this.nextBlock();
        }
        return this.outBuffer.length - this.outOffset;
    }

    public synchronized void close() throws IOException {
        super.close();
    }

    public synchronized int read() throws IOException {
        if (this.isStream) {
            byte[] byArray = new byte[1];
            int n = super.read();
            if (n == -1) {
                return -1;
            }
            byArray[0] = (byte)n;
            try {
                this.cipher.update(byArray, 0, 1, byArray, 0);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IOException(shortBufferException.getMessage());
            }
            return byArray[0] & 0xFF;
        }
        if (this.outBuffer == null || this.outOffset == this.outBuffer.length) {
            if (this.eof) {
                return -1;
            }
            this.nextBlock();
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return (int)this.skip(n2);
        }
        if (this.isStream) {
            if ((n2 = super.read(byArray, n, n2)) > 0) {
                try {
                    this.cipher.update(byArray, n, n2, byArray, n);
                }
                catch (ShortBufferException shortBufferException) {
                    IOException iOException = new IOException("Short buffer for stream cipher -- this should not happen");
                    iOException.initCause(shortBufferException);
                    throw iOException;
                }
            }
            return n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.outBuffer == null || this.outOffset >= this.outBuffer.length) {
                if (this.eof) {
                    if (n3 != 0) break;
                    n3 = -1;
                    break;
                }
                this.nextBlock();
            }
            int n4 = Math.min(this.outBuffer.length - this.outOffset, n2 - n3);
            System.arraycopy(this.outBuffer, this.outOffset, byArray, n3 + n, n4);
            n3 += n4;
            this.outOffset += n4;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        if (this.isStream) {
            return super.skip(l);
        }
        long l2 = 0L;
        if (l > 0L && this.outBuffer != null && this.outOffset >= this.outBuffer.length) {
            l2 = this.outBuffer.length - this.outOffset;
            this.outOffset = this.outBuffer.length;
        }
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void nextBlock() throws IOException {
        byte[] byArray = new byte[this.cipher.getBlockSize()];
        try {
            try {
                this.outBuffer = null;
                this.outOffset = 0;
                while (this.outBuffer == null) {
                    int n = this.in.read(byArray);
                    if (n == -1) {
                        this.outBuffer = this.cipher.doFinal();
                        this.eof = true;
                        return;
                    }
                    this.outOffset = 0;
                    this.outBuffer = this.cipher.update(byArray, 0, n);
                }
                return;
            }
            catch (BadPaddingException badPaddingException) {
                IOException iOException = new IOException("bad padding");
                iOException.initCause(badPaddingException);
                throw iOException;
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                IOException iOException = new IOException("illegal block size");
                iOException.initCause(illegalBlockSizeException);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            throw throwable;
        }
    }
}

