/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import gnu.java.lang.CPStringBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailcapCommandMap
extends CommandMap {
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static boolean debug = false;
    private static final int NORMAL = 0;
    private static final int FALLBACK = 1;
    private Map<String, Map<String, List<String>>>[][] mailcaps;

    public MailcapCommandMap() {
        this.init(null);
    }

    public MailcapCommandMap(String string) throws IOException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init(fileReader);
        if (fileReader != null) {
            try {
                ((Reader)fileReader).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public MailcapCommandMap(InputStream inputStream) {
        this.init(new InputStreamReader(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void init(Reader reader) {
        Object object;
        int n;
        this.mailcaps = new Map[5][2];
        for (int i = 0; i < 5; ++i) {
            for (n = 0; n < 2; ++n) {
                this.mailcaps[i][n] = new LinkedHashMap<String, Map<String, List<String>>>();
            }
        }
        if (reader != null) {
            if (debug) {
                System.out.println("MailcapCommandMap: load PROG");
            }
            try {
                this.parse(0, reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load HOME");
        }
        try {
            object = System.getProperty("user.home");
            if (object != null) {
                this.parseFile(1, new CPStringBuilder((String)object).append(File.separatorChar).append(".mailcap").toString());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load SYS");
        }
        try {
            this.parseFile(2, new CPStringBuilder(System.getProperty("java.home")).append(File.separatorChar).append("lib").append(File.separatorChar).append("mailcap").toString());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load JAR");
        }
        if ((n = (object = this.getSystemResources("META-INF/mailcap")).size()) > 0) {
            for (int i = 0; i < n; ++i) {
                InputStreamReader inputStreamReader = null;
                URL uRL = (URL)object.get(i);
                if (debug) {
                    System.out.println("\t" + uRL.toString());
                }
                inputStreamReader = new InputStreamReader(uRL.openStream());
                this.parse(3, inputStreamReader);
                Object var9_12 = null;
                if (inputStreamReader == null) continue;
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException2) {}
                continue;
                {
                    catch (IOException iOException) {
                        if (debug) {
                            System.out.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                        }
                        var9_12 = null;
                        if (inputStreamReader == null) continue;
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (IOException iOException2) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var9_12 = null;
                    if (inputStreamReader != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        } else {
            this.parseResource(3, "/META-INF/mailcap");
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load DEF");
        }
        this.parseResource(4, "/META-INF/mailcap.default");
    }

    @Override
    public synchronized CommandInfo[] getPreferredCommands(String string) {
        ArrayList<CommandInfo> arrayList = new ArrayList<CommandInfo>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map<String, List<String>> map = this.getCommands(this.mailcaps[j][i], string);
                if (map == null) continue;
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String string2 = entry.getKey();
                    if (arrayList2.contains(string2)) continue;
                    List<String> list2 = entry.getValue();
                    String string3 = list2.get(0);
                    CommandInfo commandInfo = new CommandInfo(string2, string3);
                    arrayList.add(commandInfo);
                    arrayList2.add(string2);
                }
            }
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    @Override
    public synchronized CommandInfo[] getAllCommands(String string) {
        ArrayList<CommandInfo> arrayList = new ArrayList<CommandInfo>();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map<String, List<String>> map = this.getCommands(this.mailcaps[j][i], string);
                if (map == null) continue;
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String string2 = entry.getKey();
                    List<String> list2 = entry.getValue();
                    int n = list2.size();
                    for (int k = 0; k < n; ++k) {
                        String string3 = list2.get(k);
                        CommandInfo commandInfo = new CommandInfo(string2, string3);
                        arrayList.add(commandInfo);
                    }
                }
            }
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    @Override
    public synchronized CommandInfo getCommand(String string, String string2) {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map<String, List<String>> map = this.getCommands(this.mailcaps[j][i], string);
                if (map == null) continue;
                List<String> list2 = map.get(string2);
                if (list2 == null) {
                    list2 = map.get("x-java-" + string2);
                }
                if (list2 == null) continue;
                String string3 = list2.get(0);
                return new CommandInfo(string2, string3);
            }
        }
        return null;
    }

    public synchronized void addMailcap(String string) {
        if (debug) {
            System.out.println("MailcapCommandMap: add to PROG");
        }
        try {
            this.parse(0, new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized DataContentHandler createDataContentHandler(String string) {
        if (debug) {
            System.out.println("MailcapCommandMap: createDataContentHandler for " + string);
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                Map<String, List<String>> map;
                if (debug) {
                    System.out.println("  search DB #" + i);
                }
                if ((map = this.getCommands(this.mailcaps[j][i], string)) == null) continue;
                List<String> list2 = map.get("content-handler");
                if (list2 == null) {
                    list2 = map.get("x-java-content-handler");
                }
                if (list2 == null) continue;
                String string2 = list2.get(0);
                if (debug) {
                    System.out.println("  In " + MailcapCommandMap.nameOf(j) + ", content-handler=" + string2);
                }
                try {
                    Class<?> clazz = Class.forName(string2);
                    return (DataContentHandler)clazz.newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!debug) continue;
                    illegalAccessException.printStackTrace();
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!debug) continue;
                    classNotFoundException.printStackTrace();
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    if (!debug) continue;
                    instantiationException.printStackTrace();
                }
            }
        }
        return null;
    }

    public String[] getNativeCommands(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.addNativeCommands(arrayList, this.mailcaps[j][i], string);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private void addNativeCommands(List<String> list2, Map<String, Map<String, List<String>>> map, String string) {
        for (Map.Entry<String, Map<String, List<String>>> entry : map.entrySet()) {
            Map<String, List<String>> map2;
            String string2;
            String string3 = entry.getKey();
            if (!string3.equals(string) || (string2 = (map2 = entry.getValue()).get("view-command").get(0)) == null) continue;
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            cPStringBuilder.append(string);
            cPStringBuilder.append(';');
            cPStringBuilder.append(' ');
            cPStringBuilder.append(string2);
            for (Map.Entry<String, List<String>> entry2 : map2.entrySet()) {
                String string4 = entry2.getKey();
                List<String> list3 = entry2.getValue();
                if ("view-command".equals(string4)) continue;
                for (String string5 : list3) {
                    cPStringBuilder.append(';');
                    cPStringBuilder.append(' ');
                    cPStringBuilder.append(string4);
                    cPStringBuilder.append('=');
                    cPStringBuilder.append(string5);
                }
            }
            if (cPStringBuilder.length() <= 0) continue;
            list2.add(cPStringBuilder.toString());
        }
    }

    private static String nameOf(int n) {
        switch (n) {
            case 0: {
                return "PROG";
            }
            case 1: {
                return "HOME";
            }
            case 2: {
                return "SYS";
            }
            case 3: {
                return "JAR";
            }
            case 4: {
                return "DEF";
            }
        }
        return "ERR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFile(int n, String string) {
        FileReader fileReader = null;
        if (debug) {
            System.out.println("\t" + string);
        }
        fileReader = new FileReader(string);
        this.parse(n, fileReader);
        Object var6_4 = null;
        if (fileReader == null) return;
        try {
            ((Reader)fileReader).close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                if (debug) {
                    System.out.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                }
                Object var6_5 = null;
                if (fileReader == null) return;
                try {
                    ((Reader)fileReader).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileReader == null) throw throwable;
            try {
                ((Reader)fileReader).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseResource(int n, String string) {
        Reader reader;
        block10: {
            reader = null;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) break block10;
            if (debug) {
                System.out.println("\t" + string);
            }
            reader = new InputStreamReader(inputStream);
            this.parse(n, reader);
        }
        Object var6_6 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                if (debug) {
                    System.out.println(iOException.getClass().getName() + ": " + iOException.getMessage());
                }
                Object var6_7 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void parse(int n, Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        CPStringBuilder cPStringBuilder = null;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n2 = (string = string.trim()).length();
            if (n2 != 0 && string.charAt(0) != '#') {
                if (string.charAt(n2 - 1) == '\\') {
                    if (cPStringBuilder == null) {
                        cPStringBuilder = new CPStringBuilder();
                    }
                    cPStringBuilder.append(string.substring(0, n2 - 1));
                } else if (cPStringBuilder != null) {
                    cPStringBuilder.append(string);
                    this.parseEntry(n, cPStringBuilder.toString());
                    cPStringBuilder = null;
                } else {
                    this.parseEntry(n, string);
                }
            }
            string = bufferedReader.readLine();
        }
    }

    private void parseEntry(int n, String string) {
        String string2;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        boolean bl = false;
        boolean bl2 = false;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (c == '\\') {
                c = cArray[++i];
            }
            if (c == ';' && !bl) {
                string2 = cPStringBuilder.toString().trim();
                if ("x-java-fallback-entry".equals(string2)) {
                    bl2 = true;
                }
                arrayList.add(string2);
                cPStringBuilder.setLength(0);
                continue;
            }
            if (c == '\"') {
                bl = !bl;
            }
            cPStringBuilder.append(c);
        }
        String string3 = cPStringBuilder.toString().trim();
        if ("x-java-fallback-entry".equals(string3)) {
            bl2 = true;
        }
        arrayList.add(string3);
        n2 = arrayList.size();
        if (n2 < 2) {
            if (debug) {
                System.err.println("Invalid mailcap entry: " + string);
            }
            return;
        }
        Map<String, Map<String, List<String>>> map = bl2 ? this.mailcaps[n][1] : this.mailcaps[n][0];
        string2 = (String)arrayList.get(0);
        this.addField(map, string2, "view-command", (String)arrayList.get(1));
        for (int i = 2; i < n2; ++i) {
            this.addField(map, string2, null, (String)arrayList.get(i));
        }
    }

    private void addField(Map<String, Map<String, List<String>>> map, String string, String string2, String string3) {
        List<String> list2;
        int n;
        if (string2 == null && (n = string3.indexOf(61)) != -1) {
            string2 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        }
        if (string3.length() == 0 || string2 == null || string2.length() == 0) {
            return;
        }
        Map<String, List<String>> map2 = map.get(string);
        if (map2 == null) {
            map2 = new LinkedHashMap<String, List<String>>();
            map.put(string, map2);
        }
        if ((list2 = map2.get(string2)) == null) {
            list2 = new ArrayList<String>();
            map2.put(string2, list2);
        }
        list2.add(string3);
    }

    private Map<String, List<String>> getCommands(Map<String, Map<String, List<String>>> map, String string) {
        int n = string.indexOf(47);
        String string2 = new CPStringBuilder(string.substring(0, n)).append('/').append('*').toString();
        Map<String, List<String>> map2 = map.get(string);
        Map<String, List<String>> map3 = map.get(string2);
        if (map3 == null) {
            return map2;
        }
        if (map2 == null) {
            return map3;
        }
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.putAll(map2);
        for (String string3 : map3.keySet()) {
            List<String> list2 = map3.get(string3);
            List list3 = (List)linkedHashMap.get(string3);
            if (list3 == null) {
                linkedHashMap.put(string3, list2);
                continue;
            }
            list3.addAll(list2);
        }
        return linkedHashMap;
    }

    private List<URL> getSystemResources(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            Enumeration<URL> enumeration = ClassLoader.getSystemResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    static {
        try {
            String string = System.getProperty("javax.activation.debug");
            debug = Boolean.valueOf(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

