/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.Calendar;
import java.util.zip.ZipConstants;

public class ZipEntry
implements ZipConstants,
Cloneable {
    private static final byte KNOWN_SIZE = 1;
    private static final byte KNOWN_CSIZE = 2;
    private static final byte KNOWN_CRC = 4;
    private static final byte KNOWN_TIME = 8;
    private static final byte KNOWN_DOSTIME = 16;
    private static final byte KNOWN_EXTRA = 32;
    private final String name;
    private int size;
    private long compressedSize = -1L;
    private int crc;
    private String comment = null;
    private byte method = (byte)-1;
    private byte known = 0;
    private int dostime;
    private long time;
    private byte[] extra = null;
    int flags;
    int offset;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipEntry(String string) {
        int n = string.length();
        if (n > 65535) {
            throw new IllegalArgumentException("name length is " + n);
        }
        this.name = string;
    }

    public ZipEntry(ZipEntry zipEntry) {
        this(zipEntry, zipEntry.name);
    }

    ZipEntry(ZipEntry zipEntry, String string) {
        this.name = string;
        this.known = zipEntry.known;
        this.size = zipEntry.size;
        this.compressedSize = zipEntry.compressedSize;
        this.crc = zipEntry.crc;
        this.dostime = zipEntry.dostime;
        this.time = zipEntry.time;
        this.method = zipEntry.method;
        this.extra = zipEntry.extra;
        this.comment = zipEntry.comment;
    }

    final void setDOSTime(int n) {
        this.dostime = n;
        this.known = (byte)(this.known | 0x10);
        this.known = (byte)(this.known & 0xFFFFFFF7);
    }

    final int getDOSTime() {
        if ((this.known & 0x10) != 0) {
            return this.dostime;
        }
        if ((this.known & 8) != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.time);
            this.dostime = (calendar.get(1) - 1980 & 0x7F) << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
            this.known = (byte)(this.known | 0x10);
            return this.dostime;
        }
        return 0;
    }

    public Object clone() {
        ZipEntry zipEntry;
        if (this.getClass() == ZipEntry.class) {
            zipEntry = new ZipEntry(this);
        } else {
            try {
                zipEntry = (ZipEntry)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
        if (this.extra != null) {
            zipEntry.extra = new byte[this.extra.length];
            System.arraycopy(this.extra, 0, zipEntry.extra, 0, this.extra.length);
        }
        return zipEntry;
    }

    public String getName() {
        return this.name;
    }

    public void setTime(long l) {
        this.time = l;
        this.known = (byte)(this.known | 8);
        this.known = (byte)(this.known & 0xFFFFFFEF);
    }

    public long getTime() {
        this.parseExtra();
        if ((this.known & 8) != 0) {
            return this.time;
        }
        if ((this.known & 0x10) != 0) {
            int n = 2 * (this.dostime & 0x1F);
            int n2 = this.dostime >> 5 & 0x3F;
            int n3 = this.dostime >> 11 & 0x1F;
            int n4 = this.dostime >> 16 & 0x1F;
            int n5 = (this.dostime >> 21 & 0xF) - 1;
            int n6 = (this.dostime >> 25 & 0x7F) + 1980;
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.set(n6, n5, n4, n3, n2, n);
                this.time = calendar.getTimeInMillis();
                this.known = (byte)(this.known | 8);
                return this.time;
            }
            catch (RuntimeException runtimeException) {
                this.known = (byte)(this.known & 0xFFFFFFF7);
                return -1L;
            }
        }
        return -1L;
    }

    public void setSize(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.size = (int)l;
        this.known = (byte)(this.known | 1);
    }

    public long getSize() {
        return (this.known & 1) != 0 ? (long)this.size & 0xFFFFFFFFL : -1L;
    }

    public void setCompressedSize(long l) {
        this.compressedSize = l;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCrc(long l) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException();
        }
        this.crc = (int)l;
        this.known = (byte)(this.known | 4);
    }

    public long getCrc() {
        return (this.known & 4) != 0 ? (long)this.crc & 0xFFFFFFFFL : -1L;
    }

    public void setMethod(int n) {
        if (n != 0 && n != 8) {
            throw new IllegalArgumentException();
        }
        this.method = (byte)n;
    }

    public int getMethod() {
        return this.method;
    }

    public void setExtra(byte[] byArray) {
        if (byArray == null) {
            this.extra = null;
            return;
        }
        if (byArray.length > 65535) {
            throw new IllegalArgumentException();
        }
        this.extra = byArray;
    }

    private void parseExtra() {
        if ((this.known & 0x20) != 0) {
            return;
        }
        if (this.extra == null) {
            this.known = (byte)(this.known | 0x20);
            return;
        }
        try {
            int n;
            for (int i = 0; i < this.extra.length; i += n) {
                byte by;
                int n2 = this.extra[i++] & 0xFF | (this.extra[i++] & 0xFF) << 8;
                n = this.extra[i++] & 0xFF | (this.extra[i++] & 0xFF) << 8;
                if (n2 != 21589 || ((by = this.extra[i]) & 1) == 0) continue;
                long l = this.extra[i + 1] & 0xFF | (this.extra[i + 2] & 0xFF) << 8 | (this.extra[i + 3] & 0xFF) << 16 | (this.extra[i + 4] & 0xFF) << 24;
                this.setTime(l * 1000L);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.known = (byte)(this.known | 0x20);
    }

    public byte[] getExtra() {
        return this.extra;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 65535) {
            throw new IllegalArgumentException();
        }
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isDirectory() {
        int n = this.name.length();
        return n > 0 && this.name.charAt(n - 1) == '/';
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

