/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.StreamManipulator;

class OutputWindow {
    private static final int WINDOW_SIZE = 32768;
    private static final int WINDOW_MASK = Short.MAX_VALUE;
    private byte[] window = new byte[32768];
    private int window_end = 0;
    private int window_filled = 0;

    OutputWindow() {
    }

    public void write(int n) {
        if (this.window_filled++ == 32768) {
            throw new IllegalStateException("Window full");
        }
        this.window[this.window_end++] = (byte)n;
        this.window_end &= Short.MAX_VALUE;
    }

    private void slowRepeat(int n, int n2, int n3) {
        while (n2-- > 0) {
            this.window[this.window_end++] = this.window[n++];
            this.window_end &= Short.MAX_VALUE;
            n &= Short.MAX_VALUE;
        }
    }

    public void repeat(int n, int n2) {
        if ((this.window_filled += n) > 32768) {
            throw new IllegalStateException("Window full");
        }
        int n3 = this.window_end - n2 & Short.MAX_VALUE;
        int n4 = 32768 - n;
        if (n3 <= n4 && this.window_end < n4) {
            if (n <= n2) {
                System.arraycopy(this.window, n3, this.window, this.window_end, n);
                this.window_end += n;
            } else {
                while (n-- > 0) {
                    this.window[this.window_end++] = this.window[n3++];
                }
            }
        } else {
            this.slowRepeat(n3, n, n2);
        }
    }

    public int copyStored(StreamManipulator streamManipulator, int n) {
        int n2;
        int n3;
        if ((n = Math.min(Math.min(n, 32768 - this.window_filled), streamManipulator.getAvailableBytes())) > (n3 = 32768 - this.window_end)) {
            n2 = streamManipulator.copyBytes(this.window, this.window_end, n3);
            if (n2 == n3) {
                n2 += streamManipulator.copyBytes(this.window, 0, n - n3);
            }
        } else {
            n2 = streamManipulator.copyBytes(this.window, this.window_end, n);
        }
        this.window_end = this.window_end + n2 & Short.MAX_VALUE;
        this.window_filled += n2;
        return n2;
    }

    public void copyDict(byte[] byArray, int n, int n2) {
        if (this.window_filled > 0) {
            throw new IllegalStateException();
        }
        if (n2 > 32768) {
            n += n2 - 32768;
            n2 = 32768;
        }
        System.arraycopy(byArray, n, this.window, 0, n2);
        this.window_end = n2 & Short.MAX_VALUE;
    }

    public int getFreeSpace() {
        return 32768 - this.window_filled;
    }

    public int getAvailable() {
        return this.window_filled;
    }

    public int copyOutput(byte[] byArray, int n, int n2) {
        int n3 = this.window_end;
        if (n2 > this.window_filled) {
            n2 = this.window_filled;
        } else {
            n3 = this.window_end - this.window_filled + n2 & Short.MAX_VALUE;
        }
        int n4 = n2;
        int n5 = n2 - n3;
        if (n5 > 0) {
            System.arraycopy(this.window, 32768 - n5, byArray, n, n5);
            n += n5;
            n2 = n3;
        }
        System.arraycopy(this.window, n3 - n2, byArray, n, n2);
        this.window_filled -= n4;
        if (this.window_filled < 0) {
            throw new IllegalStateException();
        }
        return n4;
    }

    public void reset() {
        this.window_end = 0;
        this.window_filled = 0;
    }
}

