/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DataFormatException;
import java.util.zip.InflaterHuffmanTree;
import java.util.zip.StreamManipulator;

class InflaterDynHeader {
    private static final int LNUM = 0;
    private static final int DNUM = 1;
    private static final int BLNUM = 2;
    private static final int BLLENS = 3;
    private static final int LENS = 4;
    private static final int REPS = 5;
    private static final int[] repMin = new int[]{3, 3, 11};
    private static final int[] repBits = new int[]{2, 3, 7};
    private byte[] blLens;
    private byte[] litdistLens;
    private InflaterHuffmanTree blTree;
    private int mode;
    private int lnum;
    private int dnum;
    private int blnum;
    private int num;
    private int repSymbol;
    private byte lastLen;
    private int ptr;
    private static final int[] BL_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};

    public boolean decode(StreamManipulator streamManipulator) throws DataFormatException {
        block8: while (true) {
            switch (this.mode) {
                case 0: {
                    this.lnum = streamManipulator.peekBits(5);
                    if (this.lnum < 0) {
                        return false;
                    }
                    this.lnum += 257;
                    streamManipulator.dropBits(5);
                    this.mode = 1;
                }
                case 1: {
                    this.dnum = streamManipulator.peekBits(5);
                    if (this.dnum < 0) {
                        return false;
                    }
                    ++this.dnum;
                    streamManipulator.dropBits(5);
                    this.num = this.lnum + this.dnum;
                    this.litdistLens = new byte[this.num];
                    this.mode = 2;
                }
                case 2: {
                    this.blnum = streamManipulator.peekBits(4);
                    if (this.blnum < 0) {
                        return false;
                    }
                    this.blnum += 4;
                    streamManipulator.dropBits(4);
                    this.blLens = new byte[19];
                    this.ptr = 0;
                    this.mode = 3;
                }
                case 3: {
                    int n;
                    while (this.ptr < this.blnum) {
                        n = streamManipulator.peekBits(3);
                        if (n < 0) {
                            return false;
                        }
                        streamManipulator.dropBits(3);
                        this.blLens[InflaterDynHeader.BL_ORDER[this.ptr]] = (byte)n;
                        ++this.ptr;
                    }
                    this.blTree = new InflaterHuffmanTree(this.blLens);
                    this.blLens = null;
                    this.ptr = 0;
                    this.mode = 4;
                }
                case 4: {
                    int n;
                    while (((n = this.blTree.getSymbol(streamManipulator)) & 0xFFFFFFF0) == 0) {
                        this.litdistLens[this.ptr++] = this.lastLen = (byte)n;
                        if (this.ptr != this.num) continue;
                        return true;
                    }
                    if (n < 0) {
                        return false;
                    }
                    if (n >= 17) {
                        this.lastLen = 0;
                    } else if (this.ptr == 0) {
                        throw new DataFormatException();
                    }
                    this.repSymbol = n - 16;
                    this.mode = 5;
                }
                case 5: {
                    int n = repBits[this.repSymbol];
                    int n2 = streamManipulator.peekBits(n);
                    if (n2 < 0) {
                        return false;
                    }
                    streamManipulator.dropBits(n);
                    if (this.ptr + (n2 += repMin[this.repSymbol]) > this.num) {
                        throw new DataFormatException();
                    }
                    while (n2-- > 0) {
                        this.litdistLens[this.ptr++] = this.lastLen;
                    }
                    if (this.ptr == this.num) {
                        return true;
                    }
                    this.mode = 4;
                    continue block8;
                }
            }
        }
    }

    public InflaterHuffmanTree buildLitLenTree() throws DataFormatException {
        byte[] byArray = new byte[this.lnum];
        System.arraycopy(this.litdistLens, 0, byArray, 0, this.lnum);
        return new InflaterHuffmanTree(byArray);
    }

    public InflaterHuffmanTree buildDistTree() throws DataFormatException {
        byte[] byArray = new byte[this.dnum];
        System.arraycopy(this.litdistLens, this.lnum, byArray, 0, this.dnum);
        return new InflaterHuffmanTree(byArray);
    }
}

