/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.Adler32;
import java.util.zip.DataFormatException;
import java.util.zip.InflaterDynHeader;
import java.util.zip.InflaterHuffmanTree;
import java.util.zip.OutputWindow;
import java.util.zip.StreamManipulator;

public class Inflater {
    private static final int[] CPLENS = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    private static final int[] CPLEXT = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
    private static final int[] CPDIST = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
    private static final int[] CPDEXT = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int DECODE_HEADER = 0;
    private static final int DECODE_DICT = 1;
    private static final int DECODE_BLOCKS = 2;
    private static final int DECODE_STORED_LEN1 = 3;
    private static final int DECODE_STORED_LEN2 = 4;
    private static final int DECODE_STORED = 5;
    private static final int DECODE_DYN_HEADER = 6;
    private static final int DECODE_HUFFMAN = 7;
    private static final int DECODE_HUFFMAN_LENBITS = 8;
    private static final int DECODE_HUFFMAN_DIST = 9;
    private static final int DECODE_HUFFMAN_DISTBITS = 10;
    private static final int DECODE_CHKSUM = 11;
    private static final int FINISHED = 12;
    private int mode;
    private int readAdler;
    private int neededBits;
    private int repLength;
    private int repDist;
    private int uncomprLen;
    private boolean isLastBlock;
    private long totalOut;
    private long totalIn;
    private boolean nowrap;
    private StreamManipulator input;
    private OutputWindow outputWindow;
    private InflaterDynHeader dynHeader;
    private InflaterHuffmanTree litlenTree;
    private InflaterHuffmanTree distTree;
    private Adler32 adler;

    public Inflater() {
        this(false);
    }

    public Inflater(boolean bl) {
        this.nowrap = bl;
        this.adler = new Adler32();
        this.input = new StreamManipulator();
        this.outputWindow = new OutputWindow();
        this.mode = bl ? 2 : 0;
    }

    protected void finalize() {
    }

    public void end() {
        this.outputWindow = null;
        this.input = null;
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.adler = null;
    }

    public boolean finished() {
        return this.mode == 12 && this.outputWindow.getAvailable() == 0;
    }

    public int getAdler() {
        return this.needsDictionary() ? this.readAdler : (int)this.adler.getValue();
    }

    public int getRemaining() {
        return this.input.getAvailableBytes();
    }

    public int getTotalIn() {
        return (int)(this.totalIn - (long)this.getRemaining());
    }

    public long getBytesRead() {
        return this.totalIn - (long)this.getRemaining();
    }

    public int getTotalOut() {
        return (int)this.totalOut;
    }

    public long getBytesWritten() {
        return this.totalOut;
    }

    public int inflate(byte[] byArray) throws DataFormatException {
        return this.inflate(byArray, 0, byArray.length);
    }

    public int inflate(byte[] byArray, int n, int n2) throws DataFormatException {
        if (0 > n || n > n + n2 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 0;
        while (true) {
            if (this.outputWindow.getAvailable() == 0) {
                if (this.decode()) continue;
                break;
            }
            if (n2 <= 0) break;
            int n4 = this.outputWindow.copyOutput(byArray, n, n2);
            this.adler.update(byArray, n, n4);
            n += n4;
            n3 += n4;
            this.totalOut += (long)n4;
            n2 -= n4;
        }
        return n3;
    }

    public boolean needsDictionary() {
        return this.mode == 1 && this.neededBits == 0;
    }

    public boolean needsInput() {
        return this.input.needsInput();
    }

    public void reset() {
        this.mode = this.nowrap ? 2 : 0;
        this.totalOut = 0L;
        this.totalIn = 0L;
        this.input.reset();
        this.outputWindow.reset();
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.isLastBlock = false;
        this.adler.reset();
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public void setDictionary(byte[] byArray, int n, int n2) {
        if (!this.needsDictionary()) {
            throw new IllegalStateException();
        }
        this.adler.update(byArray, n, n2);
        if ((int)this.adler.getValue() != this.readAdler) {
            throw new IllegalArgumentException("Wrong adler checksum");
        }
        this.adler.reset();
        this.outputWindow.copyDict(byArray, n, n2);
        this.mode = 2;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public void setInput(byte[] byArray, int n, int n2) {
        this.input.setInput(byArray, n, n2);
        this.totalIn += (long)n2;
    }

    private boolean decodeHeader() throws DataFormatException {
        int n = this.input.peekBits(16);
        if (n < 0) {
            return false;
        }
        this.input.dropBits(16);
        n = (n << 8 | n >> 8) & 0xFFFF;
        if (n % 31 != 0) {
            throw new DataFormatException("Header checksum illegal");
        }
        if ((n & 0xF00) != 2048) {
            throw new DataFormatException("Compression Method unknown");
        }
        if ((n & 0x20) == 0) {
            this.mode = 2;
        } else {
            this.mode = 1;
            this.neededBits = 32;
        }
        return true;
    }

    private boolean decodeDict() {
        while (this.neededBits > 0) {
            int n = this.input.peekBits(8);
            if (n < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | n;
            this.neededBits -= 8;
        }
        return false;
    }

    private boolean decodeHuffman() throws DataFormatException {
        block10: for (int i = this.outputWindow.getFreeSpace(); i >= 258; i -= this.repLength) {
            switch (this.mode) {
                case 7: {
                    int n;
                    while (((n = this.litlenTree.getSymbol(this.input)) & 0xFFFFFF00) == 0) {
                        this.outputWindow.write(n);
                        if (--i >= 258) continue;
                        return true;
                    }
                    if (n < 257) {
                        if (n < 0) {
                            return false;
                        }
                        this.distTree = null;
                        this.litlenTree = null;
                        this.mode = 2;
                        return true;
                    }
                    try {
                        this.repLength = CPLENS[n - 257];
                        this.neededBits = CPLEXT[n - 257];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new DataFormatException("Illegal rep length code");
                    }
                }
                case 8: {
                    int n;
                    if (this.neededBits > 0) {
                        this.mode = 8;
                        n = this.input.peekBits(this.neededBits);
                        if (n < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repLength += n;
                    }
                    this.mode = 9;
                }
                case 9: {
                    int n = this.distTree.getSymbol(this.input);
                    if (n < 0) {
                        return false;
                    }
                    try {
                        this.repDist = CPDIST[n];
                        this.neededBits = CPDEXT[n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new DataFormatException("Illegal rep dist code");
                    }
                }
                case 10: {
                    int n;
                    if (this.neededBits > 0) {
                        this.mode = 10;
                        n = this.input.peekBits(this.neededBits);
                        if (n < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repDist += n;
                    }
                    this.outputWindow.repeat(this.repLength, this.repDist);
                    this.mode = 7;
                    continue block10;
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean decodeChksum() throws DataFormatException {
        while (this.neededBits > 0) {
            int n = this.input.peekBits(8);
            if (n < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | n;
            this.neededBits -= 8;
        }
        if ((int)this.adler.getValue() != this.readAdler) {
            throw new DataFormatException("Adler chksum doesn't match: " + Integer.toHexString((int)this.adler.getValue()) + " vs. " + Integer.toHexString(this.readAdler));
        }
        this.mode = 12;
        return false;
    }

    private boolean decode() throws DataFormatException {
        switch (this.mode) {
            case 0: {
                return this.decodeHeader();
            }
            case 1: {
                return this.decodeDict();
            }
            case 11: {
                return this.decodeChksum();
            }
            case 2: {
                if (this.isLastBlock) {
                    if (this.nowrap) {
                        this.mode = 12;
                        return false;
                    }
                    this.input.skipToByteBoundary();
                    this.neededBits = 32;
                    this.mode = 11;
                    return true;
                }
                int n = this.input.peekBits(3);
                if (n < 0) {
                    return false;
                }
                this.input.dropBits(3);
                if ((n & 1) != 0) {
                    this.isLastBlock = true;
                }
                switch (n >> 1) {
                    case 0: {
                        this.input.skipToByteBoundary();
                        this.mode = 3;
                        break;
                    }
                    case 1: {
                        this.litlenTree = InflaterHuffmanTree.defLitLenTree;
                        this.distTree = InflaterHuffmanTree.defDistTree;
                        this.mode = 7;
                        break;
                    }
                    case 2: {
                        this.dynHeader = new InflaterDynHeader();
                        this.mode = 6;
                        break;
                    }
                    default: {
                        throw new DataFormatException("Unknown block type " + n);
                    }
                }
                return true;
            }
            case 3: {
                this.uncomprLen = this.input.peekBits(16);
                if (this.uncomprLen < 0) {
                    return false;
                }
                this.input.dropBits(16);
                this.mode = 4;
            }
            case 4: {
                int n = this.input.peekBits(16);
                if (n < 0) {
                    return false;
                }
                this.input.dropBits(16);
                if (n != (this.uncomprLen ^ 0xFFFF)) {
                    throw new DataFormatException("broken uncompressed block");
                }
                this.mode = 5;
            }
            case 5: {
                int n = this.outputWindow.copyStored(this.input, this.uncomprLen);
                this.uncomprLen -= n;
                if (this.uncomprLen == 0) {
                    this.mode = 2;
                    return true;
                }
                return !this.input.needsInput();
            }
            case 6: {
                if (!this.dynHeader.decode(this.input)) {
                    return false;
                }
                this.litlenTree = this.dynHeader.buildLitLenTree();
                this.distTree = this.dynHeader.buildDistTree();
                this.mode = 7;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.decodeHuffman();
            }
            case 12: {
                return false;
            }
        }
        throw new IllegalStateException();
    }
}

