/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.util.zip.DeflaterEngine;
import java.util.zip.DeflaterPending;

public class Deflater {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int NO_COMPRESSION = 0;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFLATED = 8;
    private static final int IS_SETDICT = 1;
    private static final int IS_FLUSHING = 4;
    private static final int IS_FINISHING = 8;
    private static final int INIT_STATE = 0;
    private static final int SETDICT_STATE = 1;
    private static final int INIT_FINISHING_STATE = 8;
    private static final int SETDICT_FINISHING_STATE = 9;
    private static final int BUSY_STATE = 16;
    private static final int FLUSHING_STATE = 20;
    private static final int FINISHING_STATE = 28;
    private static final int FINISHED_STATE = 30;
    private static final int CLOSED_STATE = 127;
    private int level;
    private boolean noHeader;
    private int state;
    private long totalOut;
    private DeflaterPending pending;
    private DeflaterEngine engine;

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int n) {
        this(n, false);
    }

    public Deflater(int n, boolean bl) {
        if (n == -1) {
            n = 6;
        } else if (n < 0 || n > 9) {
            throw new IllegalArgumentException();
        }
        this.pending = new DeflaterPending();
        this.engine = new DeflaterEngine(this.pending);
        this.noHeader = bl;
        this.setStrategy(0);
        this.setLevel(n);
        this.reset();
    }

    public void reset() {
        this.state = this.noHeader ? 16 : 0;
        this.totalOut = 0L;
        this.pending.reset();
        this.engine.reset();
    }

    public void end() {
        this.engine = null;
        this.pending = null;
        this.state = 127;
    }

    public int getAdler() {
        return this.engine.getAdler();
    }

    public int getTotalIn() {
        return (int)this.engine.getTotalIn();
    }

    public long getBytesRead() {
        return this.engine.getTotalIn();
    }

    public int getTotalOut() {
        return (int)this.totalOut;
    }

    public long getBytesWritten() {
        return this.totalOut;
    }

    protected void finalize() {
    }

    void flush() {
        this.state |= 4;
    }

    public void finish() {
        this.state |= 0xC;
    }

    public boolean finished() {
        return this.state == 30 && this.pending.isFlushed();
    }

    public boolean needsInput() {
        return this.engine.needsInput();
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public void setInput(byte[] byArray, int n, int n2) {
        if ((this.state & 8) != 0) {
            throw new IllegalStateException("finish()/end() already called");
        }
        this.engine.setInput(byArray, n, n2);
    }

    public void setLevel(int n) {
        if (n == -1) {
            n = 6;
        } else if (n < 0 || n > 9) {
            throw new IllegalArgumentException();
        }
        if (this.level != n) {
            this.level = n;
            this.engine.setLevel(n);
        }
    }

    public void setStrategy(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.engine.setStrategy(n);
    }

    public int deflate(byte[] byArray) {
        return this.deflate(byArray, 0, byArray.length);
    }

    public int deflate(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = n2;
        if (this.state == 127) {
            throw new IllegalStateException("Deflater closed");
        }
        if (this.state < 16) {
            n4 = 30720;
            n3 = this.level - 1 >> 1;
            if (n3 < 0 || n3 > 3) {
                n3 = 3;
            }
            n4 |= n3 << 6;
            if ((this.state & 1) != 0) {
                n4 |= 0x20;
            }
            n4 += 31 - n4 % 31;
            this.pending.writeShortMSB(n4);
            if ((this.state & 1) != 0) {
                int n6 = this.engine.getAdler();
                this.engine.resetAdler();
                this.pending.writeShortMSB(n6 >> 16);
                this.pending.writeShortMSB(n6 & 0xFFFF);
            }
            this.state = 0x10 | this.state & 0xC;
        }
        while (true) {
            n4 = this.pending.flush(byArray, n, n2);
            n += n4;
            this.totalOut += (long)n4;
            if ((n2 -= n4) == 0 || this.state == 30) break;
            if (this.engine.deflate((this.state & 4) != 0, (this.state & 8) != 0)) continue;
            if (this.state == 16) {
                return n5 - n2;
            }
            if (this.state == 20) {
                if (this.level != 0) {
                    for (n3 = 8 + (-this.pending.getBitCount() & 7); n3 > 0; n3 -= 10) {
                        this.pending.writeBits(2, 10);
                    }
                }
                this.state = 16;
                continue;
            }
            if (this.state != 28) continue;
            this.pending.alignToByte();
            if (!this.noHeader) {
                n3 = this.engine.getAdler();
                this.pending.writeShortMSB(n3 >> 16);
                this.pending.writeShortMSB(n3 & 0xFFFF);
            }
            this.state = 30;
        }
        return n5 - n2;
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public void setDictionary(byte[] byArray, int n, int n2) {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        this.state = 1;
        this.engine.setDictionary(byArray, n, n2);
    }
}

