/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.classpath.toolkit.DefaultDaemonThreadFactory;
import gnu.java.lang.CPStringBuilder;
import gnu.java.util.prefs.NodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public abstract class AbstractPreferences
extends Preferences {
    protected final Object lock = new Object();
    protected boolean newNode = false;
    private final AbstractPreferences parent;
    private final String name;
    private boolean removed = false;
    private HashMap<String, AbstractPreferences> childCache = new HashMap();
    private ArrayList<NodeChangeListener> nodeListeners;
    private ArrayList<PreferenceChangeListener> preferenceListeners;

    protected AbstractPreferences(AbstractPreferences abstractPreferences, String string) {
        if (string == null || string.length() > 80 || abstractPreferences == null && string.length() != 0 || abstractPreferences != null && string.length() == 0 || string.indexOf(47) != -1) {
            throw new IllegalArgumentException("Illegal name argument '" + string + "' (parent is " + (abstractPreferences == null ? "" : "not ") + "null)");
        }
        this.parent = abstractPreferences;
        this.name = string;
    }

    public String absolutePath() {
        if (this.parent == null) {
            return "/";
        }
        return this.parent.path() + '/' + this.name;
    }

    private String path() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.path() + '/' + this.name;
    }

    public boolean isUserNode() {
        AbstractPreferences abstractPreferences = this;
        while (abstractPreferences.parent != null) {
            abstractPreferences = abstractPreferences.parent;
        }
        return abstractPreferences == Preferences.userRoot();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    protected final AbstractPreferences[] cachedChildren() {
        Collection<AbstractPreferences> collection = this.childCache.values();
        return collection.toArray(new AbstractPreferences[collection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.addAll((Collection<String>)this.childCache.keySet());
            String[] stringArray = this.childrenNamesSpi();
            for (int i = 0; i < stringArray.length; ++i) {
                treeSet.add(stringArray[i]);
            }
            String[] stringArray2 = new String[treeSet.size()];
            treeSet.toArray(stringArray2);
            return stringArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences node(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            if (!string.startsWith("/")) {
                if (string.indexOf("//") != -1 || string.endsWith("/")) {
                    throw new IllegalArgumentException(string);
                }
                return this.getNode(string);
            }
        }
        object = this.isUserNode() ? AbstractPreferences.userRoot() : AbstractPreferences.systemRoot();
        return ((Preferences)object).node(string.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences getNode(String string) {
        String string2;
        String string3;
        if (string.length() == 0) {
            return this;
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        AbstractPreferences abstractPreferences = this.childCache.get(string3);
        if (abstractPreferences == null) {
            if (string3.length() > 80) {
                throw new IllegalArgumentException(string3);
            }
            abstractPreferences = this.childSpi(string3);
            this.childCache.put(string3, abstractPreferences);
            if (abstractPreferences.newNode && this.nodeListeners != null) {
                this.fire(new NodeChangeEvent(this, abstractPreferences), true);
            }
        }
        Object object = abstractPreferences.lock;
        synchronized (object) {
            return abstractPreferences.getNode(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeExists(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved() && string.length() != 0) {
                throw new IllegalStateException("Node removed");
            }
            if (!string.startsWith("/")) {
                if (string.indexOf("//") != -1 || string.endsWith("/")) {
                    throw new IllegalArgumentException(string);
                }
                return this.existsNode(string);
            }
        }
        object = this.isUserNode() ? AbstractPreferences.userRoot() : AbstractPreferences.systemRoot();
        return ((Preferences)object).nodeExists(string.substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsNode(String string) throws BackingStoreException {
        String string2;
        String string3;
        if (string.length() == 0) {
            return !this.isRemoved();
        }
        int n = string.indexOf(47);
        if (n == -1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        AbstractPreferences abstractPreferences = this.childCache.get(string3);
        if (abstractPreferences == null) {
            if (string3.length() > 80) {
                throw new IllegalArgumentException(string3);
            }
            abstractPreferences = this.getChild(string3);
            if (abstractPreferences == null) {
                return false;
            }
            this.childCache.put(string3, abstractPreferences);
        }
        Object object = abstractPreferences.lock;
        synchronized (object) {
            return abstractPreferences.existsNode(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractPreferences getChild(String string) throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            String[] stringArray = this.childrenNamesSpi();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return this.childSpi(string);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRemoved() {
        Object object = this.lock;
        synchronized (object) {
            return this.removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Preferences parent() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.parent;
        }
    }

    public void exportNode(OutputStream outputStream) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter(this, outputStream);
        nodeWriter.writePrefs();
    }

    public void exportSubtree(OutputStream outputStream) throws BackingStoreException, IOException {
        NodeWriter nodeWriter = new NodeWriter(this, outputStream);
        nodeWriter.writePrefsTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] keys() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            return this.keysSpi();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string, String string2) {
        if (string.length() > 80) {
            throw new IllegalArgumentException(string);
        }
        Object object = this.lock;
        synchronized (object) {
            String string3;
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            try {
                string3 = this.getSpi(string);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                string3 = null;
            }
            if (string3 != null) {
                return string3;
            }
            return string2;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string, null);
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        return bl;
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        String string2 = this.get(string, null);
        byte[] byArray2 = null;
        if (string2 != null) {
            byArray2 = AbstractPreferences.decode64(string2);
        }
        if (byArray2 != null) {
            return byArray2;
        }
        return byArray;
    }

    private static byte[] decode64(String string) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() / 4 * 3);
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n2 = -1;
        for (n = 0; n < cArray.length && n2 == -1; ++n) {
            if (cArray[n] >= 'A' && cArray[n] <= 'Z') {
                int n3 = n;
                cArray[n3] = (char)(cArray[n3] - 65);
                continue;
            }
            if (cArray[n] >= 'a' && cArray[n] <= 'z') {
                cArray[n] = (char)(cArray[n] + 26 - 97);
                continue;
            }
            if (cArray[n] >= '0' && cArray[n] <= '9') {
                cArray[n] = (char)(cArray[n] + 52 - 48);
                continue;
            }
            if (cArray[n] == '+') {
                cArray[n] = 62;
                continue;
            }
            if (cArray[n] == '/') {
                cArray[n] = 63;
                continue;
            }
            if (cArray[n] == '=') {
                n2 = n;
                continue;
            }
            return null;
        }
        int n4 = 0;
        for (n = n2 == -1 ? cArray.length : n2; n > 0; n -= 4) {
            byte by;
            byte by2 = (byte)(cArray[n4] << 2);
            if (n >= 2) {
                by2 = (byte)(by2 + ((cArray[n4 + 1] & 0x30) >> 4));
            }
            byteArrayOutputStream.write(by2);
            if (n >= 3) {
                by = (byte)((cArray[n4 + 1] & 0xF) << 4);
                by = (byte)(by + (byte)((cArray[n4 + 2] & 0x3C) >> 2));
                byteArrayOutputStream.write(by);
            }
            if (n >= 4) {
                by = (byte)((cArray[n4 + 2] & 3) << 6);
                by = (byte)(by + cArray[n4 + 3]);
                byteArrayOutputStream.write(by);
            }
            n4 += 4;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public double getDouble(String string, double d) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public float getFloat(String string, float f) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public long getLong(String string, long l) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2) {
        if (string.length() > 80 || string2.length() > 8192) {
            throw new IllegalArgumentException("key (" + string.length() + ") or value (" + string2.length() + ") to large");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.putSpi(string, string2);
            if (this.preferenceListeners != null) {
                this.fire(new PreferenceChangeEvent(this, string, string2));
            }
        }
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, Boolean.toString(bl));
    }

    public void putByteArray(String string, byte[] byArray) {
        this.put(string, AbstractPreferences.encode64(byArray));
    }

    private static String encode64(byte[] byArray) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(byArray.length / 3 * 4);
        int n = 0;
        char[] cArray = new char[4];
        for (int i = byArray.length; i > 0; i -= 3) {
            cArray[0] = (char)((byArray[n] & 0xFC) >> 2);
            cArray[1] = (char)((byArray[n] & 3) << 4);
            if (i >= 2) {
                cArray[1] = (char)(cArray[1] + (char)((byArray[n + 1] & 0xF0) >> 4));
                cArray[2] = (char)((byArray[n + 1] & 0xF) << 2);
                if (i >= 3) {
                    cArray[2] = (char)(cArray[2] + (char)((byArray[n + 2] & 0xC0) >> 6));
                    cArray[3] = (char)(byArray[n + 2] & 0x3F);
                } else {
                    cArray[3] = 64;
                }
            } else {
                cArray[2] = 64;
                cArray[3] = 64;
            }
            for (int j = 0; j < 4; ++j) {
                if (cArray[j] < '\u001a') {
                    int n2 = j;
                    cArray[n2] = (char)(cArray[n2] + 65);
                    continue;
                }
                cArray[j] = cArray[j] < '4' ? (int)(cArray[j] - 26 + 97) : (cArray[j] < '>' ? (int)(cArray[j] - 52 + 48) : (cArray[j] == '>' ? 43 : (cArray[j] == '?' ? 47 : 61)));
            }
            cPStringBuilder.append(cArray);
            n += 3;
        }
        return cPStringBuilder.toString();
    }

    public void putDouble(String string, double d) {
        this.put(string, Double.toString(d));
    }

    public void putFloat(String string, float f) {
        this.put(string, Float.toString(f));
    }

    public void putInt(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void putLong(String string, long l) {
        this.put(string, Long.toString(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        if (string.length() > 80) {
            throw new IllegalArgumentException(string);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node removed");
            }
            this.removeSpi(string);
            if (this.preferenceListeners != null) {
                this.fire(new PreferenceChangeEvent(this, string, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws BackingStoreException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("Node Removed");
            }
            String[] stringArray = this.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                this.removeSpi(stringArray[i]);
            }
        }
    }

    public void flush() throws BackingStoreException {
        this.flushNode(false);
    }

    public void sync() throws BackingStoreException {
        this.flushNode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNode(boolean bl) throws BackingStoreException {
        String[] stringArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (bl) {
                this.syncSpi();
            } else {
                this.flushSpi();
            }
            stringArray = this.childCache.keySet().toArray(new String[0]);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                AbstractPreferences abstractPreferences;
                Object object2 = this.lock;
                synchronized (object2) {
                    abstractPreferences = this.childCache.get(stringArray[i]);
                }
                if (abstractPreferences == null) continue;
                abstractPreferences.flushNode(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Cannot remove root node");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.isRemoved()) {
                    throw new IllegalStateException("Node Removed");
                }
                this.purge();
            }
            this.parent.childCache.remove(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() throws BackingStoreException {
        String[] stringArray = this.childrenNamesSpi();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.childCache.get(stringArray[i]) != null) continue;
            this.childCache.put(stringArray[i], this.childSpi(stringArray[i]));
        }
        for (AbstractPreferences abstractPreferences : this.childCache.values()) {
            Object object = abstractPreferences.lock;
            synchronized (object) {
                abstractPreferences.purge();
            }
        }
        this.childCache.clear();
        this.removeNodeSpi();
        this.removed = true;
        if (this.nodeListeners != null) {
            this.fire(new NodeChangeEvent(this.parent, this), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (nodeChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.nodeListeners == null) {
                this.nodeListeners = new ArrayList();
            }
            this.nodeListeners.add(nodeChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (preferenceChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.preferenceListeners == null) {
                this.preferenceListeners = new ArrayList();
            }
            this.preferenceListeners.add(preferenceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (nodeChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.nodeListeners != null) {
                this.nodeListeners.remove(nodeChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRemoved()) {
                throw new IllegalStateException("node has been removed");
            }
            if (preferenceChangeListener == null) {
                throw new NullPointerException("listener is null");
            }
            if (this.preferenceListeners != null) {
                this.preferenceListeners.remove(preferenceChangeListener);
            }
        }
    }

    private void fire(final PreferenceChangeEvent preferenceChangeEvent) {
        for (final PreferenceChangeListener preferenceChangeListener : this.preferenceListeners) {
            Runnable runnable = new Runnable(){

                public void run() {
                    preferenceChangeListener.preferenceChange(preferenceChangeEvent);
                }
            };
            ExecutorService executorService = Executors.newSingleThreadExecutor(new DefaultDaemonThreadFactory());
            executorService.execute(runnable);
        }
    }

    private void fire(final NodeChangeEvent nodeChangeEvent, final boolean bl) {
        for (final NodeChangeListener nodeChangeListener : this.nodeListeners) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (bl) {
                        nodeChangeListener.childAdded(nodeChangeEvent);
                    } else {
                        nodeChangeListener.childRemoved(nodeChangeEvent);
                    }
                }
            };
            ExecutorService executorService = Executors.newSingleThreadExecutor(new DefaultDaemonThreadFactory());
            executorService.execute(runnable);
        }
    }

    protected abstract String[] childrenNamesSpi() throws BackingStoreException;

    protected abstract AbstractPreferences childSpi(String var1);

    protected abstract String[] keysSpi() throws BackingStoreException;

    protected abstract String getSpi(String var1);

    protected abstract void putSpi(String var1, String var2);

    protected abstract void removeSpi(String var1);

    protected abstract void flushSpi() throws BackingStoreException;

    protected abstract void syncSpi() throws BackingStoreException;

    protected abstract void removeNodeSpi() throws BackingStoreException;
}

