/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import gnu.java.lang.CPStringBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class XMLFormatter
extends Formatter {
    private static final String lineSep = SimpleFormatter.lineSep;
    private final SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private static void appendTag(CPStringBuilder cPStringBuilder, int n, String string, String string2) {
        int n2;
        if (string2 == null) {
            return;
        }
        for (n2 = 0; n2 < n * 2; ++n2) {
            cPStringBuilder.append(' ');
        }
        cPStringBuilder.append("<");
        cPStringBuilder.append(string);
        cPStringBuilder.append('>');
        block6: for (n2 = 0; n2 < string2.length(); ++n2) {
            char c = string2.charAt(n2);
            switch (c) {
                case '&': {
                    cPStringBuilder.append("&amp;");
                    continue block6;
                }
                case '<': {
                    cPStringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    cPStringBuilder.append("&gt;");
                    continue block6;
                }
                default: {
                    if (c >= ' ' && c <= '~' || c == '\n' || c == '\r') {
                        cPStringBuilder.append(c);
                        continue block6;
                    }
                    cPStringBuilder.append("&#");
                    cPStringBuilder.append((int)c);
                    cPStringBuilder.append(';');
                }
            }
        }
        cPStringBuilder.append("</");
        cPStringBuilder.append(string);
        cPStringBuilder.append(">");
        cPStringBuilder.append(lineSep);
    }

    private static void appendTag(CPStringBuilder cPStringBuilder, int n, String string, long l) {
        XMLFormatter.appendTag(cPStringBuilder, n, string, Long.toString(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord logRecord) {
        String string;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(400);
        Level level = logRecord.getLevel();
        long l = logRecord.getMillis();
        Object[] objectArray = logRecord.getParameters();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        cPStringBuilder.append("<record>");
        cPStringBuilder.append(lineSep);
        XMLFormatter.appendTag(cPStringBuilder, 1, "date", this.iso8601.format(new Date(l)));
        XMLFormatter.appendTag(cPStringBuilder, 1, "millis", l);
        XMLFormatter.appendTag(cPStringBuilder, 1, "sequence", logRecord.getSequenceNumber());
        XMLFormatter.appendTag(cPStringBuilder, 1, "logger", logRecord.getLoggerName());
        if (level.isStandardLevel()) {
            XMLFormatter.appendTag(cPStringBuilder, 1, "level", level.toString());
        } else {
            XMLFormatter.appendTag(cPStringBuilder, 1, "level", level.intValue());
        }
        XMLFormatter.appendTag(cPStringBuilder, 1, "class", logRecord.getSourceClassName());
        XMLFormatter.appendTag(cPStringBuilder, 1, "method", logRecord.getSourceMethodName());
        XMLFormatter.appendTag(cPStringBuilder, 1, "thread", logRecord.getThreadID());
        try {
            logRecord.setResourceBundle(null);
            string = this.formatMessage(logRecord);
            Object var10_8 = null;
            logRecord.setResourceBundle(resourceBundle);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            logRecord.setResourceBundle(resourceBundle);
            throw throwable;
        }
        XMLFormatter.appendTag(cPStringBuilder, 1, "message", string);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            cPStringBuilder.append("  <exception>");
            cPStringBuilder.append(lineSep);
            XMLFormatter.appendTag(cPStringBuilder, 2, "message", throwable.toString());
            cPStringBuilder.append("  </exception>");
            cPStringBuilder.append(lineSep);
        }
        cPStringBuilder.append("</record>");
        cPStringBuilder.append(lineSep);
        return cPStringBuilder.toString();
    }

    public String getHead(Handler handler) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(80);
        cPStringBuilder.append("<?xml version=\"1.0\" encoding=\"");
        String string = handler.getEncoding();
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        if (string == null) {
            string = "UTF-8";
        }
        if (string.length() > 2 && string.startsWith("Cp")) {
            string = "windows-" + string.substring(2);
        }
        cPStringBuilder.append(string);
        cPStringBuilder.append("\" standalone=\"no\"?>");
        cPStringBuilder.append(lineSep);
        cPStringBuilder.append("<!DOCTYPE log SYSTEM \"logger.dtd\">");
        cPStringBuilder.append(lineSep);
        cPStringBuilder.append("<log>");
        cPStringBuilder.append(lineSep);
        return cPStringBuilder.toString();
    }

    public String getTail(Handler handler) {
        return "</log>" + lineSep;
    }
}

