/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public class SocketHandler
extends StreamHandler {
    public SocketHandler() throws IOException {
        this(LogManager.getLogManager().getProperty("java.util.logging.SocketHandler.host"), SocketHandler.getPortNumber());
    }

    public SocketHandler(String string, int n) throws IOException {
        super(SocketHandler.createSocket(string, n), "java.util.logging.SocketHandler", Level.ALL, null, XMLFormatter.class);
    }

    private static int getPortNumber() {
        try {
            return Integer.parseInt(LogManager.getLogManager().getProperty("java.util.logging.SocketHandler.port"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    private static OutputStream createSocket(String string, int n) throws IOException, IllegalArgumentException {
        if (string == null || n < 1) {
            throw new IllegalArgumentException();
        }
        Socket socket = new Socket(string, n);
        socket.shutdownInput();
        socket.setTcpNoDelay(true);
        return socket.getOutputStream();
    }

    public void publish(LogRecord logRecord) {
        super.publish(logRecord);
        this.flush();
    }
}

