/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import gnu.java.lang.CPStringBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    private DateFormat dateFormat;
    static final String lineSep = System.getProperty("line.separator");

    public String format(LogRecord logRecord) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(180);
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance();
        }
        cPStringBuilder.append(this.dateFormat.format(new Date(logRecord.getMillis())));
        cPStringBuilder.append(' ');
        cPStringBuilder.append(logRecord.getSourceClassName());
        cPStringBuilder.append(' ');
        cPStringBuilder.append(logRecord.getSourceMethodName());
        cPStringBuilder.append(lineSep);
        cPStringBuilder.append(logRecord.getLevel());
        cPStringBuilder.append(": ");
        cPStringBuilder.append(this.formatMessage(logRecord));
        cPStringBuilder.append(lineSep);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter, true));
            cPStringBuilder.append(stringWriter.toString());
        }
        return cPStringBuilder.toString();
    }
}

