/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import gnu.java.lang.CPStringBuilder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger {
    static final Logger root = new Logger("", null);
    public static final Logger global;
    private static final Object[] lock;
    private final String name;
    private String resourceBundleName;
    private ResourceBundle resourceBundle;
    private Filter filter;
    private final List handlerList = new ArrayList(4);
    private Handler[] handlers = new Handler[0];
    private boolean anonymous;
    private boolean useParentHandlers;
    private Level level;
    private Logger parent;

    protected Logger(String string, String string2) throws MissingResourceException {
        this.name = string;
        this.resourceBundleName = string2;
        this.resourceBundle = string2 == null ? null : ResourceBundle.getBundle(string2);
        this.level = null;
        this.parent = root;
        this.useParentHandlers = this.parent != null;
    }

    public static Logger getLogger(String string) {
        return Logger.getLogger(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String string, String string2) {
        LogManager logManager = LogManager.getLogManager();
        if (string == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = lock;
        synchronized (lock) {
            Logger logger;
            LogManager logManager2 = logManager;
            synchronized (logManager2) {
                logger = logManager.getLogger(string);
                if (logger == null) {
                    logger = new Logger(string, string2);
                    boolean bl = logManager.addLogger(logger);
                    if (!bl) {
                        throw new IllegalStateException("cannot register new logger");
                    }
                } else {
                    String string3 = logger.getResourceBundleName();
                    if (string3 == null && string2 != null) {
                        logger.resourceBundle = ResourceBundle.getBundle(string2);
                        logger.resourceBundleName = string2;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 7, 10] lbl21 : MonitorExitStatement: MONITOREXIT : var5_4
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        return logger;
                    }
                    if (!(string3 == string2 || string3 != null && string3.equals(string2))) {
                        throw new IllegalArgumentException();
                    }
                }
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return logger;
        }
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    public static Logger getAnonymousLogger(String string) throws MissingResourceException {
        Logger logger = new Logger(null, string);
        logger.anonymous = true;
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceBundleName() {
        Object[] objectArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.resourceBundleName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle() {
        Object[] objectArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.resourceBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level getLevel() {
        Object[] objectArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoggable(Level level) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.level != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.level.intValue() <= level.intValue();
            }
            if (this.parent != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.parent.isLoggable(level);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level level) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (!this.anonymous) {
                LogManager.getLogManager().checkAccess();
            }
            this.level = level;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter() {
        Object[] objectArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.filter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Filter filter) throws SecurityException {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (!this.anonymous) {
                LogManager.getLogManager().checkAccess();
            }
            this.filter = filter;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogRecord logRecord) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (!this.isLoggable(logRecord.getLevel())) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.filter != null && !this.filter.isLoggable(logRecord)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (logRecord.getLoggerName() == null) {
                logRecord.setLoggerName(this.name);
            }
            LogManager logManager = LogManager.getLogManager();
            synchronized (logManager) {
                Logger logger = this;
                do {
                    for (int i = 0; i < logger.handlers.length; ++i) {
                        logger.handlers[i].publish(logRecord);
                    }
                    if (!logger.getUseParentHandlers()) break;
                    logger = logger.getParent();
                } while (this.parent != null);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void log(Level level, String string) {
        if (this.isLoggable(level)) {
            this.log(level, string, (Object[])null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String string, Object object) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(level)) {
                StackTraceElement stackTraceElement = this.getCallerStackFrame();
                this.logp(level, stackTraceElement != null ? stackTraceElement.getClassName() : "<unknown>", stackTraceElement != null ? stackTraceElement.getMethodName() : "<unknown>", string, object);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String string, Object[] objectArray) {
        Object[] objectArray2 = lock;
        synchronized (lock) {
            if (this.isLoggable(level)) {
                StackTraceElement stackTraceElement = this.getCallerStackFrame();
                this.logp(level, stackTraceElement != null ? stackTraceElement.getClassName() : "<unknown>", stackTraceElement != null ? stackTraceElement.getMethodName() : "<unknown>", string, objectArray);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String string, Throwable throwable) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(level)) {
                StackTraceElement stackTraceElement = this.getCallerStackFrame();
                this.logp(level, stackTraceElement != null ? stackTraceElement.getClassName() : "<unknown>", stackTraceElement != null ? stackTraceElement.getMethodName() : "<unknown>", string, throwable);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logp(Level level, String string, String string2, String string3) {
        Object[] objectArray = lock;
        synchronized (lock) {
            this.logp(level, string, string2, string3, (Object[])null);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logp(Level level, String string, String string2, String string3, Object object) {
        Object[] objectArray = lock;
        synchronized (lock) {
            this.logp(level, string, string2, string3, new Object[]{object});
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle findResourceBundle() {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.resourceBundle != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.resourceBundle;
            }
            if (this.parent != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.parent.findResourceBundle();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logImpl(Level level, String string, String string2, String string3, Object[] objectArray) {
        Object[] objectArray2 = lock;
        synchronized (lock) {
            LogRecord logRecord = new LogRecord(level, string3);
            logRecord.setResourceBundle(this.findResourceBundle());
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(objectArray);
            this.log(logRecord);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        Object[] objectArray2 = lock;
        synchronized (lock) {
            this.logImpl(level, string, string2, string3, objectArray);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        Object[] objectArray = lock;
        synchronized (lock) {
            LogRecord logRecord = new LogRecord(level, string3);
            logRecord.setResourceBundle(this.resourceBundle);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setThrown(throwable);
            this.log(logRecord);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logrb(Level level, String string, String string2, String string3, String string4) {
        Object[] objectArray = lock;
        synchronized (lock) {
            this.logrb(level, string, string2, string3, string4, (Object[])null);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        Object[] objectArray = lock;
        synchronized (lock) {
            this.logrb(level, string, string2, string3, string4, new Object[]{object});
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        Object[] objectArray2 = lock;
        synchronized (lock) {
            LogRecord logRecord = new LogRecord(level, string4);
            logRecord.setResourceBundleName(string3);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setParameters(objectArray);
            this.log(logRecord);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        Object[] objectArray = lock;
        synchronized (lock) {
            LogRecord logRecord = new LogRecord(level, string4);
            logRecord.setResourceBundleName(string3);
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
            logRecord.setThrown(throwable);
            this.log(logRecord);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entering(String string, String string2) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINER)) {
                this.logp(Level.FINER, string, string2, "ENTRY");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entering(String string, String string2, Object object) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINER)) {
                this.logp(Level.FINER, string, string2, "ENTRY {0}", object);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entering(String string, String string2, Object[] objectArray) {
        Object[] objectArray2 = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINER)) {
                CPStringBuilder cPStringBuilder = new CPStringBuilder(80);
                cPStringBuilder.append("ENTRY");
                for (int i = 0; i < objectArray.length; ++i) {
                    cPStringBuilder.append(" {");
                    cPStringBuilder.append(i);
                    cPStringBuilder.append('}');
                }
                this.logp(Level.FINER, string, string2, cPStringBuilder.toString(), objectArray);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exiting(String string, String string2) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINER)) {
                this.logp(Level.FINER, string, string2, "RETURN");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exiting(String string, String string2, Object object) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINER)) {
                this.logp(Level.FINER, string, string2, "RETURN {0}", object);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwing(String string, String string2, Throwable throwable) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINER)) {
                this.logp(Level.FINER, string, string2, "THROW", throwable);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void severe(String string) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.SEVERE)) {
                this.log(Level.SEVERE, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warning(String string) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String string) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void config(String string) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fine(String string) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finer(String string) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINER)) {
                this.log(Level.FINER, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finest(String string) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (this.isLoggable(Level.FINEST)) {
                this.log(Level.FINEST, string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler) throws SecurityException {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (handler == null) {
                throw new NullPointerException();
            }
            if (!this.anonymous) {
                LogManager.getLogManager().checkAccess();
            }
            if (!this.handlerList.contains(handler)) {
                this.handlerList.add(handler);
                this.handlers = this.getHandlers();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandler(Handler handler) throws SecurityException {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (!this.anonymous) {
                LogManager.getLogManager().checkAccess();
            }
            if (handler == null) {
                throw new NullPointerException();
            }
            this.handlerList.remove(handler);
            this.handlers = this.getHandlers();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler[] getHandlers() {
        Object[] objectArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.handlerList.toArray(new Handler[this.handlerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUseParentHandlers() {
        Object[] objectArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.useParentHandlers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseParentHandlers(boolean bl) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (!this.anonymous) {
                LogManager.getLogManager().checkAccess();
            }
            this.useParentHandlers = bl;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getParent() {
        Object[] objectArray = lock;
        synchronized (lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(Logger logger) {
        Object[] objectArray = lock;
        synchronized (lock) {
            if (logger == null) {
                throw new NullPointerException();
            }
            if (this == root) {
                throw new IllegalArgumentException("the root logger can only have a null parent");
            }
            if (!this.anonymous) {
                LogManager.getLogManager().checkAccess();
            }
            this.parent = logger;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private StackTraceElement getCallerStackFrame() {
        int n;
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (n = 0; n < stackTraceElementArray.length && !stackTraceElementArray[n].getClassName().equals(this.getClass().getName()); ++n) {
        }
        while (n < stackTraceElementArray.length && stackTraceElementArray[n].getClassName().equals(this.getClass().getName())) {
            ++n;
        }
        return n < stackTraceElementArray.length ? stackTraceElementArray[n] : null;
    }

    void resetLogger() {
        for (int i = 0; i < this.handlers.length; ++i) {
            this.handlers[i].close();
            this.handlerList.remove(this.handlers[i]);
        }
        this.handlers = this.getHandlers();
    }

    static {
        lock = new Object[0];
        global = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Logger.getLogger("global");
            }
        });
    }
}

