/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import gnu.java.io.Base64InputStream;
import gnu.java.security.OID;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import gnu.java.security.provider.Gnu;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String META_INF = "META-INF/";
    private static final String PKCS7_DSA_SUFFIX = ".DSA";
    private static final String PKCS7_RSA_SUFFIX = ".RSA";
    private static final String DIGEST_KEY_SUFFIX = "-Digest";
    private static final String SF_SUFFIX = ".SF";
    static final Gnu provider = new Gnu();
    private static final OID MD2_OID = new OID("1.2.840.113549.2.2");
    private static final OID MD4_OID = new OID("1.2.840.113549.2.4");
    private static final OID MD5_OID = new OID("1.2.840.113549.2.5");
    private static final OID SHA1_OID = new OID("1.3.14.3.2.26");
    private static final OID DSA_ENCRYPTION_OID = new OID("1.2.840.10040.4.1");
    private static final OID RSA_ENCRYPTION_OID = new OID("1.2.840.113549.1.1.1");
    private Manifest manifest;
    boolean verify;
    private boolean manifestRead = false;
    boolean signaturesRead = false;
    HashMap verified = new HashMap();
    HashMap entryCerts;
    private HashMap digestAlgorithms = new HashMap();
    static boolean DEBUG = false;

    static void debug(Object object) {
        System.err.print(JarFile.class.getName());
        System.err.print(" >>> ");
        System.err.println(object);
    }

    public JarFile(String string) throws FileNotFoundException, IOException {
        this(string, true);
    }

    public JarFile(String string, boolean bl) throws FileNotFoundException, IOException {
        super(string);
        if (bl) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file) throws FileNotFoundException, IOException {
        this(file, true);
    }

    public JarFile(File file, boolean bl) throws FileNotFoundException, IOException {
        super(file);
        if (bl) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file, boolean bl, int n) throws FileNotFoundException, IOException, IllegalArgumentException {
        super(file, n);
        if (bl) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    private void verify() {
        if (this.manifest == null) {
            this.verify = false;
            return;
        }
        this.verify = true;
    }

    private Manifest readManifest() {
        try {
            ZipEntry zipEntry = super.getEntry(MANIFEST_NAME);
            if (zipEntry != null) {
                InputStream inputStream = super.getInputStream(zipEntry);
                this.manifestRead = true;
                return new Manifest(inputStream);
            }
            this.manifestRead = true;
            return null;
        }
        catch (IOException iOException) {
            this.manifestRead = true;
            return null;
        }
    }

    public Enumeration<JarEntry> entries() throws IllegalStateException {
        return new JarEnumeration(super.entries(), this);
    }

    @Override
    public synchronized ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            Manifest manifest;
            JarEntry jarEntry = new JarEntry(zipEntry);
            try {
                manifest = this.getManifest();
            }
            catch (IOException iOException) {
                manifest = null;
            }
            if (manifest != null) {
                jarEntry.attr = manifest.getAttributes(string);
            }
            if (this.verify && !this.signaturesRead) {
                try {
                    this.readSignatures();
                }
                catch (IOException iOException) {
                    if (DEBUG) {
                        JarFile.debug(iOException);
                        iOException.printStackTrace();
                    }
                    this.signaturesRead = true;
                }
            }
            jarEntry.jarfile = this;
            return jarEntry;
        }
        return null;
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws ZipException, IOException {
        if (!this.verified.containsKey(zipEntry.getName()) && this.verify) {
            if (DEBUG) {
                JarFile.debug("reading and verifying " + zipEntry);
            }
            return new EntryInputStream(zipEntry, super.getInputStream(zipEntry), this);
        }
        if (DEBUG) {
            JarFile.debug("reading already verified entry " + zipEntry);
        }
        if (this.verify && this.verified.get(zipEntry.getName()) == Boolean.FALSE) {
            throw new ZipException("digest for " + zipEntry + " is invalid");
        }
        return super.getInputStream(zipEntry);
    }

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    public synchronized Manifest getManifest() throws IOException {
        if (!this.manifestRead) {
            this.manifest = this.readManifest();
        }
        return this.manifest;
    }

    void readSignatures() throws IOException {
        int n;
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Cloneable cloneable;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        Object object5 = super.entries();
        while (object5.hasMoreElements()) {
            cloneable = object5.nextElement();
            object4 = ((ZipEntry)cloneable).getName();
            if (!((String)object4).startsWith(META_INF)) continue;
            String string = ((String)object4).substring(META_INF.length());
            if (string.lastIndexOf(46) >= 0) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            if (((String)object4).endsWith(PKCS7_DSA_SUFFIX) || ((String)object4).endsWith(PKCS7_RSA_SUFFIX)) {
                if (DEBUG) {
                    JarFile.debug("reading PKCS7 info from " + (String)object4 + ", alias=" + string);
                }
                object3 = null;
                try {
                    object3 = new PKCS7SignedData(super.getInputStream((ZipEntry)cloneable));
                }
                catch (CertificateException certificateException) {
                    IOException iOException = new IOException("certificate parsing error");
                    iOException.initCause(certificateException);
                    throw iOException;
                }
                catch (CRLException cRLException) {
                    IOException iOException = new IOException("CRL parsing error");
                    iOException.initCause(cRLException);
                    throw iOException;
                }
                if (((String)object4).endsWith(PKCS7_DSA_SUFFIX)) {
                    hashMap.put(string, object3);
                    continue;
                }
                if (!((String)object4).endsWith(PKCS7_RSA_SUFFIX)) continue;
                hashMap2.put(string, object3);
                continue;
            }
            if (!((String)object4).endsWith(SF_SUFFIX)) continue;
            if (DEBUG) {
                JarFile.debug("reading signature file for " + string + ": " + (String)object4);
            }
            object3 = new Manifest(super.getInputStream((ZipEntry)cloneable));
            hashMap3.put(string, object3);
            if (!DEBUG) continue;
            JarFile.debug("result: " + object3);
        }
        object5 = new HashSet();
        cloneable = new HashMap();
        object4 = hashMap3.entrySet().iterator();
        while (object4.hasNext()) {
            boolean bl = false;
            object3 = (Map.Entry)object4.next();
            String string = (String)object3.getKey();
            object2 = (PKCS7SignedData)hashMap.get(string);
            if (object2 != null) {
                object = ((PKCS7SignedData)object2).getCertificates();
                iterator = ((PKCS7SignedData)object2).getSignerInfos();
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    this.verify((Certificate[])object, (SignerInfo)iterator2.next(), string, (Set)object5);
                }
            }
            if ((object2 = (PKCS7SignedData)hashMap2.get(string)) != null) {
                object = ((PKCS7SignedData)object2).getCertificates();
                iterator = ((PKCS7SignedData)object2).getSignerInfos();
                Iterator iterator3 = iterator.iterator();
                while (iterator3.hasNext()) {
                    this.verify((Certificate[])object, (SignerInfo)iterator3.next(), string, (Set)object5);
                }
            }
            if (object5.isEmpty()) {
                object4.remove();
                continue;
            }
            cloneable.put(object3.getValue(), new HashSet(object5));
            object5.clear();
        }
        object4 = super.getInputStream(super.getEntry(MANIFEST_NAME));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object3 = new byte[1024];
        while ((n = ((InputStream)object4).read((byte[])object3)) >= 0) {
            byteArrayOutputStream.write((byte[])object3, 0, n);
        }
        ((InputStream)object4).close();
        HashMap hashMap4 = new HashMap();
        object2 = Pattern.compile("Name: (.+?\r?\n(?: .+?\r?\n)*).+?-Digest: .+?\r?\n\r?\n");
        object = ((Pattern)object2).matcher(byteArrayOutputStream.toString());
        while (((Matcher)object).find()) {
            iterator = ((Matcher)object).group(1).replaceAll("\r?\n ?", "");
            hashMap4.put(iterator, ((Matcher)object).group());
        }
        this.entryCerts = new HashMap();
        for (Map.Entry entry : cloneable.entrySet()) {
            Manifest manifest = (Manifest)entry.getKey();
            Map<String, Attributes> map = manifest.getEntries();
            Set set = (Set)entry.getValue();
            for (Map.Entry<String, Attributes> entry2 : map.entrySet()) {
                Set set2;
                Attributes attributes;
                String string = String.valueOf(entry2.getKey());
                if (!this.verifyHashes(string, attributes = entry2.getValue(), hashMap4)) continue;
                if (DEBUG) {
                    JarFile.debug("entry " + string + " has certificates " + set);
                }
                if ((set2 = (Set)this.entryCerts.get(string)) != null) {
                    set2.addAll(set);
                    continue;
                }
                this.entryCerts.put(string, new HashSet(set));
            }
        }
        this.signaturesRead = true;
    }

    private void verify(Certificate[] certificateArray, SignerInfo signerInfo, String string, Set set) {
        Cloneable cloneable;
        Signature signature;
        block19: {
            signature = null;
            try {
                cloneable = signerInfo.getDigestEncryptionAlgorithmId();
                if (cloneable.equals(DSA_ENCRYPTION_OID)) {
                    if (!signerInfo.getDigestAlgorithmId().equals(SHA1_OID)) {
                        return;
                    }
                    signature = Signature.getInstance("SHA1withDSA", provider);
                    break block19;
                }
                if (cloneable.equals(RSA_ENCRYPTION_OID)) {
                    OID oID = signerInfo.getDigestAlgorithmId();
                    if (oID.equals(MD2_OID)) {
                        signature = Signature.getInstance("md2WithRsaEncryption", provider);
                        break block19;
                    }
                    if (oID.equals(MD4_OID)) {
                        signature = Signature.getInstance("md4WithRsaEncryption", provider);
                        break block19;
                    }
                    if (oID.equals(MD5_OID)) {
                        signature = Signature.getInstance("md5WithRsaEncryption", provider);
                        break block19;
                    }
                    if (oID.equals(SHA1_OID)) {
                        signature = Signature.getInstance("sha1WithRsaEncryption", provider);
                        break block19;
                    }
                    return;
                }
                if (DEBUG) {
                    JarFile.debug("unsupported signature algorithm: " + cloneable);
                }
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (DEBUG) {
                    JarFile.debug(noSuchAlgorithmException);
                    noSuchAlgorithmException.printStackTrace();
                }
                return;
            }
        }
        cloneable = super.getEntry(META_INF + string + SF_SUFFIX);
        if (cloneable == null) {
            return;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            X509Certificate x509Certificate;
            if (!(certificateArray[i] instanceof X509Certificate) || !(x509Certificate = (X509Certificate)certificateArray[i]).getIssuerX500Principal().equals(signerInfo.getIssuer()) || !x509Certificate.getSerialNumber().equals(signerInfo.getSerialNumber())) continue;
            try {
                signature.initVerify(x509Certificate.getPublicKey());
                InputStream inputStream = super.getInputStream((ZipEntry)cloneable);
                if (inputStream == null) continue;
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    signature.update(byArray, 0, n);
                }
                if (!signature.verify(signerInfo.getEncryptedDigest())) continue;
                if (DEBUG) {
                    JarFile.debug("signature for " + x509Certificate.getSubjectDN() + " is good");
                }
                set.add(x509Certificate);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (InvalidKeyException invalidKeyException) {
                continue;
            }
            catch (SignatureException signatureException) {
                // empty catch block
            }
        }
    }

    private boolean verifyHashes(String string, Attributes attributes, HashMap hashMap) {
        int n = 0;
        String string2 = (String)hashMap.get(string);
        if (string2 == null) {
            if (DEBUG) {
                JarFile.debug("could not find " + string + " in manifest");
            }
            return false;
        }
        byte[] byArray = string2.getBytes();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string3 = String.valueOf(entry.getKey());
            if (!string3.endsWith(DIGEST_KEY_SUFFIX)) continue;
            String string4 = string3.substring(0, string3.length() - DIGEST_KEY_SUFFIX.length());
            try {
                byte[] byArray2 = Base64InputStream.decode((String)entry.getValue());
                MessageDigest messageDigest = (MessageDigest)this.digestAlgorithms.get(string4);
                if (messageDigest == null) {
                    messageDigest = MessageDigest.getInstance(string4, provider);
                    this.digestAlgorithms.put(string4, messageDigest);
                }
                messageDigest.reset();
                byte[] byArray3 = messageDigest.digest(byArray);
                if (DEBUG) {
                    JarFile.debug("verifying SF entry " + string + " alg: " + messageDigest.getAlgorithm() + " expect=" + new BigInteger(byArray2).toString(16) + " comp=" + new BigInteger(byArray3).toString(16));
                }
                if (!Arrays.equals(byArray2, byArray3)) {
                    return false;
                }
                ++n;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    JarFile.debug(iOException);
                    iOException.printStackTrace();
                }
                return false;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (DEBUG) {
                    JarFile.debug(noSuchAlgorithmException);
                    noSuchAlgorithmException.printStackTrace();
                }
                return false;
            }
        }
        return n > 0;
    }

    private static class EntryInputStream
    extends FilterInputStream {
        private final JarFile jarfile;
        private final long length;
        private long pos;
        private final ZipEntry entry;
        private final byte[][] hashes;
        private final MessageDigest[] md;
        private boolean checked;

        EntryInputStream(ZipEntry zipEntry, InputStream inputStream, JarFile jarFile) throws IOException {
            super(inputStream);
            this.entry = zipEntry;
            this.jarfile = jarFile;
            this.length = zipEntry.getSize();
            this.pos = 0L;
            this.checked = false;
            Manifest manifest = this.jarfile.getManifest();
            Attributes attributes = manifest != null ? manifest.getAttributes(zipEntry.getName()) : null;
            if (DEBUG) {
                JarFile.debug("verifying entry " + zipEntry + " attr=" + attributes);
            }
            if (attributes == null) {
                this.hashes = new byte[0][];
                this.md = new MessageDigest[0];
            } else {
                LinkedList linkedList = new LinkedList();
                LinkedList<MessageDigest> linkedList2 = new LinkedList<MessageDigest>();
                for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                    Object object;
                    String string = String.valueOf(entry.getKey());
                    if (string == null || !string.endsWith(JarFile.DIGEST_KEY_SUFFIX)) continue;
                    linkedList.add(Base64InputStream.decode((String)entry.getValue()));
                    try {
                        int n = string.length() - JarFile.DIGEST_KEY_SUFFIX.length();
                        object = string.substring(0, n);
                        linkedList2.add(MessageDigest.getInstance((String)object, provider));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        object = new IOException("no such message digest: " + string);
                        ((Throwable)object).initCause(noSuchAlgorithmException);
                        throw object;
                    }
                }
                if (DEBUG) {
                    JarFile.debug("digests=" + linkedList2);
                }
                this.hashes = (byte[][])linkedList.toArray((T[])new byte[linkedList.size()][]);
                this.md = linkedList2.toArray((T[])new MessageDigest[linkedList2.size()]);
            }
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int n) {
        }

        public void reset() {
        }

        public int read() throws IOException {
            int n = super.read();
            if (n == -1) {
                this.eof();
                return -1;
            }
            for (int i = 0; i < this.md.length; ++i) {
                this.md[i].update((byte)n);
            }
            ++this.pos;
            if (this.length > 0L && this.pos >= this.length) {
                this.eof();
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, (int)Math.min((long)n2, this.length != 0L ? this.length - this.pos : Integer.MAX_VALUE));
            if (n3 == -1 || this.length > 0L && this.pos >= this.length) {
                this.eof();
                return -1;
            }
            for (int i = 0; i < this.md.length; ++i) {
                this.md[i].update(byArray, n, n3);
            }
            this.pos += (long)n3;
            if (this.length != 0L && this.pos >= this.length) {
                this.eof();
            }
            return n3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public long skip(long l) throws IOException {
            long l2;
            int n;
            byte[] byArray = new byte[1024];
            for (l2 = 0L; l2 < l && (n = this.read(byArray, 0, (int)Math.min((long)byArray.length, l - l2))) != -1; l2 += (long)n) {
            }
            return l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eof() throws IOException {
            if (this.checked) {
                return;
            }
            this.checked = true;
            for (int i = 0; i < this.md.length; ++i) {
                byte[] byArray = this.md[i].digest();
                if (DEBUG) {
                    JarFile.debug("verifying " + this.md[i].getAlgorithm() + " expect=" + new BigInteger(this.hashes[i]).toString(16) + " comp=" + new BigInteger(byArray).toString(16));
                }
                if (Arrays.equals(byArray, this.hashes[i])) continue;
                JarFile jarFile = this.jarfile;
                synchronized (jarFile) {
                    if (DEBUG) {
                        JarFile.debug(this.entry + " could NOT be verified");
                    }
                    this.jarfile.verified.put(this.entry.getName(), Boolean.FALSE);
                }
                return;
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                if (DEBUG) {
                    JarFile.debug(this.entry + " has been VERIFIED");
                }
                this.jarfile.verified.put(this.entry.getName(), Boolean.TRUE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarEnumeration
    implements Enumeration<JarEntry> {
        private final Enumeration<? extends ZipEntry> entries;
        private final JarFile jarfile;

        JarEnumeration(Enumeration<? extends ZipEntry> enumeration, JarFile jarFile) {
            this.entries = enumeration;
            this.jarfile = jarFile;
        }

        @Override
        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JarEntry nextElement() {
            Manifest manifest;
            ZipEntry zipEntry = this.entries.nextElement();
            JarEntry jarEntry = new JarEntry(zipEntry);
            try {
                manifest = this.jarfile.getManifest();
            }
            catch (IOException iOException) {
                manifest = null;
            }
            if (manifest != null) {
                jarEntry.attr = manifest.getAttributes(jarEntry.getName());
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                if (this.jarfile.verify && !this.jarfile.signaturesRead) {
                    try {
                        this.jarfile.readSignatures();
                    }
                    catch (IOException iOException) {
                        if (DEBUG) {
                            JarFile.debug(iOException);
                            iOException.printStackTrace();
                        }
                        this.jarfile.signaturesRead = true;
                    }
                }
            }
            jarEntry.jarfile = this.jarfile;
            return jarEntry;
        }
    }
}

