/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();

    void reject(Runnable runnable) {
        this.handler.rejectedExecution(runnable, this);
    }

    private Thread addThread(Runnable runnable) {
        if (this.runState == 3) {
            return null;
        }
        Worker worker = new Worker(runnable);
        Thread thread = this.threadFactory.newThread(worker);
        if (thread != null) {
            worker.thread = thread;
            this.workers.add(worker);
            int n = ++this.poolSize;
            if (n > this.largestPoolSize) {
                this.largestPoolSize = n;
            }
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderCorePoolSize(Runnable runnable) {
        Thread thread = null;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.poolSize < this.corePoolSize) {
                thread = this.addThread(runnable);
            }
            Object var5_4 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (thread == null) {
            return false;
        }
        thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addIfUnderMaximumPoolSize(Runnable runnable) {
        Thread thread = null;
        int n = 0;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize) {
                Runnable runnable2 = (Runnable)this.workQueue.poll();
                if (runnable2 == null) {
                    runnable2 = runnable;
                    n = 1;
                } else {
                    n = -1;
                }
                thread = this.addThread(runnable2);
            }
            Object var7_6 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (thread == null) {
            return 0;
        }
        thread.start();
        return n;
    }

    Runnable getTask() {
        block7: while (true) {
            try {
                do {
                    switch (this.runState) {
                        case 0: {
                            if (this.poolSize <= this.corePoolSize && !this.allowCoreThreadTimeOut) {
                                return this.workQueue.take();
                            }
                            long l = this.keepAliveTime;
                            if (l <= 0L) {
                                return null;
                            }
                            Runnable runnable = this.workQueue.poll(l, TimeUnit.NANOSECONDS);
                            if (runnable != null) {
                                return runnable;
                            }
                            if (this.poolSize <= this.corePoolSize && !this.allowCoreThreadTimeOut) continue block7;
                            return null;
                        }
                        case 1: {
                            Runnable runnable = (Runnable)this.workQueue.poll();
                            if (runnable != null) {
                                return runnable;
                            }
                            if (this.workQueue.isEmpty()) {
                                this.interruptIdleWorkers();
                                return null;
                            }
                            return this.workQueue.take();
                        }
                        case 2: {
                            return null;
                        }
                    }
                } while ($assertionsDisabled);
                throw new AssertionError();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            for (Worker worker : this.workers) {
                worker.interruptIfIdle();
            }
            Object var5_4 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void workerDone(Worker worker) {
        ReentrantLock reentrantLock;
        block11: {
            block10: {
                block9: {
                    reentrantLock = this.mainLock;
                    reentrantLock.lock();
                    try {
                        this.completedTaskCount += worker.completedTasks;
                        this.workers.remove(worker);
                        if (--this.poolSize > 0) {
                            Object var6_3 = null;
                            reentrantLock.unlock();
                            return;
                        }
                        int n = this.runState;
                        assert (n != 3);
                        if (n != 2) {
                            if (!this.workQueue.isEmpty()) {
                                Thread thread = this.addThread(null);
                                if (thread != null) {
                                    thread.start();
                                }
                                break block9;
                            }
                            if (n == 0) {
                                break block10;
                            }
                        }
                        this.termination.signalAll();
                        this.runState = 3;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        reentrantLock.unlock();
                        throw throwable;
                    }
                }
                Object var6_4 = null;
                reentrantLock.unlock();
                return;
            }
            Object var6_5 = null;
            reentrantLock.unlock();
            return;
        }
        Object var6_6 = null;
        reentrantLock.unlock();
        assert (this.runState == 3);
        this.terminated();
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (n < 0 || n2 <= 0 || n2 < n || l < 0L) {
            throw new IllegalArgumentException();
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = n;
        this.maximumPoolSize = n2;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    @Override
    public void execute(Runnable runnable) {
        int n;
        if (runnable == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(runnable);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(runnable)) {
                return;
            }
            if (this.workQueue.offer(runnable)) {
                return;
            }
            n = this.addIfUnderMaximumPoolSize(runnable);
            if (n <= 0) continue;
            return;
        } while (n != 0);
        this.reject(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(shutdownPerm);
        }
        boolean bl = false;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.workers.size() > 0) {
                int n;
                if (securityManager != null) {
                    for (Worker object : this.workers) {
                        securityManager.checkAccess(object.thread);
                    }
                }
                if ((n = this.runState) == 0) {
                    this.runState = 1;
                }
                try {
                    for (Worker worker : this.workers) {
                        worker.interruptIfIdle();
                    }
                }
                catch (SecurityException securityException) {
                    this.runState = n;
                    throw securityException;
                }
            } else {
                bl = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            Object var8_10 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (bl) {
            this.terminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(shutdownPerm);
        }
        boolean bl = false;
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            if (this.workers.size() > 0) {
                int n;
                if (securityManager != null) {
                    for (Worker object : this.workers) {
                        securityManager.checkAccess(object.thread);
                    }
                }
                if ((n = this.runState) != 3) {
                    this.runState = 2;
                }
                try {
                    for (Worker worker : this.workers) {
                        worker.interruptNow();
                    }
                }
                catch (SecurityException securityException) {
                    this.runState = n;
                    throw securityException;
                }
            } else {
                bl = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            Object var8_10 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        if (bl) {
            this.terminated();
        }
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    boolean bl2 = true;
                    Object var9_7 = null;
                    reentrantLock.unlock();
                    return bl2;
                }
                if (l2 <= 0L) {
                    bl = false;
                    break;
                }
                l2 = this.termination.awaitNanos(l2);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            reentrantLock.unlock();
            throw throwable;
        }
        Object var9_8 = null;
        reentrantLock.unlock();
        return bl;
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        if (rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.handler = rejectedExecutionHandler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable runnable) {
        return this.getQueue().remove(runnable);
    }

    public void purge() {
        try {
            Iterator iterator = this.getQueue().iterator();
            while (iterator.hasNext()) {
                Future future;
                Runnable runnable = (Runnable)iterator.next();
                if (!(runnable instanceof Future) || !(future = (Future)((Object)runnable)).isCancelled()) continue;
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2 = this.corePoolSize - n;
            this.corePoolSize = n;
            if (n2 < 0) {
                Thread thread;
                int n3 = this.workQueue.size();
                while (n2++ < 0 && n3-- > 0 && this.poolSize < n && (thread = this.addThread(null)) != null) {
                    thread.start();
                }
            } else if (n2 > 0 && this.poolSize > n) {
                Iterator<Worker> iterator = this.workers.iterator();
                while (iterator.hasNext() && n2-- > 0 && this.poolSize > n && this.workQueue.remainingCapacity() == 0) {
                    iterator.next().interruptIfIdle();
                }
            }
            Object var7_7 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean bl) {
        if (bl && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.allowCoreThreadTimeOut = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int n) {
        if (n <= 0 || n < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n2;
            this.maximumPoolSize = n;
            if (n2 > 0 && this.poolSize > n) {
                Iterator<Worker> iterator = this.workers.iterator();
                for (n2 = this.maximumPoolSize - n; iterator.hasNext() && n2 > 0 && this.poolSize > n; --n2) {
                    iterator.next().interruptIfIdle();
                }
            }
            Object var6_5 = null;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.keepAliveTime = timeUnit.toNanos(l);
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = 0;
            for (Worker worker : this.workers) {
                if (!worker.isActive()) continue;
                ++n;
            }
            int n2 = n;
            Object var6_6 = null;
            reentrantLock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            int n = this.largestPoolSize;
            Object var4_3 = null;
            reentrantLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
                if (!worker.isActive()) continue;
                ++l;
            }
            long l2 = l + (long)this.workQueue.size();
            Object var7_6 = null;
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock reentrantLock = this.mainLock;
        reentrantLock.lock();
        try {
            long l = this.completedTaskCount;
            for (Worker worker : this.workers) {
                l += worker.completedTasks;
            }
            long l2 = l;
            Object var7_6 = null;
            reentrantLock.unlock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reentrantLock.unlock();
            throw throwable;
        }
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    protected void terminated() {
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                threadPoolExecutor.getQueue().poll();
                threadPoolExecutor.execute(runnable);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                runnable.run();
            }
        }
    }

    private class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        Worker(Runnable runnable) {
            this.firstTask = runnable;
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptIfIdle() {
            ReentrantLock reentrantLock = this.runLock;
            if (reentrantLock.tryLock()) {
                try {
                    this.thread.interrupt();
                    Object var3_2 = null;
                    reentrantLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    reentrantLock.unlock();
                    throw throwable;
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable runnable) {
            ReentrantLock reentrantLock = this.runLock;
            reentrantLock.lock();
            try {
                if (ThreadPoolExecutor.this.runState != 2 && Thread.interrupted() && ThreadPoolExecutor.this.runState == 2) {
                    this.thread.interrupt();
                }
                boolean bl = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, runnable);
                try {
                    runnable.run();
                    bl = true;
                    ThreadPoolExecutor.this.afterExecute(runnable, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException runtimeException) {
                    if (!bl) {
                        ThreadPoolExecutor.this.afterExecute(runnable, runtimeException);
                    }
                    throw runtimeException;
                }
                Object var6_5 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable runnable = this.firstTask;
                this.firstTask = null;
                while (runnable != null || (runnable = ThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(runnable);
                    runnable = null;
                }
                Object var3_2 = null;
                ThreadPoolExecutor.this.workerDone(this);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ThreadPoolExecutor.this.workerDone(this);
                throw throwable;
            }
        }
    }
}

