/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    private transient Node<E> first;
    private transient Node<E> last;
    private transient int count;
    private final int capacity;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
    }

    public LinkedBlockingDeque(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        for (E e : collection) {
            this.add(e);
        }
    }

    private boolean linkFirst(E e) {
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node<E> node2 = this.first;
        Node<E> node3 = new Node<E>(e, null, node2);
        this.first = node3;
        if (this.last == null) {
            this.last = node3;
        } else {
            node2.prev = node3;
        }
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(E e) {
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node<E> node2 = this.last;
        Node<E> node3 = new Node<E>(e, node2, null);
        this.last = node3;
        if (this.first == null) {
            this.first = node3;
        } else {
            node2.next = node3;
        }
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> node2 = this.first;
        if (node2 == null) {
            return null;
        }
        Node node3 = node2.next;
        this.first = node3;
        if (node3 == null) {
            this.last = null;
        } else {
            node3.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return node2.item;
    }

    private E unlinkLast() {
        Node<E> node2 = this.last;
        if (node2 == null) {
            return null;
        }
        Node node3 = node2.prev;
        this.last = node3;
        if (node3 == null) {
            this.first = null;
        } else {
            node3.next = null;
        }
        --this.count;
        this.notFull.signal();
        return node2.item;
    }

    private void unlink(Node<E> node2) {
        Node node3 = node2.prev;
        Node node4 = node2.next;
        if (node3 == null) {
            if (node4 == null) {
                this.last = null;
                this.first = null;
            } else {
                node4.prev = null;
                this.first = node4;
            }
        } else if (node4 == null) {
            node3.next = null;
            this.last = node3;
        } else {
            node3.next = node4;
            node4.prev = node3;
        }
        --this.count;
        this.notFull.signalAll();
    }

    @Override
    public void addFirst(E e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    @Override
    public void addLast(E e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException("Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkFirst(e);
            Object var4_3 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkLast(e);
            Object var4_3 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFirst(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkFirst(e)) {
                this.notFull.await();
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLast(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkLast(e)) {
                this.notFull.await();
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offerFirst(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.linkFirst(e)) {
                    boolean bl2 = true;
                    Object var9_7 = null;
                    this.lock.unlock();
                    return bl2;
                }
                if (l2 <= 0L) {
                    bl = false;
                    break;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var9_8 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offerLast(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        boolean bl;
        if (e == null) {
            throw new NullPointerException();
        }
        long l2 = timeUnit.toNanos(l);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.linkLast(e)) {
                    boolean bl2 = true;
                    Object var9_7 = null;
                    this.lock.unlock();
                    return bl2;
                }
                if (l2 <= 0L) {
                    bl = false;
                    break;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var9_8 = null;
        this.lock.unlock();
        return bl;
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst() {
        E e;
        this.lock.lock();
        try {
            e = this.unlinkFirst();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast() {
        E e;
        this.lock.lock();
        try {
            e = this.unlinkLast();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeFirst() throws InterruptedException {
        E e;
        this.lock.lock();
        try {
            E e2;
            while ((e2 = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            e = e2;
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        E e;
        this.lock.lock();
        try {
            E e2;
            while ((e2 = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            e = e2;
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E pollFirst(long l, TimeUnit timeUnit) throws InterruptedException {
        E e3;
        long l2 = timeUnit.toNanos(l);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                E e2;
                if ((e2 = this.unlinkFirst()) != null) {
                    E e = e2;
                    Object var9_7 = null;
                    this.lock.unlock();
                    return e;
                }
                if (l2 <= 0L) {
                    e3 = null;
                    break;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var9_8 = null;
        this.lock.unlock();
        return e3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E pollLast(long l, TimeUnit timeUnit) throws InterruptedException {
        E e3;
        long l2 = timeUnit.toNanos(l);
        this.lock.lockInterruptibly();
        try {
            while (true) {
                E e2;
                if ((e2 = this.unlinkLast()) != null) {
                    E e = e2;
                    Object var9_7 = null;
                    this.lock.unlock();
                    return e;
                }
                if (l2 <= 0L) {
                    e3 = null;
                    break;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var9_8 = null;
        this.lock.unlock();
        return e3;
    }

    @Override
    public E getFirst() {
        E e = this.peekFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        E e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekFirst() {
        E e;
        this.lock.lock();
        try {
            e = this.first == null ? null : (E)this.first.item;
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekLast() {
        E e;
        this.lock.lock();
        try {
            e = this.last == null ? null : (E)this.last.item;
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeFirstOccurrence(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> node2 = this.first;
            while (node2 != null) {
                if (object.equals(node2.item)) {
                    this.unlink(node2);
                    boolean bl2 = true;
                    Object var5_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node2 = node2.next;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeLastOccurrence(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> node2 = this.last;
            while (node2 != null) {
                if (object.equals(node2.item)) {
                    this.unlink(node2);
                    boolean bl2 = true;
                    Object var5_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node2 = node2.prev;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.lock.unlock();
        return bl;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(e, l, timeUnit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(l, timeUnit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.capacity - this.count;
            Object var3_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            Node<E> node2 = this.first;
            while (node2 != null) {
                collection.add(node2.item);
                node2 = node2.next;
            }
            int n = this.count;
            this.count = 0;
            this.last = null;
            this.first = null;
            this.notFull.signalAll();
            int n2 = n;
            Object var5_5 = null;
            this.lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n2;
            for (n2 = 0; n2 < n && this.first != null; ++n2) {
                collection.add(this.first.item);
                this.first.prev = null;
                this.first = this.first.next;
                --this.count;
            }
            if (this.first == null) {
                this.last = null;
            }
            this.notFull.signalAll();
            int n3 = n2;
            Object var6_5 = null;
            this.lock.unlock();
            return n3;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            Object var3_2 = null;
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object object) {
        boolean bl;
        if (object == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node<E> node2 = this.first;
            while (node2 != null) {
                if (object.equals(node2.item)) {
                    boolean bl2 = true;
                    Object var5_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node2 = node2.next;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean removeNode(Node<E> node2) {
        boolean bl;
        this.lock.lock();
        try {
            Node<E> node3 = this.first;
            while (node3 != null) {
                if (node3 == node2) {
                    this.unlink(node3);
                    boolean bl2 = true;
                    Object var5_5 = null;
                    this.lock.unlock();
                    return bl2;
                }
                node3 = node3.next;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var5_6 = null;
        this.lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.lock.lock();
        try {
            Object[] objectArray = new Object[this.count];
            int n = 0;
            Object[] objectArray2 = this.first;
            while (objectArray2 != null) {
                objectArray[n++] = objectArray2.item;
                objectArray2 = objectArray2.next;
            }
            objectArray2 = objectArray;
            Object var5_4 = null;
            this.lock.unlock();
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.lock.lock();
        try {
            if (objectArray.length < this.count) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.count);
            }
            int n = 0;
            Object object = this.first;
            while (object != null) {
                objectArray[n++] = object.item;
                object = object.next;
            }
            if (objectArray.length > n) {
                objectArray[n] = null;
            }
            object = objectArray;
            Object var5_4 = null;
            this.lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            Object var3_2 = null;
            this.lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.lock.lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node<E> node2 = this.first;
            while (node2 != null) {
                objectOutputStream.writeObject(node2.item);
                node2 = node2.next;
            }
            objectOutputStream.writeObject(null);
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.next == null ? LinkedBlockingDeque.this.last : this.next.prev;
                this.nextItem = this.next == null ? null : this.next.item;
                Object var3_2 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void advance() {
            ReentrantLock reentrantLock = LinkedBlockingDeque.this.lock;
            reentrantLock.lock();
            try {
                this.next = this.next == null ? LinkedBlockingDeque.this.first : this.next.next;
                this.nextItem = this.next == null ? null : this.next.item;
                Object var3_2 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        AbstractItr() {
            this.advance();
        }

        abstract void advance();

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            Object e = this.nextItem;
            this.advance();
            return e;
        }

        @Override
        public void remove() {
            Node node2 = this.lastRet;
            if (node2 == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            LinkedBlockingDeque.this.removeNode(node2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E e, Node<E> node2, Node<E> node3) {
            this.item = e;
            this.prev = node2;
            this.next = node3;
        }
    }
}

