/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final Object NULL_KEY = new Object(){

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return null == object || this == object;
        }
    };
    private final ReferenceQueue queue;
    int size;
    private float loadFactor;
    private int threshold;
    int modCount;
    private final WeakEntrySet theEntrySet;
    WeakBucket[] buckets;

    public WeakHashMap() {
        this(11, 0.75f);
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap(int n, float f) {
        if (n < 0 || !(f > 0.0f)) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
        this.theEntrySet = new WeakEntrySet();
        this.queue = new ReferenceQueue();
        this.buckets = new WeakBucket[n];
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        this(map.size(), 0.75f);
        this.putAll(map);
    }

    private int hash(Object object) {
        return Math.abs(object.hashCode() % this.buckets.length);
    }

    void cleanQueue() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.internalRemove((WeakBucket)reference);
            reference = this.queue.poll();
        }
    }

    private void rehash() {
        WeakBucket[] weakBucketArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new WeakBucket[n];
        for (int i = 0; i < weakBucketArray.length; ++i) {
            WeakBucket weakBucket = weakBucketArray[i];
            while (weakBucket != null) {
                WeakBucket weakBucket2 = weakBucket.next;
                Object t = weakBucket.get();
                if (t == null) {
                    weakBucket.slot = -1;
                    --this.size;
                } else {
                    int n2;
                    weakBucket.slot = n2 = this.hash(t);
                    weakBucket.next = this.buckets[n2];
                    this.buckets[n2] = weakBucket;
                }
                weakBucket = weakBucket2;
            }
        }
    }

    private WeakBucket.WeakEntry internalGet(Object object) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket weakBucket = this.buckets[n];
        while (weakBucket != null) {
            WeakBucket.WeakEntry weakEntry = weakBucket.getEntry();
            if (weakEntry != null && WeakHashMap.equals(object, weakEntry.key)) {
                return weakEntry;
            }
            weakBucket = weakBucket.next;
        }
        return null;
    }

    private void internalAdd(Object object, Object object2) {
        if (object == null) {
            object = NULL_KEY;
        }
        int n = this.hash(object);
        WeakBucket<Object, Object> weakBucket = new WeakBucket<Object, Object>(object, this.queue, object2, n);
        weakBucket.next = this.buckets[n];
        this.buckets[n] = weakBucket;
        ++this.size;
    }

    void internalRemove(WeakBucket weakBucket) {
        int n = weakBucket.slot;
        if (n == -1) {
            return;
        }
        weakBucket.slot = -1;
        WeakBucket weakBucket2 = null;
        WeakBucket weakBucket3 = this.buckets[n];
        while (weakBucket3 != weakBucket) {
            if (weakBucket3 == null) {
                throw new InternalError("WeakHashMap in incosistent state");
            }
            weakBucket2 = weakBucket3;
            weakBucket3 = weakBucket2.next;
        }
        if (weakBucket2 == null) {
            this.buckets[n] = weakBucket.next;
        } else {
            weakBucket2.next = weakBucket.next;
        }
        --this.size;
    }

    @Override
    public int size() {
        this.cleanQueue();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        this.cleanQueue();
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        this.cleanQueue();
        return this.internalGet(object) != null;
    }

    @Override
    public V get(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        return weakEntry == null ? null : (V)weakEntry.getValue();
    }

    @Override
    public V put(K k, V v) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(k);
        if (weakEntry != null) {
            return weakEntry.setValue(v);
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
        }
        this.internalAdd(k, v);
        return null;
    }

    @Override
    public V remove(Object object) {
        this.cleanQueue();
        WeakBucket.WeakEntry weakEntry = this.internalGet(object);
        if (weakEntry == null) {
            return null;
        }
        ++this.modCount;
        this.internalRemove(weakEntry.getBucket());
        return weakEntry.getValue();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.cleanQueue();
        return this.theEntrySet;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean containsValue(Object object) {
        this.cleanQueue();
        return super.containsValue(object);
    }

    @Override
    public Set<K> keySet() {
        this.cleanQueue();
        return super.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(map);
    }

    @Override
    public Collection<V> values() {
        this.cleanQueue();
        return super.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakBucket<K, V>
    extends WeakReference<K> {
        V value;
        WeakBucket<K, V> next;
        int slot;

        public WeakBucket(K k, ReferenceQueue referenceQueue, V v, int n) {
            super(k, referenceQueue);
            this.value = v;
            this.slot = n;
        }

        WeakEntry getEntry() {
            Object t = this.get();
            if (t == null) {
                return null;
            }
            return new WeakEntry(t);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class WeakEntry
        implements Map.Entry<K, V> {
            K key;

            public WeakEntry(K k) {
                this.key = k;
            }

            public WeakBucket getBucket() {
                return WeakBucket.this;
            }

            @Override
            public K getKey() {
                return this.key == NULL_KEY ? null : (Object)this.key;
            }

            @Override
            public V getValue() {
                return WeakBucket.this.value;
            }

            @Override
            public V setValue(V v) {
                Object v2 = WeakBucket.this.value;
                WeakBucket.this.value = v;
                return v2;
            }

            @Override
            public int hashCode() {
                return this.key.hashCode() ^ WeakHashMap.hashCode(WeakBucket.this.value);
            }

            @Override
            public boolean equals(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return WeakHashMap.equals(this.getKey(), entry.getKey()) && WeakHashMap.equals(WeakBucket.this.value, entry.getValue());
                }
                return false;
            }

            public String toString() {
                return this.getKey() + "=" + WeakBucket.this.value;
            }
        }
    }

    private final class WeakEntrySet
    extends AbstractSet {
        WeakEntrySet() {
        }

        public int size() {
            return WeakHashMap.this.size;
        }

        public Iterator iterator() {
            return new Iterator(){
                WeakBucket.WeakEntry lastEntry;
                WeakBucket.WeakEntry nextEntry = this.findNext(null);
                int knownMod;
                {
                    this.knownMod = WeakHashMap.this.modCount;
                }

                private void checkMod() {
                    WeakHashMap.this.cleanQueue();
                    if (this.knownMod != WeakHashMap.this.modCount) {
                        throw new ConcurrentModificationException(this.knownMod + " != " + WeakHashMap.this.modCount);
                    }
                }

                private WeakBucket.WeakEntry findNext(WeakBucket.WeakEntry weakEntry) {
                    int n;
                    WeakBucket weakBucket;
                    if (weakEntry != null) {
                        weakBucket = weakEntry.getBucket().next;
                        n = weakEntry.getBucket().slot;
                    } else {
                        weakBucket = WeakHashMap.this.buckets[0];
                        n = 0;
                    }
                    while (true) {
                        if (weakBucket != null) {
                            WeakBucket.WeakEntry weakEntry2 = weakBucket.getEntry();
                            if (weakEntry2 != null) {
                                return weakEntry2;
                            }
                            weakBucket = weakBucket.next;
                            continue;
                        }
                        if (++n == WeakHashMap.this.buckets.length) {
                            return null;
                        }
                        weakBucket = WeakHashMap.this.buckets[n];
                    }
                }

                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                public Object next() {
                    this.checkMod();
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.findNext(this.lastEntry);
                    return this.lastEntry;
                }

                public void remove() {
                    this.checkMod();
                    if (this.lastEntry == null) {
                        throw new IllegalStateException();
                    }
                    ++WeakHashMap.this.modCount;
                    WeakHashMap.this.internalRemove(this.lastEntry.getBucket());
                    this.lastEntry = null;
                    ++this.knownMod;
                }
            };
        }
    }
}

