/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSet<T>
extends AbstractSet<T>
implements NavigableSet<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143000061671589L;
    private transient NavigableMap<T, String> map;

    public TreeSet() {
        this.map = new TreeMap<T, String>();
    }

    public TreeSet(Comparator<? super T> comparator) {
        this.map = new TreeMap<T, String>(comparator);
    }

    public TreeSet(Collection<? extends T> collection) {
        this.map = new TreeMap<T, String>();
        this.addAll(collection);
    }

    public TreeSet(SortedSet<T> sortedSet) {
        this.map = new TreeMap<T, String>(sortedSet.comparator());
        Iterator iterator = sortedSet.iterator();
        ((TreeMap)this.map).putKeysLinear(iterator, sortedSet.size());
    }

    private TreeSet(NavigableMap<T, String> navigableMap) {
        this.map = navigableMap;
    }

    @Override
    public boolean add(T t) {
        return this.map.put(t, "") == null;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        int n = collection.size();
        Iterator<T> iterator = collection.iterator();
        while (--n >= 0) {
            bl |= this.map.put(iterator.next(), "") == null;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        TreeSet treeSet = null;
        try {
            treeSet = (TreeSet)super.clone();
            treeSet.map = (NavigableMap)((AbstractMap)((Object)this.map)).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return treeSet;
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.map.comparator();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public T first() {
        return (T)this.map.firstKey();
    }

    @Override
    public SortedSet<T> headSet(T t) {
        return this.headSet(t, false);
    }

    @Override
    public NavigableSet<T> headSet(T t, boolean bl) {
        return new TreeSet<T>(this.map.headMap(t, bl));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public T last() {
        return (T)this.map.lastKey();
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public SortedSet<T> subSet(T t, T t2) {
        return this.subSet(t, true, t2, false);
    }

    @Override
    public NavigableSet<T> subSet(T t, boolean bl, T t2, boolean bl2) {
        return new TreeSet<T>(this.map.subMap(t, bl, t2, bl2));
    }

    @Override
    public SortedSet<T> tailSet(T t) {
        return this.tailSet(t, true);
    }

    @Override
    public NavigableSet<T> tailSet(T t, boolean bl) {
        return new TreeSet<T>(this.map.tailMap(t, bl));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Iterator iterator = this.map.keySet().iterator();
        int n = this.map.size();
        objectOutputStream.writeObject(this.map.comparator());
        objectOutputStream.writeInt(n);
        while (--n >= 0) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        this.map = new TreeMap<T, String>(comparator);
        ((TreeMap)this.map).putFromObjStream(objectInputStream, n, false);
    }

    @Override
    public T ceiling(T t) {
        return this.map.ceilingKey(t);
    }

    @Override
    public Iterator<T> descendingIterator() {
        return this.descendingSet().iterator();
    }

    @Override
    public NavigableSet<T> descendingSet() {
        return this.map.descendingKeySet();
    }

    @Override
    public T floor(T t) {
        return this.map.floorKey(t);
    }

    @Override
    public T higher(T t) {
        return this.map.higherKey(t);
    }

    @Override
    public T lower(T t) {
        return this.map.lowerKey(t);
    }

    @Override
    public T pollFirst() {
        return this.map.pollFirstEntry().getKey();
    }

    @Override
    public T pollLast() {
        return this.map.pollLastEntry().getKey();
    }
}

