/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 919286545866124006L;
    static final int RED = -1;
    static final int BLACK = 1;
    static final Node nil = new Node<Object, Object>(null, null, 1);
    private transient Node root;
    transient int size;
    private transient Set<Map.Entry<K, V>> entries;
    private transient NavigableMap<K, V> descendingMap;
    private transient NavigableSet<K> nKeys;
    transient int modCount;
    final Comparator<? super K> comparator;

    public TreeMap() {
        this((Comparator)null);
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.fabricateTree(0);
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this((Comparator)null);
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> sortedMap) {
        this(sortedMap.comparator());
        int n = sortedMap.size();
        Iterator iterator = sortedMap.entrySet().iterator();
        super.fabricateTree(n);
        Node<K, V> node2 = this.firstNode();
        while (--n >= 0) {
            Map.Entry entry = iterator.next();
            node2.key = entry.getKey();
            node2.value = entry.getValue();
            node2 = this.successor(node2);
        }
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.root = nil;
            this.size = 0;
        }
    }

    @Override
    public Object clone() {
        TreeMap treeMap = null;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        treeMap.entries = null;
        treeMap.fabricateTree(this.size);
        Node<K, V> node2 = this.firstNode();
        Node<K, V> node3 = treeMap.firstNode();
        while (node2 != nil) {
            node3.key = node2.key;
            node3.value = node2.value;
            node2 = this.successor(node2);
            node3 = treeMap.successor(node3);
        }
        return treeMap;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getNode(object) != nil;
    }

    @Override
    public boolean containsValue(Object object) {
        Node<K, V> node2 = this.firstNode();
        while (node2 != nil) {
            if (TreeMap.equals(object, node2.value)) {
                return true;
            }
            node2 = this.successor(node2);
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new NavigableEntrySet();
        }
        return this.entries;
    }

    @Override
    public K firstKey() {
        if (this.root == nil) {
            throw new NoSuchElementException();
        }
        return (K)this.firstNode().key;
    }

    @Override
    public V get(Object object) {
        return (V)this.getNode(object).value;
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return this.headMap(k, false);
    }

    @Override
    public NavigableMap<K, V> headMap(K k, boolean bl) {
        return new SubMap(nil, bl ? this.successor(this.getNode(k)).key : k);
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public K lastKey() {
        if (this.root == nil) {
            throw new NoSuchElementException("empty");
        }
        return (K)this.lastNode().key;
    }

    @Override
    public V put(K k, V v) {
        Node node2 = this.root;
        Node node3 = nil;
        int n = 0;
        while (node2 != nil) {
            node3 = node2;
            n = this.compare(k, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return node2.setValue(v);
        }
        Node<K, V> node4 = new Node<K, V>(k, v, -1);
        node4.parent = node3;
        ++this.modCount;
        ++this.size;
        if (node3 == nil) {
            this.root = node4;
            return null;
        }
        if (n > 0) {
            node3.right = node4;
        } else {
            node3.left = node4;
        }
        this.insertFixup(node4);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        int n = map.size();
        while (--n >= 0) {
            Map.Entry<K, V> entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Node<Object, V> node2 = this.getNode(object);
        if (node2 == nil) {
            return null;
        }
        Object object2 = node2.value;
        this.removeNode(node2);
        return (V)object2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return this.subMap(k, true, k2, false);
    }

    @Override
    public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        return new SubMap(bl ? k : this.successor(this.getNode(k)).key, bl2 ? this.successor(this.getNode(k2)).key : k2);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return this.tailMap(k, true);
    }

    @Override
    public NavigableMap<K, V> tailMap(K k, boolean bl) {
        return new SubMap(bl ? k : this.successor(this.getNode(k)).key, nil);
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return new TreeIterator(1);
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    final int compare(K k, K k2) {
        return this.comparator == null ? ((Comparable)k).compareTo(k2) : this.comparator.compare(k, k2);
    }

    private void deleteFixup(Node<K, V> node2, Node<K, V> node3) {
        while (node2 != this.root && node2.color == 1) {
            Node node4;
            if (node2 == node3.left) {
                node4 = node3.right;
                if (node4.color == -1) {
                    node4.color = 1;
                    node3.color = -1;
                    this.rotateLeft(node3);
                    node4 = node3.right;
                }
                if (node4.left.color == 1 && node4.right.color == 1) {
                    node4.color = -1;
                    node2 = node3;
                    node3 = node3.parent;
                    continue;
                }
                if (node4.right.color == 1) {
                    node4.left.color = 1;
                    node4.color = -1;
                    this.rotateRight(node4);
                    node4 = node3.right;
                }
                node4.color = node3.color;
                node3.color = 1;
                node4.right.color = 1;
                this.rotateLeft(node3);
                node2 = this.root;
                continue;
            }
            node4 = node3.left;
            if (node4.color == -1) {
                node4.color = 1;
                node3.color = -1;
                this.rotateRight(node3);
                node4 = node3.left;
            }
            if (node4.right.color == 1 && node4.left.color == 1) {
                node4.color = -1;
                node2 = node3;
                node3 = node3.parent;
                continue;
            }
            if (node4.left.color == 1) {
                node4.right.color = 1;
                node4.color = -1;
                this.rotateLeft(node4);
                node4 = node3.left;
            }
            node4.color = node3.color;
            node3.color = 1;
            node4.left.color = 1;
            this.rotateRight(node3);
            node2 = this.root;
        }
        node2.color = 1;
    }

    private void fabricateTree(int n) {
        Node node2;
        Node<Object, Object> node3;
        Node<Object, Object> node4;
        int n2;
        Node<Object, Object> node5;
        if (n == 0) {
            this.root = nil;
            this.size = 0;
            return;
        }
        this.root = new Node<Object, Object>(null, null, 1);
        this.size = n;
        Node node6 = this.root;
        int n3 = 2;
        while (n3 + n3 <= n) {
            Node node7 = node6;
            node5 = null;
            for (n2 = 0; n2 < n3; n2 += 2) {
                node4 = new Node<Object, Object>(null, null, 1);
                node3 = new Node<Object, Object>(null, null, 1);
                node4.parent = node7;
                node4.right = node3;
                node3.parent = node7;
                node7.left = node4;
                node2 = node7.right;
                node7.right = node3;
                node7 = node2;
                if (node5 != null) {
                    node5.right = node4;
                }
                node5 = node3;
            }
            node6 = node6.left;
            n3 <<= 1;
        }
        int n4 = n - n3;
        node5 = node6;
        for (n2 = 0; n2 < n4; n2 += 2) {
            node4 = new Node<Object, Object>(null, null, -1);
            node3 = new Node<Object, Object>(null, null, -1);
            node4.parent = node5;
            node3.parent = node5;
            node5.left = node4;
            node2 = node5.right;
            node5.right = node3;
            node5 = node2;
        }
        if (n2 - n4 == 0) {
            node4 = new Node<Object, Object>(null, null, -1);
            node4.parent = node5;
            node5.left = node4;
            node5 = node5.right;
            node4.parent.right = nil;
        }
        while (node5 != nil) {
            node4 = node5.right;
            node5.right = nil;
            node5 = node4;
        }
    }

    final Node<K, V> firstNode() {
        Node node2 = this.root;
        while (node2.left != nil) {
            node2 = node2.left;
        }
        return node2;
    }

    final Node<K, V> getNode(K k) {
        Node node2 = this.root;
        while (node2 != nil) {
            int n = this.compare(k, node2.key);
            if (n > 0) {
                node2 = node2.right;
                continue;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            return node2;
        }
        return node2;
    }

    final Node<K, V> highestLessThan(K k) {
        return this.highestLessThan(k, false);
    }

    final Node<K, V> highestLessThan(K k, boolean bl) {
        if (k == nil) {
            return this.lastNode();
        }
        Node<K, V> node2 = nil;
        Node node3 = this.root;
        int n = 0;
        while (node3 != nil) {
            node2 = node3;
            n = this.compare(k, node3.key);
            if (n > 0) {
                node3 = node3.right;
                continue;
            }
            if (n < 0) {
                node3 = node3.left;
                continue;
            }
            return bl ? node2 : this.predecessor(node2);
        }
        return n < 0 ? this.predecessor(node2) : node2;
    }

    private void insertFixup(Node<K, V> node2) {
        while (node2.parent.color == -1 && node2.parent.parent != nil) {
            Node node3;
            if (node2.parent == node2.parent.parent.left) {
                node3 = node2.parent.parent.right;
                if (node3.color == -1) {
                    node2.parent.color = 1;
                    node3.color = 1;
                    node3.parent.color = -1;
                    node2 = node3.parent;
                    continue;
                }
                if (node2 == node2.parent.right) {
                    node2 = node2.parent;
                    this.rotateLeft(node2);
                }
                node2.parent.color = 1;
                node2.parent.parent.color = -1;
                this.rotateRight(node2.parent.parent);
                continue;
            }
            node3 = node2.parent.parent.left;
            if (node3.color == -1) {
                node2.parent.color = 1;
                node3.color = 1;
                node3.parent.color = -1;
                node2 = node3.parent;
                continue;
            }
            if (node2 == node2.parent.left) {
                node2 = node2.parent;
                this.rotateRight(node2);
            }
            node2.parent.color = 1;
            node2.parent.parent.color = -1;
            this.rotateLeft(node2.parent.parent);
        }
        this.root.color = 1;
    }

    private Node<K, V> lastNode() {
        Node node2 = this.root;
        while (node2.right != nil) {
            node2 = node2.right;
        }
        return node2;
    }

    final Node<K, V> lowestGreaterThan(K k, boolean bl) {
        return this.lowestGreaterThan(k, bl, true);
    }

    final Node<K, V> lowestGreaterThan(K k, boolean bl, boolean bl2) {
        if (k == nil) {
            return bl ? this.firstNode() : nil;
        }
        Node<K, V> node2 = nil;
        Node node3 = this.root;
        int n = 0;
        while (node3 != nil) {
            node2 = node3;
            n = this.compare(k, node3.key);
            if (n > 0) {
                node3 = node3.right;
                continue;
            }
            if (n < 0) {
                node3 = node3.left;
                continue;
            }
            return bl2 ? node3 : this.successor(node3);
        }
        return n > 0 ? this.successor(node2) : node2;
    }

    private Node<K, V> predecessor(Node<K, V> node2) {
        if (node2.left != nil) {
            node2 = node2.left;
            while (node2.right != nil) {
                node2 = node2.right;
            }
            return node2;
        }
        Node node3 = node2.parent;
        while (node2 == node3.left) {
            node2 = node3;
            node3 = node2.parent;
        }
        return node3;
    }

    final void putFromObjStream(ObjectInputStream objectInputStream, int n, boolean bl) throws IOException, ClassNotFoundException {
        this.fabricateTree(n);
        Node<K, V> node2 = this.firstNode();
        while (--n >= 0) {
            node2.key = objectInputStream.readObject();
            node2.value = bl ? objectInputStream.readObject() : "";
            node2 = this.successor(node2);
        }
    }

    final void putKeysLinear(Iterator<K> iterator, int n) {
        this.fabricateTree(n);
        Node<K, V> node2 = this.firstNode();
        while (--n >= 0) {
            node2.key = iterator.next();
            node2.value = "";
            node2 = this.successor(node2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.putFromObjStream(objectInputStream, n, true);
    }

    final void removeNode(Node<K, V> node2) {
        Node node3;
        Node<K, V> node4;
        ++this.modCount;
        --this.size;
        if (node2.left == nil) {
            node4 = node2;
            node3 = node2.right;
        } else if (node2.right == nil) {
            node4 = node2;
            node3 = node2.left;
        } else {
            node4 = node2.left;
            while (node4.right != nil) {
                node4 = node4.right;
            }
            node3 = node4.left;
            node2.key = node4.key;
            node2.value = node4.value;
        }
        Node node5 = node4.parent;
        if (node3 != nil) {
            node3.parent = node5;
        }
        if (node5 == nil) {
            this.root = node3;
            return;
        }
        if (node4 == node5.left) {
            node5.left = node3;
        } else {
            node5.right = node3;
        }
        if (node4.color == 1) {
            this.deleteFixup(node3, node5);
        }
    }

    private void rotateLeft(Node<K, V> node2) {
        Node node3 = node2.right;
        node2.right = node3.left;
        if (node3.left != nil) {
            node3.left.parent = node2;
        }
        node3.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.left) {
                node2.parent.left = node3;
            } else {
                node2.parent.right = node3;
            }
        } else {
            this.root = node3;
        }
        node3.left = node2;
        node2.parent = node3;
    }

    private void rotateRight(Node<K, V> node2) {
        Node node3 = node2.left;
        node2.left = node3.right;
        if (node3.right != nil) {
            node3.right.parent = node2;
        }
        node3.parent = node2.parent;
        if (node2.parent != nil) {
            if (node2 == node2.parent.right) {
                node2.parent.right = node3;
            } else {
                node2.parent.left = node3;
            }
        } else {
            this.root = node3;
        }
        node3.right = node2;
        node2.parent = node3;
    }

    final Node<K, V> successor(Node<K, V> node2) {
        if (node2.right != nil) {
            node2 = node2.right;
            while (node2.left != nil) {
                node2 = node2.left;
            }
            return node2;
        }
        Node node3 = node2.parent;
        while (node2 == node3.right) {
            node2 = node3;
            node3 = node3.parent;
        }
        return node3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Node<K, V> node2 = this.firstNode();
        objectOutputStream.writeInt(this.size);
        while (node2 != nil) {
            objectOutputStream.writeObject(node2.key);
            objectOutputStream.writeObject(node2.value);
            node2 = this.successor(node2);
        }
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k) {
        Node<K, V> node2 = this.lowestGreaterThan(k, false);
        return node2 == nil ? null : node2;
    }

    @Override
    public K ceilingKey(K k) {
        Map.Entry<K, V> entry = this.ceilingEntry(k);
        return entry == null ? null : (K)entry.getKey();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        if (this.descendingMap == null) {
            this.descendingMap = new DescendingMap<K, V>(this);
        }
        return this.descendingMap;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        Node<K, V> node2 = this.firstNode();
        return node2 == nil ? null : node2;
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k) {
        Node<K, V> node2 = this.highestLessThan(k, true);
        return node2 == nil ? null : node2;
    }

    @Override
    public K floorKey(K k) {
        Map.Entry<K, V> entry = this.floorEntry(k);
        return entry == null ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k) {
        Node<K, V> node2 = this.lowestGreaterThan(k, false, false);
        return node2 == nil ? null : node2;
    }

    @Override
    public K higherKey(K k) {
        Map.Entry<K, V> entry = this.higherEntry(k);
        return entry == null ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        Node<K, V> node2 = this.lastNode();
        return node2 == nil ? null : node2;
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k) {
        Node<K, V> node2 = this.highestLessThan(k);
        return node2 == nil ? null : node2;
    }

    @Override
    public K lowerKey(K k) {
        Map.Entry<K, V> entry = this.lowerEntry(k);
        return entry == null ? null : (K)entry.getKey();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        if (this.nKeys == null) {
            this.nKeys = new NavigableKeySet();
        }
        return this.nKeys;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry != null) {
            this.removeNode((Node)entry);
        }
        return entry;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry != null) {
            this.removeNode((Node)entry);
        }
        return entry;
    }

    static {
        TreeMap.nil.parent = nil;
        TreeMap.nil.left = nil;
        TreeMap.nil.right = nil;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NavigableEntrySet
    extends EntrySet
    implements NavigableSet<Map.Entry<K, V>> {
        private NavigableEntrySet() {
        }

        @Override
        public Map.Entry<K, V> ceiling(Map.Entry<K, V> entry) {
            return TreeMap.this.ceilingEntry(entry.getKey());
        }

        @Override
        public Comparator<? super Map.Entry<K, V>> comparator() {
            return new Comparator<Map.Entry<K, V>>(){

                @Override
                public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                    return TreeMap.this.comparator.compare(entry.getKey(), entry2.getKey());
                }
            };
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> descendingSet() {
            return new DescendingSet(this);
        }

        @Override
        public Map.Entry<K, V> first() {
            return TreeMap.this.firstEntry();
        }

        @Override
        public Map.Entry<K, V> floor(Map.Entry<K, V> entry) {
            return TreeMap.this.floorEntry(entry.getKey());
        }

        @Override
        public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> entry) {
            return this.headSet(entry, false);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> entry, boolean bl) {
            return (NavigableSet)TreeMap.this.headMap(entry.getKey(), bl).entrySet();
        }

        @Override
        public Map.Entry<K, V> higher(Map.Entry<K, V> entry) {
            return TreeMap.this.higherEntry(entry.getKey());
        }

        @Override
        public Map.Entry<K, V> last() {
            return TreeMap.this.lastEntry();
        }

        @Override
        public Map.Entry<K, V> lower(Map.Entry<K, V> entry) {
            return TreeMap.this.lowerEntry(entry.getKey());
        }

        @Override
        public Map.Entry<K, V> pollFirst() {
            return TreeMap.this.pollFirstEntry();
        }

        @Override
        public Map.Entry<K, V> pollLast() {
            return TreeMap.this.pollLastEntry();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
            return this.subSet(entry, true, entry2, false);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> entry, boolean bl, Map.Entry<K, V> entry2, boolean bl2) {
            return (NavigableSet)TreeMap.this.subMap(entry.getKey(), bl, entry2.getKey(), bl2).entrySet();
        }

        @Override
        public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> entry) {
            return this.tailSet(entry, true);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> entry, boolean bl) {
            return TreeMap.this.tailMap(entry.getKey(), bl).navigableKeySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new TreeIterator(2);
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Node node2 = TreeMap.this.getNode(entry.getKey());
            return node2 != nil && AbstractSet.equals(entry.getValue(), node2.value);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Node node2 = TreeMap.this.getNode(entry.getKey());
            if (node2 != nil && AbstractSet.equals(entry.getValue(), node2.value)) {
                TreeMap.this.removeNode(node2);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DescendingSet<D>
    implements NavigableSet<D> {
        private NavigableSet<D> set;

        public DescendingSet(NavigableSet<D> navigableSet) {
            this.set = navigableSet;
        }

        @Override
        public boolean add(D d) {
            return this.set.add(d);
        }

        @Override
        public boolean addAll(Collection<? extends D> collection) {
            return this.set.addAll(collection);
        }

        @Override
        public D ceiling(D d) {
            return this.set.floor(d);
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public Comparator<? super D> comparator() {
            return Collections.reverseOrder(this.set.comparator());
        }

        @Override
        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.set.containsAll(collection);
        }

        @Override
        public Iterator<D> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<D> descendingSet() {
            return this.set;
        }

        @Override
        public boolean equals(Object object) {
            return this.set.equals(object);
        }

        @Override
        public D first() {
            return (D)this.set.last();
        }

        @Override
        public D floor(D d) {
            return this.set.ceiling(d);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        @Override
        public SortedSet<D> headSet(D d) {
            return this.headSet(d, false);
        }

        @Override
        public NavigableSet<D> headSet(D d, boolean bl) {
            return new DescendingSet<D>(this.set.tailSet(d, bl));
        }

        @Override
        public D higher(D d) {
            return this.set.lower(d);
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Iterator<D> iterator() {
            return new Iterator<D>(){
                private D last;
                private D next;
                {
                    this.next = DescendingSet.this.first();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public D next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.next;
                    this.next = DescendingSet.this.higher(this.last);
                    return this.last;
                }

                @Override
                public void remove() {
                    if (this.last == null) {
                        throw new IllegalStateException();
                    }
                    DescendingSet.this.remove(this.last);
                    this.last = null;
                }
            };
        }

        @Override
        public D last() {
            return (D)this.set.first();
        }

        @Override
        public D lower(D d) {
            return this.set.higher(d);
        }

        @Override
        public D pollFirst() {
            return this.set.pollLast();
        }

        @Override
        public D pollLast() {
            return this.set.pollFirst();
        }

        @Override
        public boolean remove(Object object) {
            return this.set.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.set.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.set.retainAll(collection);
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public SortedSet<D> subSet(D d, D d2) {
            return this.subSet(d, true, d2, false);
        }

        @Override
        public NavigableSet<D> subSet(D d, boolean bl, D d2, boolean bl2) {
            return new DescendingSet<D>(this.set.subSet(d, bl, d2, bl2));
        }

        @Override
        public SortedSet<D> tailSet(D d) {
            return this.tailSet(d, true);
        }

        @Override
        public NavigableSet<D> tailSet(D d, boolean bl) {
            return new DescendingSet<D>(this.set.headSet(d, bl));
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = this.set.toArray();
            Arrays.sort(objectArray, this.comparator());
            return objectArray;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = this.set.toArray(TArray);
            Arrays.sort(TArray2, this.comparator());
            return TArray2;
        }

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
            for (D d : this) {
                if (d == this) {
                    cPStringBuilder.append("<this>");
                } else {
                    cPStringBuilder.append(d);
                }
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.replace(cPStringBuilder.length() - 2, cPStringBuilder.length(), "]");
            return cPStringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NavigableKeySet
    extends KeySet
    implements NavigableSet<K> {
        private NavigableKeySet() {
        }

        @Override
        public K ceiling(K k) {
            return TreeMap.this.ceilingKey(k);
        }

        @Override
        public Comparator<? super K> comparator() {
            return TreeMap.this.comparator;
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new DescendingSet(this);
        }

        @Override
        public K first() {
            return TreeMap.this.firstKey();
        }

        @Override
        public K floor(K k) {
            return TreeMap.this.floorKey(k);
        }

        @Override
        public SortedSet<K> headSet(K k) {
            return this.headSet((K)k, false);
        }

        @Override
        public NavigableSet<K> headSet(K k, boolean bl) {
            return TreeMap.this.headMap(k, bl).navigableKeySet();
        }

        @Override
        public K higher(K k) {
            return TreeMap.this.higherKey(k);
        }

        @Override
        public K last() {
            return TreeMap.this.lastKey();
        }

        @Override
        public K lower(K k) {
            return TreeMap.this.lowerKey(k);
        }

        @Override
        public K pollFirst() {
            return TreeMap.this.pollFirstEntry().getKey();
        }

        @Override
        public K pollLast() {
            return TreeMap.this.pollLastEntry().getKey();
        }

        @Override
        public SortedSet<K> subSet(K k, K k2) {
            return this.subSet((K)k, true, (K)k2, false);
        }

        @Override
        public NavigableSet<K> subSet(K k, boolean bl, K k2, boolean bl2) {
            return TreeMap.this.subMap(k, bl, k2, bl2).navigableKeySet();
        }

        @Override
        public SortedSet<K> tailSet(K k) {
            return this.tailSet((K)k, true);
        }

        @Override
        public NavigableSet<K> tailSet(K k, boolean bl) {
            return TreeMap.this.tailMap(k, bl).navigableKeySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return TreeMap.this.size;
        }

        @Override
        public Iterator<K> iterator() {
            return new TreeIterator(0);
        }

        @Override
        public void clear() {
            TreeMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return TreeMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            Node node2 = TreeMap.this.getNode(object);
            if (node2 == nil) {
                return false;
            }
            TreeMap.this.removeNode(node2);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DescendingMap<DK, DV>
    implements NavigableMap<DK, DV> {
        private Set<Map.Entry<DK, DV>> entries;
        private Set<DK> keys;
        private NavigableSet<DK> nKeys;
        private Collection<DV> values;
        private NavigableMap<DK, DV> map;

        public DescendingMap(NavigableMap<DK, DV> navigableMap) {
            this.map = navigableMap;
        }

        @Override
        public Map.Entry<DK, DV> ceilingEntry(DK DK) {
            return this.map.floorEntry(DK);
        }

        @Override
        public DK ceilingKey(DK DK) {
            return this.map.floorKey(DK);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Comparator<? super DK> comparator() {
            return Collections.reverseOrder(this.map.comparator());
        }

        @Override
        public boolean containsKey(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        public NavigableSet<DK> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<DK, DV> descendingMap() {
            return this.map;
        }

        @Override
        public Set<Map.Entry<DK, DV>> entrySet() {
            if (this.entries == null) {
                this.entries = new DescendingSet<Map.Entry<DK, DV>>((NavigableSet)this.map.entrySet());
            }
            return this.entries;
        }

        @Override
        public boolean equals(Object object) {
            return this.map.equals(object);
        }

        @Override
        public Map.Entry<DK, DV> firstEntry() {
            return this.map.lastEntry();
        }

        @Override
        public DK firstKey() {
            return (DK)this.map.lastKey();
        }

        @Override
        public Map.Entry<DK, DV> floorEntry(DK DK) {
            return this.map.ceilingEntry(DK);
        }

        @Override
        public DK floorKey(DK DK) {
            return this.map.ceilingKey(DK);
        }

        @Override
        public DV get(Object object) {
            return (DV)this.map.get(object);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public SortedMap<DK, DV> headMap(DK DK) {
            return this.headMap(DK, false);
        }

        @Override
        public NavigableMap<DK, DV> headMap(DK DK, boolean bl) {
            return new DescendingMap<DK, DV>(this.map.tailMap(DK, bl));
        }

        @Override
        public Map.Entry<DK, DV> higherEntry(DK DK) {
            return this.map.lowerEntry(DK);
        }

        @Override
        public DK higherKey(DK DK) {
            return this.map.lowerKey(DK);
        }

        @Override
        public Set<DK> keySet() {
            if (this.keys == null) {
                this.keys = new DescendingSet<DK>(this.map.navigableKeySet());
            }
            return this.keys;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Map.Entry<DK, DV> lastEntry() {
            return this.map.firstEntry();
        }

        @Override
        public DK lastKey() {
            return (DK)this.map.firstKey();
        }

        @Override
        public Map.Entry<DK, DV> lowerEntry(DK DK) {
            return this.map.higherEntry(DK);
        }

        @Override
        public DK lowerKey(DK DK) {
            return this.map.higherKey(DK);
        }

        @Override
        public NavigableSet<DK> navigableKeySet() {
            if (this.nKeys == null) {
                this.nKeys = new DescendingSet<DK>(this.map.navigableKeySet());
            }
            return this.nKeys;
        }

        @Override
        public Map.Entry<DK, DV> pollFirstEntry() {
            return this.pollLastEntry();
        }

        @Override
        public Map.Entry<DK, DV> pollLastEntry() {
            return this.pollFirstEntry();
        }

        @Override
        public DV put(DK DK, DV DV) {
            return this.map.put(DK, DV);
        }

        @Override
        public void putAll(Map<? extends DK, ? extends DV> map) {
            this.map.putAll(map);
        }

        @Override
        public DV remove(Object object) {
            return (DV)this.map.remove(object);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public SortedMap<DK, DV> subMap(DK DK, DK DK2) {
            return this.subMap(DK, true, DK2, false);
        }

        @Override
        public NavigableMap<DK, DV> subMap(DK DK, boolean bl, DK DK2, boolean bl2) {
            return new DescendingMap<DK, DV>(this.map.subMap(DK, bl, DK2, bl2));
        }

        @Override
        public SortedMap<DK, DV> tailMap(DK DK) {
            return this.tailMap(DK, true);
        }

        @Override
        public NavigableMap<DK, DV> tailMap(DK DK, boolean bl) {
            return new DescendingMap<DK, DV>(this.map.headMap(DK, bl));
        }

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder("{");
            for (Map.Entry<DK, DV> entry : this.entrySet()) {
                cPStringBuilder.append(entry.getKey());
                cPStringBuilder.append('=');
                cPStringBuilder.append(entry.getValue());
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.replace(cPStringBuilder.length() - 2, cPStringBuilder.length(), "}");
            return cPStringBuilder.toString();
        }

        @Override
        public Collection<DV> values() {
            if (this.values == null) {
                this.values = new AbstractCollection(){

                    @Override
                    public int size() {
                        return DescendingMap.this.size();
                    }

                    @Override
                    public Iterator<DV> iterator() {
                        return new Iterator<DV>(){
                            private Map.Entry<DK, DV> last;
                            private Map.Entry<DK, DV> next;
                            {
                                this.next = DescendingMap.this.firstEntry();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.next != null;
                            }

                            @Override
                            public DV next() {
                                if (this.next == null) {
                                    throw new NoSuchElementException();
                                }
                                this.last = this.next;
                                this.next = DescendingMap.this.higherEntry(this.last.getKey());
                                return this.last.getValue();
                            }

                            @Override
                            public void remove() {
                                if (this.last == null) {
                                    throw new IllegalStateException();
                                }
                                DescendingMap.this.remove(this.last.getKey());
                                this.last = null;
                            }
                        };
                    }

                    @Override
                    public void clear() {
                        DescendingMap.this.clear();
                    }
                };
            }
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SubMap
    extends AbstractMap<K, V>
    implements NavigableMap<K, V> {
        final K minKey;
        final K maxKey;
        private Set<Map.Entry<K, V>> entries;
        private NavigableMap<K, V> descendingMap;
        private NavigableSet<K> nKeys;

        SubMap(K k, K k2) {
            if (k != nil && k2 != nil && TreeMap.this.compare(k, k2) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.minKey = k;
            this.maxKey = k2;
        }

        boolean keyInRange(K k) {
            return !(this.minKey != nil && TreeMap.this.compare(k, this.minKey) < 0 || this.maxKey != nil && TreeMap.this.compare(k, this.maxKey) >= 0);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K k) {
            Map.Entry entry = TreeMap.this.ceilingEntry(k);
            if (entry != null && this.keyInRange(entry.getKey())) {
                return entry;
            }
            return null;
        }

        @Override
        public K ceilingKey(K k) {
            Object k2 = TreeMap.this.ceilingKey(k);
            if (this.keyInRange(k2)) {
                return k2;
            }
            return null;
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            if (this.descendingMap == null) {
                this.descendingMap = new DescendingMap(this);
            }
            return this.descendingMap;
        }

        @Override
        public void clear() {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node node3 = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (node2 != node3) {
                Node node4 = node2;
                node2 = TreeMap.this.successor(node4);
                TreeMap.this.removeNode(node4);
            }
        }

        @Override
        public Comparator<? super K> comparator() {
            return TreeMap.this.comparator;
        }

        @Override
        public boolean containsKey(Object object) {
            return this.keyInRange(object) && TreeMap.this.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node node3 = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            while (node2 != node3) {
                if (SubMap.equals(object, node2.getValue())) {
                    return true;
                }
                node2 = TreeMap.this.successor(node2);
            }
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                this.entries = new NavigableEntrySet();
            }
            return this.entries;
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            if (node2 == nil || !this.keyInRange(node2.key)) {
                return null;
            }
            return node2;
        }

        @Override
        public K firstKey() {
            Map.Entry entry = this.firstEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getKey();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K k) {
            Map.Entry entry = TreeMap.this.floorEntry(k);
            if (entry != null && this.keyInRange(entry.getKey())) {
                return entry;
            }
            return null;
        }

        @Override
        public K floorKey(K k) {
            Object k2 = TreeMap.this.floorKey(k);
            if (this.keyInRange(k2)) {
                return k2;
            }
            return null;
        }

        @Override
        public V get(Object object) {
            if (this.keyInRange(object)) {
                return TreeMap.this.get(object);
            }
            return null;
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return this.headMap(k, false);
        }

        @Override
        public NavigableMap<K, V> headMap(K k, boolean bl) {
            if (!this.keyInRange(k)) {
                throw new IllegalArgumentException("Key outside submap range");
            }
            return new SubMap(this.minKey, bl ? TreeMap.this.successor(TreeMap.this.getNode(k)).key : k);
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = new KeySet();
            }
            return this.keys;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K k) {
            Map.Entry entry = TreeMap.this.higherEntry(k);
            if (entry != null && this.keyInRange(entry.getKey())) {
                return entry;
            }
            return null;
        }

        @Override
        public K higherKey(K k) {
            Object k2 = TreeMap.this.higherKey(k);
            if (this.keyInRange(k2)) {
                return k2;
            }
            return null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.lowerEntry(this.maxKey);
        }

        @Override
        public K lastKey() {
            Map.Entry entry = this.lastEntry();
            if (entry == null) {
                throw new NoSuchElementException();
            }
            return entry.getKey();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K k) {
            Map.Entry entry = TreeMap.this.lowerEntry(k);
            if (entry != null && this.keyInRange(entry.getKey())) {
                return entry;
            }
            return null;
        }

        @Override
        public K lowerKey(K k) {
            Object k2 = TreeMap.this.lowerKey(k);
            if (this.keyInRange(k2)) {
                return k2;
            }
            return null;
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            if (this.nKeys == null) {
                this.nKeys = new NavigableKeySet();
            }
            return this.nKeys;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry entry = this.firstEntry();
            if (entry != null) {
                TreeMap.this.removeNode((Node)entry);
            }
            return entry;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry entry = this.lastEntry();
            if (entry != null) {
                TreeMap.this.removeNode((Node)entry);
            }
            return entry;
        }

        @Override
        public V put(K k, V v) {
            if (!this.keyInRange(k)) {
                throw new IllegalArgumentException("Key outside range");
            }
            return TreeMap.this.put(k, v);
        }

        @Override
        public V remove(Object object) {
            if (this.keyInRange(object)) {
                return TreeMap.this.remove(object);
            }
            return null;
        }

        @Override
        public int size() {
            Node node2 = TreeMap.this.lowestGreaterThan(this.minKey, true);
            Node node3 = TreeMap.this.lowestGreaterThan(this.maxKey, false);
            int n = 0;
            while (node2 != node3) {
                ++n;
                node2 = TreeMap.this.successor(node2);
            }
            return n;
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return this.subMap(k, true, k2, false);
        }

        @Override
        public NavigableMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
            if (!this.keyInRange(k) || !this.keyInRange(k2)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(bl ? k : TreeMap.this.successor(TreeMap.this.getNode(k)).key, bl2 ? TreeMap.this.successor(TreeMap.this.getNode(k2)).key : k2);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return this.tailMap(k, true);
        }

        @Override
        public NavigableMap<K, V> tailMap(K k, boolean bl) {
            if (!this.keyInRange(k)) {
                throw new IllegalArgumentException("key outside range");
            }
            return new SubMap(bl ? k : TreeMap.this.successor(TreeMap.this.getNode(k)).key, this.maxKey);
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new AbstractCollection(){

                    @Override
                    public int size() {
                        return SubMap.this.size();
                    }

                    @Override
                    public Iterator<V> iterator() {
                        Node node2 = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                        Node node3 = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                        return new TreeIterator(1, node2, node3);
                    }

                    @Override
                    public void clear() {
                        SubMap.this.clear();
                    }
                };
            }
            return this.values;
        }

        /*
         * Signature claims super is java.util.TreeMap$SubMap.EntrySet, not java.util.TreeMap$SubMap$EntrySet - discarding signature.
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class NavigableEntrySet
        extends EntrySet
        implements NavigableSet {
            private NavigableEntrySet() {
            }

            public Map.Entry<K, V> ceiling(Map.Entry<K, V> entry) {
                return SubMap.this.ceilingEntry(entry.getKey());
            }

            @Override
            public Comparator<? super Map.Entry<K, V>> comparator() {
                return new Comparator<Map.Entry<K, V>>(){

                    @Override
                    public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                        return TreeMap.this.comparator.compare(entry.getKey(), entry2.getKey());
                    }
                };
            }

            public Iterator<Map.Entry<K, V>> descendingIterator() {
                return this.descendingSet().iterator();
            }

            public NavigableSet<Map.Entry<K, V>> descendingSet() {
                return new DescendingSet(this);
            }

            @Override
            public Map.Entry<K, V> first() {
                return SubMap.this.firstEntry();
            }

            public Map.Entry<K, V> floor(Map.Entry<K, V> entry) {
                return SubMap.this.floorEntry(entry.getKey());
            }

            @Override
            public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> entry) {
                return this.headSet(entry, false);
            }

            public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> entry, boolean bl) {
                return (NavigableSet)SubMap.this.headMap(entry.getKey(), bl).entrySet();
            }

            public Map.Entry<K, V> higher(Map.Entry<K, V> entry) {
                return SubMap.this.higherEntry(entry.getKey());
            }

            @Override
            public Map.Entry<K, V> last() {
                return SubMap.this.lastEntry();
            }

            public Map.Entry<K, V> lower(Map.Entry<K, V> entry) {
                return SubMap.this.lowerEntry(entry.getKey());
            }

            public Map.Entry<K, V> pollFirst() {
                return SubMap.this.pollFirstEntry();
            }

            public Map.Entry<K, V> pollLast() {
                return SubMap.this.pollLastEntry();
            }

            @Override
            public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                return this.subSet(entry, true, entry2, false);
            }

            public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> entry, boolean bl, Map.Entry<K, V> entry2, boolean bl2) {
                return (NavigableSet)SubMap.this.subMap(entry.getKey(), bl, entry2.getKey(), bl2).entrySet();
            }

            @Override
            public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> entry) {
                return this.tailSet(entry, true);
            }

            public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> entry, boolean bl) {
                return SubMap.this.tailMap(entry.getKey(), bl).navigableKeySet();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public int size() {
                return SubMap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                Node node2 = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                Node node3 = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                return new TreeIterator(2, node2, node3);
            }

            @Override
            public void clear() {
                SubMap.this.clear();
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!SubMap.this.keyInRange(k)) {
                    return false;
                }
                Node node2 = TreeMap.this.getNode(k);
                return node2 != nil && AbstractSet.equals(entry.getValue(), node2.value);
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                if (!SubMap.this.keyInRange(k)) {
                    return false;
                }
                Node node2 = TreeMap.this.getNode(k);
                if (node2 != nil && AbstractSet.equals(entry.getValue(), node2.value)) {
                    TreeMap.this.removeNode(node2);
                    return true;
                }
                return false;
            }
        }

        /*
         * Signature claims super is java.util.TreeMap$SubMap.KeySet, not java.util.TreeMap$SubMap$KeySet - discarding signature.
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class NavigableKeySet
        extends KeySet
        implements NavigableSet {
            private NavigableKeySet() {
            }

            public K ceiling(K k) {
                return SubMap.this.ceilingKey(k);
            }

            @Override
            public Comparator<? super K> comparator() {
                return TreeMap.this.comparator;
            }

            public Iterator<K> descendingIterator() {
                return this.descendingSet().iterator();
            }

            public NavigableSet<K> descendingSet() {
                return new DescendingSet(this);
            }

            @Override
            public K first() {
                return SubMap.this.firstKey();
            }

            public K floor(K k) {
                return SubMap.this.floorKey(k);
            }

            @Override
            public SortedSet<K> headSet(K k) {
                return this.headSet((K)k, false);
            }

            public NavigableSet<K> headSet(K k, boolean bl) {
                return SubMap.this.headMap(k, bl).navigableKeySet();
            }

            public K higher(K k) {
                return SubMap.this.higherKey(k);
            }

            @Override
            public K last() {
                return SubMap.this.lastKey();
            }

            public K lower(K k) {
                return SubMap.this.lowerKey(k);
            }

            public K pollFirst() {
                return SubMap.this.pollFirstEntry().getKey();
            }

            public K pollLast() {
                return SubMap.this.pollLastEntry().getKey();
            }

            @Override
            public SortedSet<K> subSet(K k, K k2) {
                return this.subSet((K)k, true, (K)k2, false);
            }

            public NavigableSet<K> subSet(K k, boolean bl, K k2, boolean bl2) {
                return SubMap.this.subMap(k, bl, k2, bl2).navigableKeySet();
            }

            @Override
            public SortedSet<K> tailSet(K k) {
                return this.tailSet((K)k, true);
            }

            public NavigableSet<K> tailSet(K k, boolean bl) {
                return SubMap.this.tailMap(k, bl).navigableKeySet();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public int size() {
                return SubMap.this.size();
            }

            @Override
            public Iterator<K> iterator() {
                Node node2 = TreeMap.this.lowestGreaterThan(SubMap.this.minKey, true);
                Node node3 = TreeMap.this.lowestGreaterThan(SubMap.this.maxKey, false);
                return new TreeIterator(0, node2, node3);
            }

            @Override
            public void clear() {
                SubMap.this.clear();
            }

            @Override
            public boolean contains(Object object) {
                if (!SubMap.this.keyInRange(object)) {
                    return false;
                }
                return TreeMap.this.getNode(object) != nil;
            }

            @Override
            public boolean remove(Object object) {
                if (!SubMap.this.keyInRange(object)) {
                    return false;
                }
                Node node2 = TreeMap.this.getNode(object);
                if (node2 != nil) {
                    TreeMap.this.removeNode(node2);
                    return true;
                }
                return false;
            }
        }
    }

    private final class TreeIterator
    implements Iterator {
        private final int type;
        private int knownMod;
        private Node last;
        private Node next;
        private final Node max;

        TreeIterator(int n) {
            this(n, treeMap.firstNode(), nil);
        }

        TreeIterator(int n, Node node2, Node node3) {
            this.knownMod = TreeMap.this.modCount;
            this.type = n;
            this.next = node2;
            this.max = node3;
        }

        public boolean hasNext() {
            return this.next != this.max;
        }

        public Object next() {
            if (this.knownMod != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == this.max) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = TreeMap.this.successor(this.last);
            if (this.type == 1) {
                return this.last.value;
            }
            if (this.type == 0) {
                return this.last.key;
            }
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (this.knownMod != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            TreeMap.this.removeNode(this.last);
            this.last = null;
            ++this.knownMod;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Node<K, V>
    extends AbstractMap.SimpleEntry<K, V> {
        int color;
        Node<K, V> left = nil;
        Node<K, V> right = nil;
        Node<K, V> parent = nil;

        Node(K k, V v, int n) {
            super(k, v);
            this.color = n;
        }
    }
}

