/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.VMStackWalker;
import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceBundle {
    private static final int CACHE_SIZE = 100;
    protected ResourceBundle parent;
    private Locale locale;
    private static Map<BundleKey, Object> bundleCache = new LinkedHashMap<BundleKey, Object>(101, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<BundleKey, Object> entry) {
            return this.size() > 100;
        }
    };
    private static final BundleKey lookupKey = new BundleKey();
    private static final Object nullEntry = new Object();

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) {
        Object object = this;
        while (object != null) {
            Object object2 = ((ResourceBundle)object).handleGetObject(string);
            if (object2 != null) {
                return object2;
            }
            object = ((ResourceBundle)object).parent;
        }
        object = this.getClass().getName();
        throw new MissingResourceException("Key '" + string + "'not found in Bundle: " + (String)object, (String)object, string);
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    public static ResourceBundle getBundle(String string) {
        ClassLoader classLoader = VMStackWalker.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        ClassLoader classLoader = VMStackWalker.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(string, locale, classLoader);
    }

    public static synchronized ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        Locale locale2 = Locale.getDefault();
        lookupKey.set(locale2, string, locale, classLoader);
        Object object = bundleCache.get(lookupKey);
        if (object instanceof ResourceBundle) {
            return (ResourceBundle)object;
        }
        if (object == nullEntry) {
            throw new MissingResourceException("Bundle " + string + " not found for locale " + locale + " by classloader " + classLoader, string, "");
        }
        boolean bl = locale.equals(locale2);
        ResourceBundle resourceBundle = ResourceBundle.tryBundle(string, locale, classLoader, bl);
        if (resourceBundle == null && !bl) {
            resourceBundle = ResourceBundle.tryBundle(string, locale2, classLoader, true);
        }
        BundleKey bundleKey = new BundleKey(locale2, string, locale, classLoader);
        if (resourceBundle == null) {
            bundleCache.put(bundleKey, nullEntry);
            throw new MissingResourceException("Bundle " + string + " not found for locale " + locale + " by classloader " + classLoader, string, "");
        }
        bundleCache.put(bundleKey, resourceBundle);
        return resourceBundle;
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration<String> getKeys();

    private static ResourceBundle tryBundle(String string, ClassLoader classLoader) {
        Object object;
        ResourceBundle resourceBundle = null;
        try {
            object = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            if (ResourceBundle.class.isAssignableFrom((Class<?>)object)) {
                resourceBundle = (ResourceBundle)((Class)object).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceBundle == null) {
            try {
                String string2 = string.replace('.', '/') + ".properties";
                object = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
                if (object != null) {
                    resourceBundle = new PropertyResourceBundle((InputStream)object);
                }
            }
            catch (IOException iOException) {
                MissingResourceException missingResourceException = new MissingResourceException("Failed to load bundle: " + string, string, "");
                missingResourceException.initCause(iOException);
                throw missingResourceException;
            }
        }
        return resourceBundle;
    }

    private static ResourceBundle tryBundle(String string, Locale locale, ClassLoader classLoader, boolean bl) {
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        int n = string.length();
        CPStringBuilder cPStringBuilder = new CPStringBuilder(n + string4.length() + 7);
        cPStringBuilder.append(string);
        if (string2.length() > 0) {
            cPStringBuilder.append('_');
            cPStringBuilder.append(string2);
            if (string3.length() > 0) {
                cPStringBuilder.append('_');
                cPStringBuilder.append(string3);
                if (string4.length() > 0) {
                    cPStringBuilder.append('_');
                    cPStringBuilder.append(string4);
                }
            }
        }
        String string5 = cPStringBuilder.toString();
        ResourceBundle resourceBundle = null;
        ResourceBundle resourceBundle2 = null;
        while (true) {
            int n2;
            ResourceBundle resourceBundle3;
            if ((resourceBundle3 = ResourceBundle.tryBundle(string5, classLoader)) != null) {
                if (resourceBundle == null) {
                    resourceBundle = resourceBundle3;
                }
                if (resourceBundle2 != null) {
                    resourceBundle2.parent = resourceBundle3;
                }
                resourceBundle3.locale = locale;
                resourceBundle2 = resourceBundle3;
            }
            if ((n2 = string5.lastIndexOf(95)) <= n && (n2 != n || resourceBundle == null && !bl)) break;
            string5 = string5.substring(0, n2);
        }
        return resourceBundle;
    }

    public static final void clearCache() {
        ResourceBundle.clearCache(VMStackWalker.getCallingClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearCache(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("The loader can not be null.");
        }
        Class<ResourceBundle> clazz = ResourceBundle.class;
        synchronized (ResourceBundle.class) {
            Iterator<BundleKey> iterator = bundleCache.keySet().iterator();
            while (iterator.hasNext()) {
                BundleKey bundleKey = iterator.next();
                if (bundleKey.classLoader != classLoader) continue;
                iterator.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class BundleKey {
        Locale defaultLocale;
        String baseName;
        Locale locale;
        ClassLoader classLoader;
        int hashcode;

        BundleKey() {
        }

        BundleKey(Locale locale, String string, Locale locale2, ClassLoader classLoader) {
            this.set(locale, string, locale2, classLoader);
        }

        void set(Locale locale, String string, Locale locale2, ClassLoader classLoader) {
            this.defaultLocale = locale;
            this.baseName = string;
            this.locale = locale2;
            this.classLoader = classLoader;
            this.hashcode = this.defaultLocale.hashCode() ^ this.baseName.hashCode() ^ this.locale.hashCode() ^ this.classLoader.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BundleKey)) {
                return false;
            }
            BundleKey bundleKey = (BundleKey)object;
            return this.hashcode == bundleKey.hashcode && this.defaultLocale.equals(bundleKey.defaultLocale) && this.baseName.equals(bundleKey.baseName) && this.locale.equals(bundleKey.locale) && this.classLoader.equals(bundleKey.classLoader);
        }

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder(this.getClass().getName());
            cPStringBuilder.append("[defaultLocale=");
            cPStringBuilder.append(this.defaultLocale);
            cPStringBuilder.append(",baseName=");
            cPStringBuilder.append(this.baseName);
            cPStringBuilder.append(",locale=");
            cPStringBuilder.append(this.locale);
            cPStringBuilder.append(",classLoader=");
            cPStringBuilder.append(this.classLoader);
            cPStringBuilder.append("]");
            return cPStringBuilder.toString();
        }
    }
}

