/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;

public final class PropertyPermission
extends BasicPermission {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("action", String.class)};
    private static final long serialVersionUID = 885438825399942851L;
    private static final int READ = 1;
    private static final int WRITE = 2;
    transient int actions;
    private static final String[] actionStrings = new String[]{"", "read", "write", "read,write"};

    public PropertyPermission(String string, String string2) {
        super(string);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.setActions(string2);
    }

    private void setActions(String string) {
        if ("read".equals(string)) {
            this.actions = 1;
        } else if ("write".equals(string)) {
            this.actions = 2;
        } else if ("read,write".equals(string) || "write,read".equals(string)) {
            this.actions = 3;
        } else {
            String string2 = string.toLowerCase();
            if ("read".equals(string2)) {
                this.actions = 1;
            } else if ("write".equals(string2)) {
                this.actions = 2;
            } else if ("read,write".equals(string2) || "write,read".equals(string2)) {
                this.actions = 3;
            } else {
                throw new IllegalArgumentException("illegal action " + string);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.setActions((String)getField.get("actions", null));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("actions", this.getActions());
        objectOutputStream.writeFields();
    }

    public boolean implies(Permission permission) {
        if (super.implies(permission)) {
            PropertyPermission propertyPermission = (PropertyPermission)permission;
            return (propertyPermission.actions & ~this.actions) == 0;
        }
        return false;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.actions == ((PropertyPermission)object).actions;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getActions() {
        return actionStrings[this.actions];
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }
}

