/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final long serialVersionUID = -7720805057305804111L;
    int used = 0;
    E[] storage;
    Comparator<? super E> comparator;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(Collection<? extends E> collection) {
        this(Math.max(1, (int)(1.1 * (double)collection.size())), null);
        if (collection instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)collection;
            this.comparator = sortedSet.comparator();
            int n = 0;
            for (Object e : sortedSet) {
                if (e == null) {
                    throw new NullPointerException();
                }
                this.storage[n++] = e;
            }
        } else if (collection instanceof PriorityQueue) {
            PriorityQueue priorityQueue = (PriorityQueue)collection;
            this.comparator = priorityQueue.comparator();
            System.arraycopy(priorityQueue.storage, 0, this.storage, 0, priorityQueue.storage.length);
        }
        this.addAll(collection);
    }

    public PriorityQueue(int n) {
        this(n, null);
    }

    public PriorityQueue(int n, Comparator<? super E> comparator) {
        this.storage = new Object[n];
        this.comparator = comparator;
    }

    public PriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        this(Math.max(1, (int)(1.1 * (double)priorityQueue.size())), priorityQueue.comparator());
        System.arraycopy(priorityQueue.storage, 0, this.storage, 0, priorityQueue.storage.length);
    }

    public PriorityQueue(SortedSet<? extends E> sortedSet) {
        this(Math.max(1, (int)(1.1 * (double)sortedSet.size())), sortedSet.comparator());
        int n = 0;
        for (Object e : sortedSet) {
            if (e == null) {
                throw new NullPointerException();
            }
            this.storage[n++] = e;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.storage, null);
        this.used = 0;
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int index = -1;
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < PriorityQueue.this.used;
            }

            @Override
            public E next() {
                while (PriorityQueue.this.storage[++this.index] == null) {
                }
                ++this.count;
                return PriorityQueue.this.storage[this.index];
            }

            @Override
            public void remove() {
                PriorityQueue.this.remove(this.index);
            }
        };
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        int n = this.findSlot(-1);
        this.storage[n] = e;
        ++this.used;
        this.bubbleUp(n);
        return true;
    }

    @Override
    public E peek() {
        return this.used == 0 ? null : (E)this.storage[0];
    }

    @Override
    public E poll() {
        if (this.used == 0) {
            return null;
        }
        E e = this.storage[0];
        this.remove(0);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        if (object != null) {
            for (int i = 0; i < this.storage.length; ++i) {
                if (!object.equals(this.storage[i])) continue;
                this.remove(i);
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this.used;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = -1;
        int n2 = this.used;
        for (E e : collection) {
            if (e == null) {
                throw new NullPointerException();
            }
            n = this.findSlot(n);
            this.storage[n] = e;
            ++this.used;
            this.bubbleUp(n);
        }
        return n2 != this.used;
    }

    int findSlot(int n) {
        int n2;
        if (this.used == this.storage.length) {
            this.resize();
            n2 = this.used;
        } else {
            for (n2 = n + 1; n2 < this.storage.length && this.storage[n2] != null; ++n2) {
            }
        }
        return n2;
    }

    void remove(int n) {
        while (this.storage[n] != null) {
            int n2 = 2 * n + 1;
            if (n2 >= this.storage.length) {
                this.storage[n] = null;
                break;
            }
            if (n2 + 1 < this.storage.length && this.storage[n2 + 1] != null && (this.storage[n2] == null || Collections.compare(this.storage[n2], this.storage[n2 + 1], this.comparator) > 0)) {
                ++n2;
            }
            this.storage[n] = this.storage[n2];
            n = n2;
        }
        --this.used;
    }

    void bubbleUp(int n) {
        int n2;
        while (n > 0 && Collections.compare(this.storage[n2 = (n - 1) / 2], this.storage[n], this.comparator) > 0) {
            E e = this.storage[n];
            this.storage[n] = this.storage[n2];
            this.storage[n2] = e;
            n = n2;
        }
    }

    void resize() {
        Object[] objectArray = new Object[2 * this.storage.length];
        System.arraycopy(this.storage, 0, objectArray, 0, this.storage.length);
        this.storage = objectArray;
    }
}

