/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    transient LinkedHashEntry root;
    final boolean accessOrder;

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> map) {
        super(map);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    @Override
    public void clear() {
        super.clear();
        this.root = null;
    }

    @Override
    public boolean containsValue(Object object) {
        LinkedHashEntry linkedHashEntry = this.root;
        while (linkedHashEntry != null) {
            if (LinkedHashMap.equals(object, linkedHashEntry.value)) {
                return true;
            }
            linkedHashEntry = linkedHashEntry.succ;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        int n = this.hash(object);
        HashMap.HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (LinkedHashMap.equals(object, hashEntry.key)) {
                hashEntry.access();
                return (V)hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return false;
    }

    @Override
    void addEntry(K k, V v, int n, boolean bl) {
        LinkedHashEntry<K, V> linkedHashEntry = new LinkedHashEntry<K, V>(k, v);
        linkedHashEntry.next = this.buckets[n];
        this.buckets[n] = linkedHashEntry;
        if (bl && this.removeEldestEntry(this.root)) {
            this.remove(this.root.key);
        }
    }

    @Override
    void putAllInternal(Map map) {
        this.root = null;
        super.putAllInternal(map);
    }

    @Override
    Iterator iterator(final int n) {
        return new Iterator(){
            LinkedHashEntry current;
            LinkedHashEntry last;
            int knownMod;
            {
                this.current = LinkedHashMap.this.root;
                this.knownMod = LinkedHashMap.this.modCount;
            }

            public boolean hasNext() {
                return this.current != null;
            }

            public Object next() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = this.current.succ;
                return n == 1 ? this.last.value : (n == 0 ? this.last.key : this.last);
            }

            public void remove() {
                if (this.knownMod != LinkedHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                LinkedHashMap.this.remove(this.last.key);
                this.last = null;
                ++this.knownMod;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LinkedHashEntry<K, V>
    extends HashMap.HashEntry<K, V> {
        LinkedHashEntry<K, V> pred;
        LinkedHashEntry<K, V> succ;

        LinkedHashEntry(K k, V v) {
            super(k, v);
            if (LinkedHashMap.this.root == null) {
                LinkedHashMap.this.root = this;
                this.pred = this;
            } else {
                this.pred = LinkedHashMap.this.root.pred;
                this.pred.succ = this;
                LinkedHashMap.this.root.pred = this;
            }
        }

        @Override
        void access() {
            if (LinkedHashMap.this.accessOrder && this.succ != null) {
                ++LinkedHashMap.this.modCount;
                if (this == LinkedHashMap.this.root) {
                    LinkedHashMap.this.root = this.succ;
                    this.pred.succ = this;
                    this.succ = null;
                } else {
                    this.pred.succ = this.succ;
                    this.succ.pred = this.pred;
                    this.succ = null;
                    this.pred = LinkedHashMap.this.root.pred;
                    this.pred.succ = this;
                    LinkedHashMap.this.root.pred = this;
                }
            }
        }

        @Override
        V cleanup() {
            if (this == LinkedHashMap.this.root) {
                LinkedHashMap.this.root = this.succ;
                if (this.succ != null) {
                    this.succ.pred = this.pred;
                }
            } else if (this.succ == null) {
                this.pred.succ = null;
                LinkedHashMap.this.root.pred = this.pred;
            } else {
                this.pred.succ = this.succ;
                this.succ.pred = this.pred;
            }
            return (V)this.value;
        }
    }
}

