/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable,
Cloneable {
    private static final int DEFAULT_CAPACITY = 21;
    static final Object nullslot = new Object();
    private static final long serialVersionUID = 8188218128353913216L;
    int size;
    transient Object[] table;
    transient int modCount;
    private transient Set<Map.Entry<K, V>> entries;
    private transient int threshold;

    public IdentityHashMap() {
        this(21);
    }

    public IdentityHashMap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 2) {
            n = 2;
        }
        this.table = new Object[n << 1];
        this.threshold = (n >> 2) * 3;
    }

    public IdentityHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max(map.size() << 1, 21));
        this.putAll(map);
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            ++this.modCount;
            Arrays.fill(this.table, null);
            this.size = 0;
        }
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap identityHashMap = (IdentityHashMap)super.clone();
            identityHashMap.table = (Object[])this.table.clone();
            identityHashMap.entries = null;
            return identityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return (object = this.xform(object)) == this.table[this.hash(object)];
    }

    @Override
    public boolean containsValue(Object object) {
        object = this.xform(object);
        for (int i = this.table.length - 1; i > 0; i -= 2) {
            if (this.table[i] != object) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return IdentityHashMap.this.size;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new IdentityIterator(2);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    Object object2;
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object object3 = IdentityHashMap.this.xform(entry.getValue());
                    return object3 == IdentityHashMap.this.table[IdentityHashMap.this.hash(object2 = IdentityHashMap.this.xform(entry.getKey())) + 1];
                }

                @Override
                public int hashCode() {
                    return IdentityHashMap.this.hashCode();
                }

                @Override
                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Object object2 = IdentityHashMap.this.xform(((Map.Entry)object).getKey());
                    int n = IdentityHashMap.this.hash(object2);
                    if (IdentityHashMap.this.table[n] == object2) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.removeAtIndex(n);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public V get(Object object) {
        int n = this.hash(object = this.xform(object));
        return (V)(this.table[n] == object ? this.unxform(this.table[n + 1]) : null);
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = this.table.length - 2; i >= 0; i -= 2) {
            Object object = this.table[i];
            if (object == null) continue;
            n += System.identityHashCode(this.unxform(object)) ^ System.identityHashCode(this.unxform(this.table[i + 1]));
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return IdentityHashMap.this.size;
                }

                @Override
                public Iterator<K> iterator() {
                    return new IdentityIterator(0);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return IdentityHashMap.this.containsKey(object);
                }

                @Override
                public int hashCode() {
                    int n = 0;
                    for (int i = IdentityHashMap.this.table.length - 2; i >= 0; i -= 2) {
                        Object object = IdentityHashMap.this.table[i];
                        if (object == null) continue;
                        n += System.identityHashCode(IdentityHashMap.this.unxform(object));
                    }
                    return n;
                }

                @Override
                public boolean remove(Object object) {
                    int n = IdentityHashMap.this.hash(object = IdentityHashMap.this.xform(object));
                    if (IdentityHashMap.this.table[n] == object) {
                        --IdentityHashMap.this.size;
                        ++IdentityHashMap.this.modCount;
                        IdentityHashMap.this.removeAtIndex(n);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.keys;
    }

    @Override
    public V put(K object, V object2) {
        object = this.xform(object);
        object2 = this.xform(object2);
        int n = this.hash(object);
        if (this.table[n] == object) {
            Object object3 = this.unxform(this.table[n + 1]);
            this.table[n + 1] = object2;
            return (V)object3;
        }
        if (this.size > this.threshold) {
            Object[] objectArray = this.table;
            this.table = new Object[objectArray.length * 2 + 2];
            this.size = 0;
            this.threshold = (this.table.length >>> 3) * 3;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                Object object4 = objectArray[i];
                if (object4 == null) continue;
                n = this.hash(object4);
                this.table[n] = object4;
                this.table[n + 1] = objectArray[i + 1];
                ++this.size;
            }
            n = this.hash(object);
        }
        ++this.modCount;
        ++this.size;
        this.table[n] = object;
        this.table[n + 1] = object2;
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(map);
    }

    final void removeAtIndex(int n) {
        while (true) {
            Object object;
            int n2;
            this.table[n] = null;
            this.table[n + 1] = null;
            int n3 = n;
            do {
                if ((n -= 2) < 0) {
                    n = this.table.length - 2;
                }
                if ((object = this.table[n]) != null) continue;
                return;
            } while (n <= (n2 = Math.abs(System.identityHashCode(object) % (this.table.length >> 1)) << 1) && n2 < n3 || n2 < n3 && n3 < n || n3 < n && n <= n2);
            this.table[n3] = this.table[n];
            this.table[n3 + 1] = this.table[n + 1];
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.hash(object = this.xform(object));
        if (this.table[n] == object) {
            ++this.modCount;
            --this.size;
            Object object2 = this.unxform(this.table[n + 1]);
            this.removeAtIndex(n);
            return (V)object2;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return IdentityHashMap.this.size;
                }

                @Override
                public Iterator<V> iterator() {
                    return new IdentityIterator(1);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }

                @Override
                public boolean remove(Object object) {
                    object = IdentityHashMap.this.xform(object);
                    for (int i = IdentityHashMap.this.table.length - 1; i > 0; i -= 2) {
                        if (IdentityHashMap.this.table[i] != object) continue;
                        ++IdentityHashMap.this.modCount;
                        --IdentityHashMap.this.size;
                        IdentityHashMap.this.removeAtIndex(i - 1);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.values;
    }

    final Object xform(Object object) {
        if (object == null) {
            object = nullslot;
        }
        return object;
    }

    final Object unxform(Object object) {
        if (object == nullslot) {
            object = null;
        }
        return object;
    }

    final int hash(Object object) {
        int n = Math.abs(System.identityHashCode(object) % (this.table.length >> 1)) << 1;
        while (this.table[n] != object && this.table[n] != null) {
            if ((n -= 2) >= 0) continue;
            n = this.table.length - 2;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Object[Math.max(n << 1, 21) << 1];
        while (--n >= 0) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (int i = this.table.length - 2; i >= 0; i -= 2) {
            Object object = this.table[i];
            if (object == null) continue;
            objectOutputStream.writeObject(this.unxform(object));
            objectOutputStream.writeObject(this.unxform(this.table[i + 1]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IdentityEntry<EK, EV>
    implements Map.Entry<EK, EV> {
        final int loc;
        final int knownMod;

        IdentityEntry(int n) {
            this.knownMod = IdentityHashMap.this.modCount;
            this.loc = n;
        }

        @Override
        public boolean equals(Object object) {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return IdentityHashMap.this.table[this.loc] == IdentityHashMap.this.xform(entry.getKey()) && IdentityHashMap.this.table[this.loc + 1] == IdentityHashMap.this.xform(entry.getValue());
        }

        @Override
        public EK getKey() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return (EK)IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc]);
        }

        @Override
        public EV getValue() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return (EV)IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]);
        }

        @Override
        public int hashCode() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return System.identityHashCode(IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc])) ^ System.identityHashCode(IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]));
        }

        @Override
        public EV setValue(EV EV) {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            Object object = IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]);
            IdentityHashMap.this.table[this.loc + 1] = IdentityHashMap.this.xform(EV);
            return (EV)object;
        }

        public String toString() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc]) + "=" + IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IdentityIterator<I>
    implements Iterator<I> {
        final int type;
        int knownMod;
        int count;
        int loc;

        IdentityIterator(int n) {
            this.knownMod = IdentityHashMap.this.modCount;
            this.count = IdentityHashMap.this.size;
            this.loc = IdentityHashMap.this.table.length;
            this.type = n;
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public I next() {
            Object object;
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            do {
                this.loc -= 2;
            } while ((object = IdentityHashMap.this.table[this.loc]) == null);
            return (I)(this.type == 0 ? IdentityHashMap.this.unxform(object) : (this.type == 1 ? IdentityHashMap.this.unxform(IdentityHashMap.this.table[this.loc + 1]) : new IdentityEntry(this.loc)));
        }

        @Override
        public void remove() {
            if (this.knownMod != IdentityHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.loc == IdentityHashMap.this.table.length) {
                throw new IllegalStateException();
            }
            ++IdentityHashMap.this.modCount;
            --IdentityHashMap.this.size;
            IdentityHashMap.this.removeAtIndex(this.loc);
            ++this.knownMod;
        }
    }
}

