/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.spi.CurrencyNameProvider;

public final class Currency
implements Serializable {
    static final long serialVersionUID = -158308464356906721L;
    private static transient Properties properties;
    private String currencyCode;
    private transient int fractionDigits;
    private static transient Map countryMap;
    private static transient Map cache;

    private Currency() {
    }

    private Currency(Locale locale) {
        String string = locale.getCountry();
        if (string.equals("")) {
            throw new IllegalArgumentException("Invalid (empty) country code for locale:" + locale);
        }
        String string2 = string + ".currency";
        String string3 = string + ".fractionDigits";
        this.currencyCode = properties.getProperty(string2);
        if (this.currencyCode == null) {
            return;
        }
        int n = this.currencyCode.indexOf(",");
        if (n != -1) {
            this.currencyCode = this.currencyCode.substring(0, n);
        }
        this.fractionDigits = Integer.parseInt(properties.getProperty(string3));
    }

    private Currency(String string) {
        this.currencyCode = string;
        this.fractionDigits = -1;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        return this.fractionDigits;
    }

    public static Currency getInstance(Locale locale) {
        Currency currency;
        String string = locale.getCountry();
        if (locale == null || string == null) {
            throw new NullPointerException("The locale or its country is null.");
        }
        if (string.length() != 2) {
            throw new IllegalArgumentException();
        }
        String string2 = (String)countryMap.get(string);
        if (string2 == null) {
            currency = new Currency(locale);
            string2 = currency.getCurrencyCode();
            if (string2 == null) {
                return null;
            }
            countryMap.put(string, string2);
            cache.put(string2, currency);
        } else {
            currency = (Currency)cache.get(string2);
        }
        return currency;
    }

    public static Currency getInstance(String string) {
        if (string == null) {
            throw new NullPointerException("The supplied currency code is null.");
        }
        if (string.equals("XXX")) {
            return new Currency("XXX");
        }
        Currency currency = (Currency)cache.get(string);
        if (currency == null) {
            Locale[] localeArray = Locale.getAvailableLocales();
            for (int i = 0; i < localeArray.length; ++i) {
                try {
                    Currency currency2 = Currency.getInstance(localeArray[i]);
                    if (currency2 == null || !currency2.getCurrencyCode().equals(string)) continue;
                    return currency2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("The currency code, " + string + ", is not supported.");
        }
        return currency;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String getSymbol(Locale locale) {
        String string = "currenciesSymbol." + this.currencyCode;
        try {
            return ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            block2: for (CurrencyNameProvider currencyNameProvider : ServiceLoader.load(CurrencyNameProvider.class)) {
                for (Locale locale2 : currencyNameProvider.getAvailableLocales()) {
                    if (!locale2.equals(locale)) continue;
                    String string2 = currencyNameProvider.getSymbol(this.currencyCode, locale);
                    if (string2 == null) continue block2;
                    return string2;
                }
            }
            if (locale.equals(Locale.ROOT)) {
                return this.currencyCode;
            }
            return this.getSymbol(LocaleHelper.getFallbackLocale(locale));
        }
    }

    public String toString() {
        return this.getCurrencyCode();
    }

    private Object readResolve() throws ObjectStreamException {
        return Currency.getInstance(this.currencyCode);
    }

    static {
        countryMap = new HashMap();
        cache = new HashMap();
        properties = new Properties();
        try {
            properties.load(Currency.class.getResourceAsStream("iso4217.properties"));
        }
        catch (IOException iOException) {
            throw new InternalError("Failed to load currency resource: " + iOException);
        }
    }
}

