/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    private static final int LARGE_LIST_SIZE = 16;
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    private static boolean isSequential(List<?> list2) {
        return !(list2 instanceof RandomAccess) && list2.size() > 16;
    }

    private Collections() {
    }

    public static final <T> Set<T> emptySet() {
        return new EmptySet();
    }

    public static final <T> List<T> emptyList() {
        return new EmptyList();
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return new EmptyMap();
    }

    static final <T> int compare(T t, T t2, Comparator<? super T> comparator) {
        return comparator == null ? ((Comparable)t).compareTo(t2) : comparator.compare(t, t2);
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list2, T t) {
        return Collections.binarySearch(list2, t, null);
    }

    public static <T> int binarySearch(List<? extends T> list2, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = 0;
        int n3 = list2.size() - 1;
        if (Collections.isSequential(list2)) {
            ListIterator<T> listIterator = list2.listIterator();
            int n4 = 0;
            T t2 = listIterator.next();
            boolean bl = true;
            while (n2 <= n3) {
                n = n2 + n3 >>> 1;
                if (n4 < n) {
                    if (!bl) {
                        listIterator.next();
                    }
                    while (n4 != n) {
                        ++n4;
                        t2 = listIterator.next();
                    }
                    bl = true;
                } else {
                    if (bl) {
                        listIterator.previous();
                    }
                    while (n4 != n) {
                        --n4;
                        t2 = listIterator.previous();
                    }
                    bl = false;
                }
                int n5 = Collections.compare(t2, t, comparator);
                if (n5 == 0) {
                    return n;
                }
                if (n5 > 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = ++n;
            }
        } else {
            while (n2 <= n3) {
                n = n2 + n3 >>> 1;
                int n6 = Collections.compare(list2.get(n), t, comparator);
                if (n6 == 0) {
                    return n;
                }
                if (n6 > 0) {
                    n3 = n - 1;
                    continue;
                }
                n2 = ++n;
            }
        }
        return -n - 1;
    }

    public static <T> void copy(List<? super T> list2, List<? extends T> list3) {
        int n = list3.size();
        if (list2.size() < n) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Iterator<T> iterator = list3.iterator();
        ListIterator<T> listIterator = list2.listIterator();
        while (--n >= 0) {
            listIterator.next();
            listIterator.set(iterator.next());
        }
    }

    public static <T> Enumeration<T> enumeration(Collection<T> collection) {
        final Iterator<T> iterator = collection.iterator();
        return new Enumeration<T>(){

            @Override
            public final boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public final T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> void fill(List<? super T> list2, T t) {
        ListIterator<T> listIterator = list2.listIterator();
        for (int i = list2.size() - 1; i >= 0; --i) {
            listIterator.next();
            listIterator.set(t);
        }
    }

    public static int indexOfSubList(List<?> list2, List<?> list3) {
        int n = list2.size();
        int n2 = 0;
        for (int i = list3.size(); i <= n; ++i) {
            if (list2.subList(n2, i).equals(list3)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> list2, List<?> list3) {
        int n = list2.size();
        int n2 = n - list3.size();
        int n3 = n;
        while (n2 >= 0) {
            if (list2.subList(n2, n3).equals(list3)) {
                return n2;
            }
            --n2;
            --n3;
        }
        return -1;
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static <T> T max(Collection<? extends T> collection) {
        return Collections.max(collection, null);
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            T t2 = iterator.next();
            if (Collections.compare(t, t2, comparator) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection) {
        return Collections.min(collection, null);
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        int n = collection.size();
        for (int i = 1; i < n; ++i) {
            T t2 = iterator.next();
            if (Collections.compare(t, t2, comparator) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> List<T> nCopies(int n, T t) {
        return new CopiesList<T>(n, t);
    }

    public static <T> boolean replaceAll(List<T> list2, T t, T t2) {
        ListIterator<T> listIterator = list2.listIterator();
        boolean bl = false;
        int n = list2.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(t, listIterator.next())) continue;
            listIterator.set(t2);
            bl = true;
        }
        return bl;
    }

    public static void reverse(List<?> list2) {
        int n;
        ListIterator<?> listIterator = list2.listIterator();
        int n2 = 1;
        ListIterator<?> listIterator2 = list2.listIterator(n);
        for (n = list2.size(); n2 < n; ++n2, --n) {
            Object obj = listIterator.next();
            Object obj2 = listIterator2.previous();
            listIterator.set(obj2);
            listIterator2.set(obj);
        }
    }

    public static <T> Comparator<T> reverseOrder(final Comparator<T> comparator) {
        if (comparator == null) {
            return rcInstance;
        }
        return new ReverseComparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return -comparator.compare(t, t2);
            }
        };
    }

    public static <T> Comparator<T> reverseOrder() {
        return rcInstance;
    }

    public static void rotate(List<?> list2, int n) {
        int n2 = list2.size();
        if (n2 == 0) {
            return;
        }
        if ((n %= n2) == 0) {
            return;
        }
        if (n < 0) {
            n += n2;
        }
        if (Collections.isSequential(list2)) {
            Collections.reverse(list2);
            Collections.reverse(list2.subList(0, n));
            Collections.reverse(list2.subList(n, n2));
        } else {
            int n3 = n2;
            int n4 = n;
            int n5 = n3 % n4;
            while (n5 != 0) {
                n3 = n4;
                n4 = n5;
                n5 = n3 % n4;
            }
            List<?> list3 = list2;
            while (--n4 >= 0) {
                Object obj = list3.get(n4);
                int n6 = n4 + n;
                while (n6 != n4) {
                    obj = list3.set(n6, obj);
                    n6 = (n6 + n) % n2;
                }
                list3.set(n4, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void shuffle(List<?> list2) {
        if (defaultRandom == null) {
            Class<Collections> clazz = Collections.class;
            // MONITORENTER : java.util.Collections.class
            if (defaultRandom == null) {
                defaultRandom = new Random();
            }
            // MONITOREXIT : clazz
        }
        Collections.shuffle(list2, defaultRandom);
    }

    public static void shuffle(List<?> list2, Random random) {
        int n = list2.size();
        List<?> list3 = list2;
        ListIterator<?> listIterator = list3.listIterator(n);
        boolean bl = Collections.isSequential(list2);
        Object[] objectArray = null;
        if (bl) {
            objectArray = list3.toArray();
        }
        for (int i = n - 1; i > 0; --i) {
            Object object;
            int n2 = random.nextInt(i + 1);
            if (bl) {
                object = objectArray[n2];
                objectArray[n2] = listIterator.previous();
            } else {
                object = list3.set(n2, listIterator.previous());
            }
            listIterator.set(object);
        }
    }

    public static int frequency(Collection<?> collection, Object object) {
        int n = 0;
        for (Object obj : collection) {
            if (!AbstractCollection.equals(object, obj)) continue;
            ++n;
        }
        return n;
    }

    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        boolean bl = false;
        for (T t : TArray) {
            boolean bl2 = collection.add(t);
            if (!bl2) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean disjoint(Collection<?> collection, Collection<?> collection2) {
        Collection<?> collection3 = collection;
        Iterator<?> iterator = collection3.iterator();
        while (iterator.hasNext()) {
            if (!collection2.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> Set<T> singleton(T t) {
        return new SingletonSet<T>(t);
    }

    public static <T> List<T> singletonList(T t) {
        return new SingletonList<T>(t);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return new SingletonMap<K, V>(k, v);
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list2) {
        Collections.sort(list2, null);
    }

    public static <T> void sort(List<T> list2, Comparator<? super T> comparator) {
        Object[] objectArray = list2.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator<T> listIterator = list2.listIterator();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            listIterator.next();
            listIterator.set(objectArray[i]);
        }
    }

    public static void swap(List<?> list2, int n, int n2) {
        List<?> list3 = list2;
        list3.set(n, list3.set(n2, list3.get(n)));
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        return new SynchronizedCollection<T>(collection);
    }

    public static <T> List<T> synchronizedList(List<T> list2) {
        if (list2 instanceof RandomAccess) {
            return new SynchronizedRandomAccessList<T>(list2);
        }
        return new SynchronizedList<T>(list2);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        return new SynchronizedMap<K, V>(map);
    }

    public static <T> Set<T> synchronizedSet(Set<T> set) {
        return new SynchronizedSet<T>(set);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> sortedMap) {
        return new SynchronizedSortedMap<K, V>(sortedMap);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> sortedSet) {
        return new SynchronizedSortedSet<T>(sortedSet);
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        return new UnmodifiableCollection<T>(collection);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list2) {
        if (list2 instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList<T>(list2);
        }
        return new UnmodifiableList<T>(list2);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        return new UnmodifiableMap<K, V>(map);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        return new UnmodifiableSet<T>(set);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        return new UnmodifiableSortedMap<K, V>(sortedMap);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> sortedSet) {
        return new UnmodifiableSortedSet<T>(sortedSet);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> collection, Class<E> clazz) {
        return new CheckedCollection<E>(collection, clazz);
    }

    public static <E> List<E> checkedList(List<E> list2, Class<E> clazz) {
        if (list2 instanceof RandomAccess) {
            return new CheckedRandomAccessList<E>(list2, clazz);
        }
        return new CheckedList<E>(list2, clazz);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        return new CheckedMap<K, V>(map, clazz, clazz2);
    }

    public static <E> Set<E> checkedSet(Set<E> set, Class<E> clazz) {
        return new CheckedSet<E>(set, clazz);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
        return new CheckedSortedMap<K, V>(sortedMap, clazz, clazz2);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
        return new CheckedSortedSet<E>(sortedSet, clazz);
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new LIFOQueue<T>(deque);
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new MapSet<E>(map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapSet<E>
    extends AbstractSet<E> {
        private Map<E, Boolean> map;

        public MapSet(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("The map must be empty.");
            }
            this.map = map;
        }

        @Override
        public boolean add(E e) {
            return this.map.put(e, true) == null;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            boolean bl = false;
            Iterator<E> iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.map.put(iterator.next(), true) == null;
            }
            return bl;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LIFOQueue<T>
    extends AbstractQueue<T> {
        private Deque<T> deque;

        public LIFOQueue(Deque<T> deque) {
            this.deque = deque;
        }

        @Override
        public boolean add(T t) {
            return this.deque.offerFirst(t);
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            boolean bl = false;
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                bl |= this.deque.offerFirst(iterator.next());
            }
            return bl;
        }

        @Override
        public void clear() {
            this.deque.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.deque.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.deque.iterator();
        }

        @Override
        public boolean offer(T t) {
            return this.deque.offerFirst(t);
        }

        @Override
        public T peek() {
            return this.deque.peek();
        }

        @Override
        public T poll() {
            return this.deque.poll();
        }

        @Override
        public int size() {
            return this.deque.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 1599911165492914959L;
        private SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
            super(sortedSet, clazz);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return new CheckedSortedSet<E>(this.ss.headSet(e), this.type);
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E e, E e2) {
            return new CheckedSortedSet<E>(this.ss.subSet(e, e2), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return new CheckedSortedSet<E>(this.ss.tailSet(e), this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
            super(sortedMap, clazz, clazz2);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new CheckedSortedMap<K, V>(this.sm.headMap(k), this.keyType, this.valueType);
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new CheckedSortedMap<K, V>(this.sm.subMap(k, k2), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new CheckedSortedMap<K, V>(this.sm.tailMap(k), this.keyType, this.valueType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> set, Class<E> clazz) {
            super(set, clazz);
        }

        @Override
        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entries;
        private transient Set<K> keys;
        private transient Collection<V> values;

        CheckedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
            this.m = map;
            this.keyType = clazz;
            this.valueType = clazz2;
            if (map == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                Class<Map.Entry> clazz = Map.Entry.class;
                this.entries = new CheckedEntrySet<Map.Entry, K, V>(this.m.entrySet(), clazz, this.keyType, this.valueType);
            }
            return this.entries;
        }

        @Override
        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            if (this.keyType.isInstance(k)) {
                if (this.valueType.isInstance(v)) {
                    return this.m.put(k, v);
                }
                throw new ClassCastException("The value is of the wrong type.");
            }
            throw new ClassCastException("The key is of the wrong type.");
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = new CheckedSet<K>(this.m.keySet(), this.keyType);
            }
            return this.keys;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Map<K, V> map2 = map;
            for (Map.Entry<K, V> entry : map2.entrySet()) {
                if (!this.keyType.isInstance(entry.getKey())) {
                    throw new ClassCastException("A key is of the wrong type.");
                }
                if (this.valueType.isInstance(entry.getValue())) continue;
                throw new ClassCastException("A value is of the wrong type.");
            }
            this.m.putAll(map2);
        }

        @Override
        public V remove(Object object) {
            return this.m.remove(object);
        }

        @Override
        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new CheckedCollection<V>(this.m.values(), this.valueType);
            }
            return this.values;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class CheckedEntrySet<E, SK, SV>
        extends CheckedSet<E> {
            private final Class<SK> keyType;
            private final Class<SV> valueType;

            CheckedEntrySet(Set<E> set, Class<E> clazz, Class<SK> clazz2, Class<SV> clazz3) {
                super(set, clazz);
                this.keyType = clazz2;
                this.valueType = clazz3;
            }

            @Override
            public Iterator<E> iterator() {
                return new CheckedIterator<E>(this.c.iterator(), this.type){

                    @Override
                    public E next() {
                        final Map.Entry entry = (Map.Entry)super.next();
                        return new Map.Entry(){

                            public boolean equals(Object object) {
                                return entry.equals(object);
                            }

                            public Object getKey() {
                                return entry.getKey();
                            }

                            public Object getValue() {
                                return entry.getValue();
                            }

                            public int hashCode() {
                                return entry.hashCode();
                            }

                            public Object setValue(Object object) {
                                if (CheckedEntrySet.this.valueType.isInstance(object)) {
                                    return entry.setValue(object);
                                }
                                throw new ClassCastException("The value is of the wrong type.");
                            }

                            public String toString() {
                                return entry.toString();
                            }
                        };
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckedListIterator<E>
    extends CheckedIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> li;

        CheckedListIterator(ListIterator<E> listIterator, Class<E> clazz) {
            super(listIterator, clazz);
            this.li = listIterator;
        }

        @Override
        public void add(E e) {
            if (!this.type.isInstance(e)) {
                throw new ClassCastException("The object is of the wrong type.");
            }
            this.li.add(e);
        }

        @Override
        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.li.nextIndex();
        }

        @Override
        public E previous() {
            return this.li.previous();
        }

        @Override
        public int previousIndex() {
            return this.li.previousIndex();
        }

        @Override
        public void set(E e) {
            if (!this.type.isInstance(e)) {
                throw new ClassCastException("The object is of the wrong type.");
            }
            this.li.set(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> list2, Class<E> clazz) {
            super(list2, clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> list2, Class<E> clazz) {
            super(list2, clazz);
            this.list = list2;
        }

        @Override
        public void add(int n, E e) {
            if (!this.type.isInstance(e)) {
                throw new ClassCastException("The object is of the wrong type.");
            }
            this.list.add(n, e);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            Collection<E> collection2 = collection;
            Iterator<E> iterator = collection2.iterator();
            while (iterator.hasNext()) {
                if (this.type.isInstance(iterator.next())) continue;
                throw new ClassCastException("A member of the collection is not of the correct type.");
            }
            return this.list.addAll(n, collection);
        }

        @Override
        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        @Override
        public E get(int n) {
            return this.list.get(n);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new CheckedListIterator<E>(this.list.listIterator(), this.type);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            return new CheckedListIterator<E>(this.list.listIterator(n), this.type);
        }

        @Override
        public E remove(int n) {
            return this.list.remove(n);
        }

        @Override
        public E set(int n, E e) {
            return this.list.set(n, e);
        }

        @Override
        public List<E> subList(int n, int n2) {
            return Collections.checkedList(this.list.subList(n, n2), this.type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedIterator<E>
    implements Iterator<E> {
        private final Iterator<E> i;
        final Class<E> type;

        CheckedIterator(Iterator<E> iterator, Class<E> clazz) {
            this.i = iterator;
            this.type = clazz;
        }

        @Override
        public E next() {
            return this.i.next();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;

        CheckedCollection(Collection<E> collection, Class<E> clazz) {
            this.c = collection;
            this.type = clazz;
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean add(E e) {
            if (this.type.isInstance(e)) {
                return this.c.add(e);
            }
            throw new ClassCastException("The element is of the incorrect type.");
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            Collection<E> collection2 = this.c;
            for (E e : collection2) {
                if (this.type.isInstance(e)) continue;
                throw new ClassCastException("A member of the collection is not of the correct type.");
            }
            return this.c.addAll(collection2);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new CheckedIterator<E>(this.c.iterator(), this.type);
        }

        @Override
        public boolean remove(Object object) {
            return this.c.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.c.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.c.retainAll(collection);
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <S> S[] toArray(S[] SArray) {
            return this.c.toArray(SArray);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSortedSet<T>
    extends UnmodifiableSet<T>
    implements SortedSet<T> {
        private static final long serialVersionUID = -4929149591599911165L;
        private SortedSet<T> ss;

        UnmodifiableSortedSet(SortedSet<T> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        @Override
        public Comparator<? super T> comparator() {
            return this.ss.comparator();
        }

        @Override
        public T first() {
            return this.ss.first();
        }

        @Override
        public SortedSet<T> headSet(T t) {
            return new UnmodifiableSortedSet<T>(this.ss.headSet(t));
        }

        @Override
        public T last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<T> subSet(T t, T t2) {
            return new UnmodifiableSortedSet<T>(this.ss.subSet(t, t2));
        }

        @Override
        public SortedSet<T> tailSet(T t) {
            return new UnmodifiableSortedSet<T>(this.ss.tailSet(t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(k));
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(k, k2));
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(k));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableSet<T>
    extends UnmodifiableCollection<T>
    implements Set<T> {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends T> set) {
            super(set);
        }

        @Override
        public boolean equals(Object object) {
            return this.c.equals(object);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<K, V> m;
        private transient Set<Map.Entry<K, V>> entries;
        private transient Set<K> keys;
        private transient Collection<V> values;

        UnmodifiableMap(Map<? extends K, ? extends V> map) {
            this.m = map;
            if (map == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.m.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                this.entries = new UnmodifiableEntrySet<K, V>(this.m.entrySet());
            }
            return this.entries;
        }

        @Override
        public boolean equals(Object object) {
            return this.m.equals(object);
        }

        @Override
        public V get(Object object) {
            return this.m.get(object);
        }

        @Override
        public V put(K k, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = new UnmodifiableSet<K>(this.m.keySet());
            }
            return this.keys;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection<V>(this.m.values());
            }
            return this.values;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>>
        implements Serializable {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<Map.Entry<K, V>> set) {
                super(set);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new UnmodifiableIterator<Map.Entry<K, V>>(this.c.iterator()){

                    @Override
                    public Map.Entry<K, V> next() {
                        Map.Entry entry = (Map.Entry)super.next();
                        return new UnmodifiableMapEntry(entry);
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = super.toArray();
                UnmodifiableMapEntry[] unmodifiableMapEntryArray = null;
                if (objectArray != null) {
                    unmodifiableMapEntryArray = new UnmodifiableMapEntry[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        unmodifiableMapEntryArray[i] = new UnmodifiableMapEntry((Map.Entry)objectArray[i]);
                    }
                }
                return unmodifiableMapEntryArray;
            }

            @Override
            public <S> S[] toArray(S[] SArray) {
                S[] SArray2 = super.toArray(SArray);
                if (SArray2 != null) {
                    for (int i = 0; i < SArray2.length; ++i) {
                        SArray[i] = new UnmodifiableMapEntry((Map.Entry)SArray2[i]);
                    }
                }
                return SArray;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static final class UnmodifiableMapEntry<K, V>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;

                private UnmodifiableMapEntry(Map.Entry<K, V> entry) {
                    this.e = entry;
                }

                @Override
                public boolean equals(Object object) {
                    return this.e.equals(object);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                @Override
                public V setValue(V v) {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return this.e.toString();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableListIterator<T>
    extends UnmodifiableIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> li;

        UnmodifiableListIterator(ListIterator<T> listIterator) {
            super(listIterator);
            this.li = listIterator;
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.li.nextIndex();
        }

        @Override
        public T previous() {
            return this.li.previous();
        }

        @Override
        public int previousIndex() {
            return this.li.previousIndex();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnmodifiableRandomAccessList<T>
    extends UnmodifiableList<T>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends T> list2) {
            super(list2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableList<T>
    extends UnmodifiableCollection<T>
    implements List<T> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<T> list;

        UnmodifiableList(List<? extends T> list2) {
            super(list2);
            this.list = list2;
        }

        @Override
        public void add(int n, T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int n, Collection<? extends T> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            return this.list.equals(object);
        }

        @Override
        public T get(int n) {
            return this.list.get(n);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public ListIterator<T> listIterator() {
            return new UnmodifiableListIterator<T>(this.list.listIterator());
        }

        @Override
        public ListIterator<T> listIterator(int n) {
            return new UnmodifiableListIterator<T>(this.list.listIterator(n));
        }

        @Override
        public T remove(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int n, T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<T> subList(int n, int n2) {
            return Collections.unmodifiableList(this.list.subList(n, n2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> i;

        UnmodifiableIterator(Iterator<? extends T> iterator) {
            this.i = iterator;
        }

        @Override
        public T next() {
            return this.i.next();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableCollection<T>
    implements Collection<T>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends T> c;

        UnmodifiableCollection(Collection<? extends T> collection) {
            this.c = collection;
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object object) {
            return this.c.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.c.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return new UnmodifiableIterator<T>(this.c.iterator());
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <S> S[] toArray(S[] SArray) {
            return this.c.toArray(SArray);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedSortedSet<T>
    extends SynchronizedSet<T>
    implements SortedSet<T> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<T> ss;

        SynchronizedSortedSet(SortedSet<T> sortedSet) {
            super(sortedSet);
            this.ss = sortedSet;
        }

        SynchronizedSortedSet(Object object, SortedSet<T> sortedSet) {
            super(object, sortedSet);
            this.ss = sortedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super T> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<T> headSet(T t) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<T>(this.mutex, this.ss.headSet(t));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<T> subSet(T t, T t2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<T>(this.mutex, this.ss.subSet(t, t2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<T> tailSet(T t) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<T>(this.mutex, this.ss.tailSet(t));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> sortedMap) {
            super(sortedMap);
            this.sm = sortedMap;
        }

        SynchronizedSortedMap(Object object, SortedMap<K, V> sortedMap) {
            super(object, sortedMap);
            this.sm = sortedMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.mutex, this.sm.headMap(k));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.mutex, this.sm.subMap(k, k2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K k) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.mutex, this.sm.tailMap(k));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedSet<T>
    extends SynchronizedCollection<T>
    implements Set<T> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<T> set) {
            super(set);
        }

        SynchronizedSet(Object object, Set<T> set) {
            super(object, set);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<Map.Entry<K, V>> entries;
        private transient Set<K> keys;
        private transient Collection<V> values;

        SynchronizedMap(Map<K, V> map) {
            this.m = map;
            this.mutex = this;
            if (map == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedMap(Object object, Map<K, V> map) {
            this.m = map;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.containsValue(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.entries = new SynchronizedSet<Map.Entry<K, V>>(this.mutex, this.m.entrySet()){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Iterator<Map.Entry<K, V>> iterator() {
                            Object object = this.mutex;
                            synchronized (object) {
                                return new SynchronizedIterator<Map.Entry<K, V>>(this.mutex, this.c.iterator()){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Map.Entry<K, V> next() {
                                        Object object = this.mutex;
                                        synchronized (object) {
                                            /*
                                             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                                             */
                                            class SynchronizedMapEntry<K, V>
                                            implements Map.Entry<K, V> {
                                                final Map.Entry<K, V> e;

                                                SynchronizedMapEntry(Map.Entry<K, V> entry) {
                                                    this.e = entry;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public boolean equals(Object object) {
                                                    Object object2 = SynchronizedMap.this.mutex;
                                                    synchronized (object2) {
                                                        return this.e.equals(object);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public K getKey() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.getKey();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public V getValue() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.getValue();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public int hashCode() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.hashCode();
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                @Override
                                                public V setValue(V v) {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.setValue(v);
                                                    }
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public String toString() {
                                                    Object object = SynchronizedMap.this.mutex;
                                                    synchronized (object) {
                                                        return this.e.toString();
                                                    }
                                                }
                                            }
                                            return new SynchronizedMapEntry((Map.Entry)super.next());
                                        }
                                    }
                                };
                            }
                        }
                    };
                }
            }
            return this.entries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.keys = new SynchronizedSet<K>(this.mutex, this.m.keySet());
                }
            }
            return this.keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K k, V v) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(k, v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.m.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            if (this.values == null) {
                Object object = this.mutex;
                synchronized (object) {
                    this.values = new SynchronizedCollection<V>(this.mutex, this.m.values());
                }
            }
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedListIterator<T>
    extends SynchronizedIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> li;

        SynchronizedListIterator(Object object, ListIterator<T> listIterator) {
            super(object, listIterator);
            this.li = listIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(T t) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.hasPrevious();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int nextIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.nextIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T previous() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previous();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int previousIndex() {
            Object object = this.mutex;
            synchronized (object) {
                return this.li.previousIndex();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T t) {
            Object object = this.mutex;
            synchronized (object) {
                this.li.set(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SynchronizedRandomAccessList<T>
    extends SynchronizedList<T>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<T> list2) {
            super(list2);
        }

        SynchronizedRandomAccessList(Object object, List<T> list2) {
            super(object, list2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<T> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.mutex, this.list.subList(n, n2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedList<T>
    extends SynchronizedCollection<T>
    implements List<T> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<T> list;

        SynchronizedList(List<T> list2) {
            super(list2);
            this.list = list2;
        }

        SynchronizedList(Object object, List<T> list2) {
            super(object, list2);
            this.list = list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, T t) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(n, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends T> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(n, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.equals(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.list.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<T> listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator<T>(this.mutex, this.list.listIterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<T> listIterator(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedListIterator<T>(this.mutex, this.list.listIterator(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T set(int n, T t) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(n, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<T> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<T>(this.mutex, this.list.subList(n, n2));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedIterator<T>
    implements Iterator<T> {
        final Object mutex;
        private final Iterator<T> i;

        SynchronizedIterator(Object object, Iterator<T> iterator) {
            this.i = iterator;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                return this.i.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                this.i.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedCollection<T>
    implements Collection<T>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<T> c;
        final Object mutex;

        SynchronizedCollection(Collection<T> collection) {
            this.c = collection;
            this.mutex = this;
            if (collection == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedCollection(Object object, Collection<T> collection) {
            this.c = collection;
            this.mutex = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(T t) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<T> iterator() {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedIterator<T>(this.mutex, this.c.iterator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.c.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final K k;
        private final V v;
        private transient Set<Map.Entry<K, V>> entries;

        SingletonMap(K k, V v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entries == null) {
                AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry<K, V>(this.k, this.v){

                    @Override
                    public V setValue(V v) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.entries = Collections.singleton(simpleEntry);
            }
            return this.entries;
        }

        @Override
        public boolean containsKey(Object object) {
            return SingletonMap.equals(object, this.k);
        }

        @Override
        public boolean containsValue(Object object) {
            return SingletonMap.equals(object, this.v);
        }

        @Override
        public V get(Object object) {
            return SingletonMap.equals(object, this.k) ? (V)this.v : null;
        }

        @Override
        public int hashCode() {
            return SingletonMap.hashCode(this.k) ^ SingletonMap.hashCode(this.v);
        }

        @Override
        public Set<K> keySet() {
            if (this.keys == null) {
                this.keys = Collections.singleton(this.k);
            }
            return this.keys;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        @Override
        public String toString() {
            return "{" + this.k + "=" + this.v + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 3093736618740652951L;
        private final T element;

        SingletonList(T t) {
            this.element = t;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public T get(int n) {
            if (n == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean contains(Object object) {
            return SingletonList.equals(object, this.element);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Iterator<?> iterator = collection.iterator();
            int n = collection.size();
            while (--n >= 0) {
                if (SingletonList.equals(iterator.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return 31 + SingletonList.hashCode(this.element);
        }

        @Override
        public int indexOf(Object object) {
            return SingletonList.equals(object, this.element) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return SingletonList.equals(object, this.element) ? 0 : -1;
        }

        @Override
        public List<T> subList(int n, int n2) {
            if (n == n2 && (n2 == 0 || n2 == 1)) {
                return EMPTY_LIST;
            }
            if (n == 0 && n2 == 1) {
                return this;
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public String toString() {
            return "[" + this.element + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonSet<T>
    extends AbstractSet<T>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final T element;

        SingletonSet(T t) {
            this.element = t;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private boolean hasNext = true;

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public T next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return SingletonSet.this.element;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return SingletonSet.equals(object, this.element);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Iterator<?> iterator = collection.iterator();
            int n = collection.size();
            while (--n >= 0) {
                if (SingletonSet.equals(iterator.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return SingletonSet.hashCode(this.element);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public String toString() {
            return "[" + this.element + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        ReverseComparator() {
        }

        @Override
        public int compare(T t, T t2) {
            return ((Comparable)t2).compareTo(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CopiesList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final T element;

        CopiesList(int n, T t) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = t;
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public T get(int n) {
            if (n < 0 || n >= this.n) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }

        @Override
        public boolean contains(Object object) {
            return this.n > 0 && CopiesList.equals(object, this.element);
        }

        @Override
        public int indexOf(Object object) {
            return this.n > 0 && CopiesList.equals(object, this.element) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return CopiesList.equals(object, this.element) ? this.n - 1 : -1;
        }

        @Override
        public List<T> subList(int n, int n2) {
            if (n < 0 || n2 > this.n) {
                throw new IndexOutOfBoundsException();
            }
            return new CopiesList<T>(n2 - n, this.element);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.n];
            Arrays.fill(objectArray, this.element);
            return objectArray;
        }

        @Override
        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder("{");
            int n = this.n - 1;
            while (--n > 0) {
                cPStringBuilder.append(this.element).append(", ");
            }
            cPStringBuilder.append(this.element).append("}");
            return cPStringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        EmptyMap() {
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return EMPTY_SET;
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).isEmpty();
        }

        @Override
        public V get(Object object) {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Set<K> keySet() {
            return EMPTY_SET;
        }

        @Override
        public V remove(Object object) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<V> values() {
            return EMPTY_SET;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyList<T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 8842843931221139166L;

        EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T get(int n) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof List && ((List)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public int indexOf(Object object) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return -1;
        }

        @Override
        public boolean remove(Object object) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return false;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            if (EArray.length > 0) {
                EArray[0] = null;
            }
            return EArray;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptySet<T>
    extends AbstractSet<T>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        EmptySet() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<T> iterator() {
            return EMPTY_LIST.iterator();
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Set && ((Set)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean remove(Object object) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return false;
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <E> E[] toArray(E[] EArray) {
            if (EArray.length > 0) {
                EArray[0] = null;
            }
            return EArray;
        }

        @Override
        public String toString() {
            return "[]";
        }
    }
}

