/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Calendar
implements Serializable,
Cloneable,
Comparable<Calendar> {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int ALL_STYLES = 0;
    public static final int SHORT = 1;
    public static final int LONG = 2;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    private TimeZone zone;
    private static final String calendarClassName = "java.util.GregorianCalendar";
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private boolean explicitDSTOffset = false;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -1807547505821590642L;
    private static final String bundleName = "gnu.java.locale.LocaleInformation";
    private static final transient Properties properties = new Properties();
    private static final HashMap<Locale, Class> cache;
    private static Class[] ctorArgTypes;
    private static final String[] fieldNames;

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale, ClassLoader.getSystemClassLoader());
    }

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        String string;
        this.zone = timeZone;
        this.lenient = true;
        String[] stringArray = new String[]{"", "sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        String string2 = locale.getCountry();
        String string3 = properties.getProperty("minDays." + string2);
        if (string3 == null) {
            string3 = properties.getProperty("minDays.DEFAULT");
        }
        if ((string = properties.getProperty("firstDay." + string2)) == null) {
            string = properties.getProperty("firstDay.DEFAULT");
        }
        try {
            if (string3 != null) {
                this.minimalDaysInFirstWeek = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.minimalDaysInFirstWeek = 1;
        }
        this.firstDayOfWeek = 1;
        if (string != null) {
            for (int i = 0; i < 8; ++i) {
                if (!stringArray[i].equals(string)) continue;
                this.firstDayOfWeek = i;
            }
        }
        this.clear();
    }

    public static synchronized Calendar getInstance() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        return Calendar.getInstance(timeZone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return Calendar.getInstance(TimeZone.getDefault(), locale);
    }

    public static synchronized Calendar getInstance(TimeZone timeZone, Locale locale) {
        Class<?> clazz = cache.get(locale);
        Exception exception = null;
        try {
            if (clazz == null && Calendar.class.isAssignableFrom(clazz = Class.forName(calendarClassName))) {
                cache.put(locale, clazz);
            }
            if (clazz == GregorianCalendar.class) {
                return new GregorianCalendar(timeZone, locale);
            }
            if (Calendar.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(ctorArgTypes);
                return (Calendar)constructor.newInstance(timeZone, locale);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        throw new RuntimeException("Error instantiating calendar for locale " + locale, exception);
    }

    public static synchronized Locale[] getAvailableLocales() {
        ResourceBundle resourceBundle = Calendar.getBundle(new Locale("", ""));
        return (Locale[])resourceBundle.getObject("availableLocales");
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return new Date(this.time);
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public void setTimeInMillis(long l) {
        this.clear();
        this.time = l;
        this.isTimeSet = true;
        this.computeFields();
    }

    public int get(int n) {
        if (!this.isSet[n]) {
            this.areFieldsSet = false;
        }
        this.complete();
        return this.fields[n];
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    public void set(int n, int n2) {
        if (this.isTimeSet) {
            for (int i = 0; i < 17; ++i) {
                this.isSet[i] = false;
            }
        }
        this.isTimeSet = false;
        this.fields[n] = n2;
        this.isSet[n] = true;
        switch (n) {
            case 2: {
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 5: {
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[4] = true;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 4: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[7] = true;
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 8: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[7] = true;
                this.isSet[6] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[3] = false;
                break;
            }
            case 6: {
                this.isSet[1] = true;
                this.isSet[2] = false;
                this.isSet[4] = false;
                this.isSet[5] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.isSet[8] = false;
                break;
            }
            case 3: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[7] = true;
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[8] = false;
                break;
            }
            case 9: {
                this.isSet[10] = true;
                this.isSet[11] = false;
                break;
            }
            case 11: {
                this.isSet[9] = false;
                this.isSet[10] = false;
                break;
            }
            case 10: {
                this.isSet[9] = true;
                this.isSet[11] = false;
                break;
            }
            case 16: {
                this.explicitDSTOffset = true;
            }
        }
        if (!this.explicitDSTOffset && n != 16 && n != 15) {
            this.isSet[16] = false;
        }
    }

    public final void set(int n, int n2, int n3) {
        this.isTimeSet = false;
        this.fields[1] = n;
        this.fields[2] = n2;
        this.fields[5] = n3;
        this.isSet[5] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[3] = false;
        this.isSet[6] = false;
        this.isSet[4] = false;
        this.isSet[7] = false;
        this.isSet[8] = false;
        this.isSet[0] = false;
        if (!this.explicitDSTOffset) {
            this.isSet[16] = false;
        }
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(n, n2, n3);
        this.fields[11] = n4;
        this.fields[12] = n5;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[9] = false;
        this.isSet[10] = false;
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(n, n2, n3, n4, n5);
        this.fields[13] = n6;
        this.isSet[13] = true;
    }

    public final void clear() {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        int n = this.zone.getRawOffset();
        int[] nArray = new int[]{1, 1970, 0, 1, 1, 1, 1, 5, 1, 0, 0, 0, 0, 0, 0, n, 0};
        this.fields = nArray;
        for (int i = 0; i < 17; ++i) {
            this.isSet[i] = false;
        }
    }

    public final void clear(int n) {
        int[] nArray = new int[]{1, 1970, 0, 1, 1, 1, 1, 5, 1, 0, 0, 0, 0, 0, 0, this.zone.getRawOffset(), 0};
        this.complete();
        this.isTimeSet = false;
        this.areFieldsSet = false;
        this.isSet[n] = false;
        this.fields[n] = nArray[n];
    }

    public final boolean isSet(int n) {
        return this.isSet[n];
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        if (this.getTimeInMillis() == ((Calendar)object).getTimeInMillis() && calendar.getFirstDayOfWeek() == this.getFirstDayOfWeek() && calendar.isLenient() == this.isLenient() && calendar.getMinimalDaysInFirstWeek() == this.getMinimalDaysInFirstWeek()) {
            TimeZone timeZone = this.getTimeZone();
            TimeZone timeZone2 = calendar.getTimeZone();
            return timeZone == null ? timeZone2 == null : timeZone.equals(timeZone2);
        }
        return false;
    }

    public int hashCode() {
        long l = this.getTimeInMillis();
        int n = (int)(l & 0xFFFFFFFFL ^ l >> 32);
        n += this.getFirstDayOfWeek() + (this.isLenient() ? 1230 : 1237) + this.getMinimalDaysInFirstWeek();
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            n ^= timeZone.hashCode();
        }
        return n;
    }

    public boolean before(Object object) {
        return this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean after(Object object) {
        return this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int n, int n2) {
        while (n2 > 0) {
            this.roll(n, true);
            --n2;
        }
        while (n2 < 0) {
            this.roll(n, false);
            ++n2;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
        this.computeTime();
        this.computeFields();
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        this.minimalDaysInFirstWeek = n;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int n) {
        int n2;
        Calendar calendar = (Calendar)this.clone();
        int n3 = calendar.getMinimum(n);
        calendar.set(n, n2);
        for (n2 = calendar.getGreatestMinimum(n); n2 > n3; --n2) {
            calendar.add(n, -1);
            if (calendar.get(n) != n2 - 1) break;
        }
        return n2;
    }

    public int getActualMaximum(int n) {
        int n2;
        Calendar calendar = (Calendar)this.clone();
        int n3 = calendar.getMaximum(n);
        calendar.set(n, n2);
        for (n2 = calendar.getLeastMaximum(n); n2 < n3; ++n2) {
            calendar.add(n, 1);
            if (calendar.get(n) != n2 + 1) break;
        }
        return n2;
    }

    @Override
    public int compareTo(Calendar calendar) {
        long l;
        long l2 = this.getTimeInMillis();
        if (l2 == (l = calendar.getTimeInMillis())) {
            return 0;
        }
        if (l2 > l) {
            return 1;
        }
        return -1;
    }

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = (int[])this.fields.clone();
            calendar.isSet = (boolean[])this.isSet.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this.getClass().getName());
        cPStringBuilder.append('[');
        cPStringBuilder.append("time=");
        if (this.isTimeSet) {
            cPStringBuilder.append(this.time);
        } else {
            cPStringBuilder.append("?");
        }
        cPStringBuilder.append(",zone=" + this.zone);
        cPStringBuilder.append(",areFieldsSet=" + this.areFieldsSet);
        for (int i = 0; i < 17; ++i) {
            cPStringBuilder.append(fieldNames[i]);
            if (this.isSet[i]) {
                cPStringBuilder.append(this.fields[i]);
                continue;
            }
            cPStringBuilder.append("?");
        }
        cPStringBuilder.append(",lenient=").append(this.lenient);
        cPStringBuilder.append(",firstDayOfWeek=").append(this.firstDayOfWeek);
        cPStringBuilder.append(",minimalDaysInFirstWeek=").append(this.minimalDaysInFirstWeek);
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (this.serialVersionOnStream > 1) {
            this.fields = new int[17];
            this.isSet = new boolean[17];
            this.areFieldsSet = false;
        }
    }

    public String getDisplayName(int n, int n2, Locale locale) {
        if (n < 0 || n >= 17) {
            throw new IllegalArgumentException("The field value, " + n + ", is invalid.");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("The style must be either short or long.");
        }
        if (n == 1 || n == 3 || n == 4 || n == 5 || n == 6 || n == 8 || n == 10 || n == 11 || n == 12 || n == 13 || n == 14) {
            return null;
        }
        int n3 = this.get(n);
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        if (n == 0) {
            return dateFormatSymbols.getEras()[n3];
        }
        if (n == 2) {
            if (n2 == 2) {
                return dateFormatSymbols.getMonths()[n3];
            }
            return dateFormatSymbols.getShortMonths()[n3];
        }
        if (n == 7) {
            if (n2 == 2) {
                return dateFormatSymbols.getWeekdays()[n3];
            }
            return dateFormatSymbols.getShortWeekdays()[n3];
        }
        if (n == 9) {
            return dateFormatSymbols.getAmPmStrings()[n3];
        }
        if (n == 15) {
            if (n2 == 2) {
                return dateFormatSymbols.getZoneStrings()[n3][1];
            }
            return dateFormatSymbols.getZoneStrings()[n3][2];
        }
        if (n == 16) {
            if (n2 == 2) {
                return dateFormatSymbols.getZoneStrings()[n3][3];
            }
            return dateFormatSymbols.getZoneStrings()[n3][4];
        }
        throw new InternalError("Failed to resolve field " + n + " with style " + n2 + " for locale " + locale);
    }

    public Map<String, Integer> getDisplayNames(int n, int n2, Locale locale) {
        if (n < 0 || n >= 17) {
            throw new IllegalArgumentException("The field value, " + n + ", is invalid.");
        }
        if (n2 != 1 && n2 != 2 && n2 != 0) {
            throw new IllegalArgumentException("The style must be either short, long or all styles.");
        }
        if (n == 1 || n == 3 || n == 4 || n == 5 || n == 6 || n == 8 || n == 10 || n == 11 || n == 12 || n == 13 || n == 14) {
            return null;
        }
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (n == 0) {
            String[] stringArray = dateFormatSymbols.getEras();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], i);
            }
            return hashMap;
        }
        if (n == 2) {
            int n3;
            String[] stringArray;
            if (n2 == 2 || n2 == 0) {
                stringArray = dateFormatSymbols.getMonths();
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    hashMap.put(stringArray[n3], n3);
                }
            }
            if (n2 == 1 || n2 == 0) {
                stringArray = dateFormatSymbols.getShortMonths();
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    hashMap.put(stringArray[n3], n3);
                }
            }
            return hashMap;
        }
        if (n == 7) {
            int n4;
            String[] stringArray;
            if (n2 == 2 || n2 == 0) {
                stringArray = dateFormatSymbols.getWeekdays();
                for (n4 = 1; n4 < stringArray.length; ++n4) {
                    hashMap.put(stringArray[n4], n4);
                }
            }
            if (n2 == 1 || n2 == 0) {
                stringArray = dateFormatSymbols.getShortWeekdays();
                for (n4 = 1; n4 < stringArray.length; ++n4) {
                    hashMap.put(stringArray[n4], n4);
                }
            }
            return hashMap;
        }
        if (n == 9) {
            String[] stringArray = dateFormatSymbols.getAmPmStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i], i);
            }
            return hashMap;
        }
        if (n == 15) {
            String[][] stringArray = dateFormatSymbols.getZoneStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                if (n2 == 2 || n2 == 0) {
                    hashMap.put(stringArray[i][1], i);
                }
                if (n2 != 1 && n2 != 0) continue;
                hashMap.put(stringArray[i][2], i);
            }
            return hashMap;
        }
        if (n == 16) {
            String[][] stringArray = dateFormatSymbols.getZoneStrings();
            for (int i = 0; i < stringArray.length; ++i) {
                if (n2 == 2 || n2 == 0) {
                    hashMap.put(stringArray[i][3], i);
                }
                if (n2 != 1 && n2 != 0) continue;
                hashMap.put(stringArray[i][4], i);
            }
            return hashMap;
        }
        throw new InternalError("Failed to resolve field " + n + " with style " + n2 + " for locale " + locale);
    }

    static {
        try {
            properties.load(Calendar.class.getResourceAsStream("weeks.properties"));
        }
        catch (IOException iOException) {
            System.out.println("Failed to load weeks resource: " + iOException);
        }
        cache = new HashMap();
        ctorArgTypes = new Class[]{TimeZone.class, Locale.class};
        fieldNames = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET="};
    }
}

