/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    private Arrays() {
    }

    public static int binarySearch(byte[] byArray, byte by) {
        if (byArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(byArray, 0, byArray.length - 1, by);
    }

    public static int binarySearch(byte[] byArray, int n, int n2, byte by) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            byte by2 = byArray[n3];
            if (by2 == by) {
                return n3;
            }
            if (by2 > by) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(char[] cArray, char c) {
        if (cArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(cArray, 0, cArray.length - 1, c);
    }

    public static int binarySearch(char[] cArray, int n, int n2, char c) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            char c2 = cArray[n3];
            if (c2 == c) {
                return n3;
            }
            if (c2 > c) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(short[] sArray, short s) {
        if (sArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(sArray, 0, sArray.length - 1, s);
    }

    public static int binarySearch(short[] sArray, int n, int n2, short s) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > sArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            short s2 = sArray[n3];
            if (s2 == s) {
                return n3;
            }
            if (s2 > s) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(int[] nArray, int n) {
        if (nArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(nArray, 0, nArray.length - 1, n);
    }

    public static int binarySearch(int[] nArray, int n, int n2, int n3) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > nArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n4 = 0;
        while (n <= n2) {
            n4 = n + n2 >>> 1;
            int n5 = nArray[n4];
            if (n5 == n3) {
                return n4;
            }
            if (n5 > n3) {
                n2 = n4 - 1;
                continue;
            }
            n = ++n4;
        }
        return -n4 - 1;
    }

    public static int binarySearch(long[] lArray, long l) {
        if (lArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(lArray, 0, lArray.length - 1, l);
    }

    public static int binarySearch(long[] lArray, int n, int n2, long l) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > lArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            long l2 = lArray[n3];
            if (l2 == l) {
                return n3;
            }
            if (l2 > l) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(float[] fArray, float f) {
        if (fArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(fArray, 0, fArray.length - 1, f);
    }

    public static int binarySearch(float[] fArray, int n, int n2, float f) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > fArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            int n4 = Float.compare(fArray[n3], f);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(double[] dArray, double d) {
        if (dArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(dArray, 0, dArray.length - 1, d);
    }

    public static int binarySearch(double[] dArray, int n, int n2, double d) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > dArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            int n4 = Double.compare(dArray[n3], d);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        if (objectArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(objectArray, object, null);
    }

    public static int binarySearch(Object[] objectArray, int n, int n2, Object object) {
        return Arrays.binarySearch(objectArray, n, n2, object, null);
    }

    public static <T> int binarySearch(T[] TArray, T t, Comparator<? super T> comparator) {
        if (TArray.length == 0) {
            return -1;
        }
        return Arrays.binarySearch(TArray, 0, TArray.length - 1, t, comparator);
    }

    public static <T> int binarySearch(T[] TArray, int n, int n2, T t, Comparator<? super T> comparator) {
        if (n > n2) {
            throw new IllegalArgumentException("The start index is higher than the finish index.");
        }
        if (n < 0 || n2 > TArray.length) {
            throw new ArrayIndexOutOfBoundsException("One of the indices is out of bounds.");
        }
        int n3 = 0;
        while (n <= n2) {
            n3 = n + n2 >>> 1;
            int n4 = Collections.compare(TArray[n3], t, comparator);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            n = ++n3;
        }
        return -n3 - 1;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (null == blArray || null == blArray2) {
            return false;
        }
        if (blArray.length == blArray2.length) {
            int n = blArray.length;
            while (--n >= 0) {
                if (blArray[n] == blArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (null == byArray || null == byArray2) {
            return false;
        }
        if (byArray.length == byArray2.length) {
            int n = byArray.length;
            while (--n >= 0) {
                if (byArray[n] == byArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (null == cArray || null == cArray2) {
            return false;
        }
        if (cArray.length == cArray2.length) {
            int n = cArray.length;
            while (--n >= 0) {
                if (cArray[n] == cArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (null == sArray || null == sArray2) {
            return false;
        }
        if (sArray.length == sArray2.length) {
            int n = sArray.length;
            while (--n >= 0) {
                if (sArray[n] == sArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (null == nArray || null == nArray2) {
            return false;
        }
        if (nArray.length == nArray2.length) {
            int n = nArray.length;
            while (--n >= 0) {
                if (nArray[n] == nArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (null == lArray || null == lArray2) {
            return false;
        }
        if (lArray.length == lArray2.length) {
            int n = lArray.length;
            while (--n >= 0) {
                if (lArray[n] == lArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (null == fArray || null == fArray2) {
            return false;
        }
        if (fArray.length == fArray2.length) {
            int n = fArray.length;
            while (--n >= 0) {
                if (Float.compare(fArray[n], fArray2[n]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (null == dArray || null == dArray2) {
            return false;
        }
        if (dArray.length == dArray2.length) {
            int n = dArray.length;
            while (--n >= 0) {
                if (Double.compare(dArray[n], dArray2[n]) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (null == objectArray || null == objectArray2) {
            return false;
        }
        if (objectArray.length == objectArray2.length) {
            int n = objectArray.length;
            while (--n >= 0) {
                if (AbstractCollection.equals(objectArray[n], objectArray2[n])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void fill(boolean[] blArray, boolean bl) {
        Arrays.fill(blArray, 0, blArray.length, bl);
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, 0, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(char[] cArray, char c) {
        Arrays.fill(cArray, 0, cArray.length, c);
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(short[] sArray, short s) {
        Arrays.fill(sArray, 0, sArray.length, s);
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(int[] nArray, int n) {
        Arrays.fill(nArray, 0, nArray.length, n);
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            nArray[i] = n3;
        }
    }

    public static void fill(long[] lArray, long l) {
        Arrays.fill(lArray, 0, lArray.length, l);
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(float[] fArray, float f) {
        Arrays.fill(fArray, 0, fArray.length, f);
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(double[] dArray, double d) {
        Arrays.fill(dArray, 0, dArray.length, d);
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, 0, objectArray.length, object);
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        for (int i = n; i < n2; ++i) {
            objectArray[i] = object;
        }
    }

    public static void sort(byte[] byArray) {
        Arrays.qsort(byArray, 0, byArray.length);
    }

    public static void sort(byte[] byArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(byArray, n, n2 - n);
    }

    private static int med3(int n, int n2, int n3, byte[] byArray) {
        return byArray[n] < byArray[n2] ? (byArray[n2] < byArray[n3] ? n2 : (byArray[n] < byArray[n3] ? n3 : n)) : (byArray[n2] > byArray[n3] ? n2 : (byArray[n] > byArray[n3] ? n3 : n));
    }

    private static void swap(int n, int n2, byte[] byArray) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static void vecswap(int n, int n2, int n3, byte[] byArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, byArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static void qsort(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            for (int i = n + 1; i < n + n2; ++i) {
                for (int j = i; j > n && byArray[j - 1] > byArray[j]; --j) {
                    Arrays.swap(j, j - 1, byArray);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        int n7 = n;
        int n8 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n7 = Arrays.med3(n7, n7 + n5, n7 + 2 * n5, byArray);
            n6 = Arrays.med3(n6 - n5, n6, n6 + n5, byArray);
            n8 = Arrays.med3(n8 - 2 * n5, n8 - n5, n8, byArray);
        }
        n6 = Arrays.med3(n7, n6, n8, byArray);
        Arrays.swap(n, n6, byArray);
        n5 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            int n10;
            if (n4 <= n9 && (n10 = byArray[n4] - byArray[n]) <= 0) {
                if (n10 == 0) {
                    Arrays.swap(n5, n4, byArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && (n10 = byArray[n9] - byArray[n]) >= 0) {
                if (n10 == 0) {
                    Arrays.swap(n9, n3, byArray);
                    --n3;
                }
                --n9;
            }
            if (n4 > n9) break;
            Arrays.swap(n4, n9, byArray);
            ++n4;
            --n9;
        }
        n8 = n + n2;
        int n11 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n11, n11, byArray);
        n11 = Math.min(n3 - n9, n8 - n3 - 1);
        Arrays.vecswap(n4, n8 - n11, n11, byArray);
        n11 = n4 - n5;
        if (n11 > 1) {
            Arrays.qsort(byArray, n, n11);
        }
        if ((n11 = n3 - n9) > 1) {
            Arrays.qsort(byArray, n8 - n11, n11);
        }
    }

    public static void sort(char[] cArray) {
        Arrays.qsort(cArray, 0, cArray.length);
    }

    public static void sort(char[] cArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(cArray, n, n2 - n);
    }

    private static int med3(int n, int n2, int n3, char[] cArray) {
        return cArray[n] < cArray[n2] ? (cArray[n2] < cArray[n3] ? n2 : (cArray[n] < cArray[n3] ? n3 : n)) : (cArray[n2] > cArray[n3] ? n2 : (cArray[n] > cArray[n3] ? n3 : n));
    }

    private static void swap(int n, int n2, char[] cArray) {
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
    }

    private static void vecswap(int n, int n2, int n3, char[] cArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, cArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static void qsort(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            for (int i = n + 1; i < n + n2; ++i) {
                for (int j = i; j > n && cArray[j - 1] > cArray[j]; --j) {
                    Arrays.swap(j, j - 1, cArray);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        int n7 = n;
        int n8 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n7 = Arrays.med3(n7, n7 + n5, n7 + 2 * n5, cArray);
            n6 = Arrays.med3(n6 - n5, n6, n6 + n5, cArray);
            n8 = Arrays.med3(n8 - 2 * n5, n8 - n5, n8, cArray);
        }
        n6 = Arrays.med3(n7, n6, n8, cArray);
        Arrays.swap(n, n6, cArray);
        n5 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            int n10;
            if (n4 <= n9 && (n10 = cArray[n4] - cArray[n]) <= 0) {
                if (n10 == 0) {
                    Arrays.swap(n5, n4, cArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && (n10 = cArray[n9] - cArray[n]) >= 0) {
                if (n10 == 0) {
                    Arrays.swap(n9, n3, cArray);
                    --n3;
                }
                --n9;
            }
            if (n4 > n9) break;
            Arrays.swap(n4, n9, cArray);
            ++n4;
            --n9;
        }
        n8 = n + n2;
        int n11 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n11, n11, cArray);
        n11 = Math.min(n3 - n9, n8 - n3 - 1);
        Arrays.vecswap(n4, n8 - n11, n11, cArray);
        n11 = n4 - n5;
        if (n11 > 1) {
            Arrays.qsort(cArray, n, n11);
        }
        if ((n11 = n3 - n9) > 1) {
            Arrays.qsort(cArray, n8 - n11, n11);
        }
    }

    public static void sort(short[] sArray) {
        Arrays.qsort(sArray, 0, sArray.length);
    }

    public static void sort(short[] sArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(sArray, n, n2 - n);
    }

    private static int med3(int n, int n2, int n3, short[] sArray) {
        return sArray[n] < sArray[n2] ? (sArray[n2] < sArray[n3] ? n2 : (sArray[n] < sArray[n3] ? n3 : n)) : (sArray[n2] > sArray[n3] ? n2 : (sArray[n] > sArray[n3] ? n3 : n));
    }

    private static void swap(int n, int n2, short[] sArray) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    private static void vecswap(int n, int n2, int n3, short[] sArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, sArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static void qsort(short[] sArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            for (int i = n + 1; i < n + n2; ++i) {
                for (int j = i; j > n && sArray[j - 1] > sArray[j]; --j) {
                    Arrays.swap(j, j - 1, sArray);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        int n7 = n;
        int n8 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n7 = Arrays.med3(n7, n7 + n5, n7 + 2 * n5, sArray);
            n6 = Arrays.med3(n6 - n5, n6, n6 + n5, sArray);
            n8 = Arrays.med3(n8 - 2 * n5, n8 - n5, n8, sArray);
        }
        n6 = Arrays.med3(n7, n6, n8, sArray);
        Arrays.swap(n, n6, sArray);
        n5 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            int n10;
            if (n4 <= n9 && (n10 = sArray[n4] - sArray[n]) <= 0) {
                if (n10 == 0) {
                    Arrays.swap(n5, n4, sArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && (n10 = sArray[n9] - sArray[n]) >= 0) {
                if (n10 == 0) {
                    Arrays.swap(n9, n3, sArray);
                    --n3;
                }
                --n9;
            }
            if (n4 > n9) break;
            Arrays.swap(n4, n9, sArray);
            ++n4;
            --n9;
        }
        n8 = n + n2;
        int n11 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n11, n11, sArray);
        n11 = Math.min(n3 - n9, n8 - n3 - 1);
        Arrays.vecswap(n4, n8 - n11, n11, sArray);
        n11 = n4 - n5;
        if (n11 > 1) {
            Arrays.qsort(sArray, n, n11);
        }
        if ((n11 = n3 - n9) > 1) {
            Arrays.qsort(sArray, n8 - n11, n11);
        }
    }

    public static void sort(int[] nArray) {
        Arrays.qsort(nArray, 0, nArray.length);
    }

    public static void sort(int[] nArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(nArray, n, n2 - n);
    }

    private static int med3(int n, int n2, int n3, int[] nArray) {
        return nArray[n] < nArray[n2] ? (nArray[n2] < nArray[n3] ? n2 : (nArray[n] < nArray[n3] ? n3 : n)) : (nArray[n2] > nArray[n3] ? n2 : (nArray[n] > nArray[n3] ? n3 : n));
    }

    private static void swap(int n, int n2, int[] nArray) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void vecswap(int n, int n2, int n3, int[] nArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, nArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    private static void qsort(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            for (int i = n + 1; i < n + n2; ++i) {
                for (int j = i; j > n && nArray[j - 1] > nArray[j]; --j) {
                    Arrays.swap(j, j - 1, nArray);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        int n7 = n;
        int n8 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n7 = Arrays.med3(n7, n7 + n5, n7 + 2 * n5, nArray);
            n6 = Arrays.med3(n6 - n5, n6, n6 + n5, nArray);
            n8 = Arrays.med3(n8 - 2 * n5, n8 - n5, n8, nArray);
        }
        n6 = Arrays.med3(n7, n6, n8, nArray);
        Arrays.swap(n, n6, nArray);
        n5 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            int n10;
            if (n4 <= n9 && (n10 = Arrays.compare(nArray[n4], nArray[n])) <= 0) {
                if (n10 == 0) {
                    Arrays.swap(n5, n4, nArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && (n10 = Arrays.compare(nArray[n9], nArray[n])) >= 0) {
                if (n10 == 0) {
                    Arrays.swap(n9, n3, nArray);
                    --n3;
                }
                --n9;
            }
            if (n4 > n9) break;
            Arrays.swap(n4, n9, nArray);
            ++n4;
            --n9;
        }
        n8 = n + n2;
        int n11 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n11, n11, nArray);
        n11 = Math.min(n3 - n9, n8 - n3 - 1);
        Arrays.vecswap(n4, n8 - n11, n11, nArray);
        n11 = n4 - n5;
        if (n11 > 1) {
            Arrays.qsort(nArray, n, n11);
        }
        if ((n11 = n3 - n9) > 1) {
            Arrays.qsort(nArray, n8 - n11, n11);
        }
    }

    public static void sort(long[] lArray) {
        Arrays.qsort(lArray, 0, lArray.length);
    }

    public static void sort(long[] lArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(lArray, n, n2 - n);
    }

    private static int med3(int n, int n2, int n3, long[] lArray) {
        return lArray[n] < lArray[n2] ? (lArray[n2] < lArray[n3] ? n2 : (lArray[n] < lArray[n3] ? n3 : n)) : (lArray[n2] > lArray[n3] ? n2 : (lArray[n] > lArray[n3] ? n3 : n));
    }

    private static void swap(int n, int n2, long[] lArray) {
        long l = lArray[n];
        lArray[n] = lArray[n2];
        lArray[n2] = l;
    }

    private static void vecswap(int n, int n2, int n3, long[] lArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, lArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    private static void qsort(long[] lArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            for (int i = n + 1; i < n + n2; ++i) {
                for (int j = i; j > n && lArray[j - 1] > lArray[j]; --j) {
                    Arrays.swap(j, j - 1, lArray);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        int n7 = n;
        int n8 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n7 = Arrays.med3(n7, n7 + n5, n7 + 2 * n5, lArray);
            n6 = Arrays.med3(n6 - n5, n6, n6 + n5, lArray);
            n8 = Arrays.med3(n8 - 2 * n5, n8 - n5, n8, lArray);
        }
        n6 = Arrays.med3(n7, n6, n8, lArray);
        Arrays.swap(n, n6, lArray);
        n5 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            int n10;
            if (n4 <= n9 && (n10 = Arrays.compare(lArray[n4], lArray[n])) <= 0) {
                if (n10 == 0) {
                    Arrays.swap(n5, n4, lArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && (n10 = Arrays.compare(lArray[n9], lArray[n])) >= 0) {
                if (n10 == 0) {
                    Arrays.swap(n9, n3, lArray);
                    --n3;
                }
                --n9;
            }
            if (n4 > n9) break;
            Arrays.swap(n4, n9, lArray);
            ++n4;
            --n9;
        }
        n8 = n + n2;
        int n11 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n11, n11, lArray);
        n11 = Math.min(n3 - n9, n8 - n3 - 1);
        Arrays.vecswap(n4, n8 - n11, n11, lArray);
        n11 = n4 - n5;
        if (n11 > 1) {
            Arrays.qsort(lArray, n, n11);
        }
        if ((n11 = n3 - n9) > 1) {
            Arrays.qsort(lArray, n8 - n11, n11);
        }
    }

    public static void sort(float[] fArray) {
        Arrays.qsort(fArray, 0, fArray.length);
    }

    public static void sort(float[] fArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(fArray, n, n2 - n);
    }

    private static int med3(int n, int n2, int n3, float[] fArray) {
        return Float.compare(fArray[n], fArray[n2]) < 0 ? (Float.compare(fArray[n2], fArray[n3]) < 0 ? n2 : (Float.compare(fArray[n], fArray[n3]) < 0 ? n3 : n)) : (Float.compare(fArray[n2], fArray[n3]) > 0 ? n2 : (Float.compare(fArray[n], fArray[n3]) > 0 ? n3 : n));
    }

    private static void swap(int n, int n2, float[] fArray) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    private static void vecswap(int n, int n2, int n3, float[] fArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, fArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static void qsort(float[] fArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            for (int i = n + 1; i < n + n2; ++i) {
                for (int j = i; j > n && Float.compare(fArray[j - 1], fArray[j]) > 0; --j) {
                    Arrays.swap(j, j - 1, fArray);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        int n7 = n;
        int n8 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n7 = Arrays.med3(n7, n7 + n5, n7 + 2 * n5, fArray);
            n6 = Arrays.med3(n6 - n5, n6, n6 + n5, fArray);
            n8 = Arrays.med3(n8 - 2 * n5, n8 - n5, n8, fArray);
        }
        n6 = Arrays.med3(n7, n6, n8, fArray);
        Arrays.swap(n, n6, fArray);
        n5 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            int n10;
            if (n4 <= n9 && (n10 = Float.compare(fArray[n4], fArray[n])) <= 0) {
                if (n10 == 0) {
                    Arrays.swap(n5, n4, fArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && (n10 = Float.compare(fArray[n9], fArray[n])) >= 0) {
                if (n10 == 0) {
                    Arrays.swap(n9, n3, fArray);
                    --n3;
                }
                --n9;
            }
            if (n4 > n9) break;
            Arrays.swap(n4, n9, fArray);
            ++n4;
            --n9;
        }
        n8 = n + n2;
        int n11 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n11, n11, fArray);
        n11 = Math.min(n3 - n9, n8 - n3 - 1);
        Arrays.vecswap(n4, n8 - n11, n11, fArray);
        n11 = n4 - n5;
        if (n11 > 1) {
            Arrays.qsort(fArray, n, n11);
        }
        if ((n11 = n3 - n9) > 1) {
            Arrays.qsort(fArray, n8 - n11, n11);
        }
    }

    public static void sort(double[] dArray) {
        Arrays.qsort(dArray, 0, dArray.length);
    }

    public static void sort(double[] dArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.qsort(dArray, n, n2 - n);
    }

    private static int med3(int n, int n2, int n3, double[] dArray) {
        return Double.compare(dArray[n], dArray[n2]) < 0 ? (Double.compare(dArray[n2], dArray[n3]) < 0 ? n2 : (Double.compare(dArray[n], dArray[n3]) < 0 ? n3 : n)) : (Double.compare(dArray[n2], dArray[n3]) > 0 ? n2 : (Double.compare(dArray[n], dArray[n3]) > 0 ? n3 : n));
    }

    private static void swap(int n, int n2, double[] dArray) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private static void vecswap(int n, int n2, int n3, double[] dArray) {
        while (n3 > 0) {
            Arrays.swap(n, n2, dArray);
            ++n;
            ++n2;
            --n3;
        }
    }

    private static void qsort(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 <= 7) {
            for (int i = n + 1; i < n + n2; ++i) {
                for (int j = i; j > n && Double.compare(dArray[j - 1], dArray[j]) > 0; --j) {
                    Arrays.swap(j, j - 1, dArray);
                }
            }
            return;
        }
        int n6 = n + n2 / 2;
        int n7 = n;
        int n8 = n + n2 - 1;
        if (n2 > 40) {
            n5 = n2 / 8;
            n7 = Arrays.med3(n7, n7 + n5, n7 + 2 * n5, dArray);
            n6 = Arrays.med3(n6 - n5, n6, n6 + n5, dArray);
            n8 = Arrays.med3(n8 - 2 * n5, n8 - n5, n8, dArray);
        }
        n6 = Arrays.med3(n7, n6, n8, dArray);
        Arrays.swap(n, n6, dArray);
        n5 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            int n10;
            if (n4 <= n9 && (n10 = Double.compare(dArray[n4], dArray[n])) <= 0) {
                if (n10 == 0) {
                    Arrays.swap(n5, n4, dArray);
                    ++n5;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && (n10 = Double.compare(dArray[n9], dArray[n])) >= 0) {
                if (n10 == 0) {
                    Arrays.swap(n9, n3, dArray);
                    --n3;
                }
                --n9;
            }
            if (n4 > n9) break;
            Arrays.swap(n4, n9, dArray);
            ++n4;
            --n9;
        }
        n8 = n + n2;
        int n11 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(n, n4 - n11, n11, dArray);
        n11 = Math.min(n3 - n9, n8 - n3 - 1);
        Arrays.vecswap(n4, n8 - n11, n11, dArray);
        n11 = n4 - n5;
        if (n11 > 1) {
            Arrays.qsort(dArray, n, n11);
        }
        if ((n11 = n3 - n9) > 1) {
            Arrays.qsort(dArray, n8 - n11, n11);
        }
    }

    public static void sort(Object[] objectArray) {
        Arrays.sort(objectArray, 0, objectArray.length, null);
    }

    public static <T> void sort(T[] TArray, Comparator<? super T> comparator) {
        Arrays.sort(TArray, 0, TArray.length, comparator);
    }

    public static void sort(Object[] objectArray, int n, int n2) {
        Arrays.sort(objectArray, n, n2, null);
    }

    public static <T> void sort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        int n3;
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex " + n + " > toIndex " + n2);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (n3 = n; n3 < n2; n3 += 6) {
            int n4 = Math.min(n3 + 6, n2);
            for (int i = n3 + 1; i < n4; ++i) {
                if (Collections.compare(TArray[i - 1], TArray[i], comparator) <= 0) continue;
                int n5 = i;
                T t = TArray[n5];
                do {
                    TArray[n5] = TArray[n5 - 1];
                } while (--n5 > n3 && Collections.compare(TArray[n5 - 1], t, comparator) > 0);
                TArray[n5] = t;
            }
        }
        n3 = n2 - n;
        if (n3 <= 6) {
            return;
        }
        Object[] objectArray = TArray;
        Object[] objectArray2 = new Object[n3];
        T[] TArray2 = null;
        int n6 = -n;
        for (int i = 6; i < n3; i <<= 1) {
            for (int j = n; j < n2; j += i << 1) {
                int n7 = j + i;
                int n8 = Math.min(n2, n7 + i);
                if (n7 >= n8 || Collections.compare(objectArray[n7 - 1], objectArray[n7], comparator) <= 0) {
                    System.arraycopy(objectArray, j, objectArray2, j + n6, n8 - j);
                    continue;
                }
                if (Collections.compare(objectArray[j], objectArray[n8 - 1], comparator) > 0) {
                    System.arraycopy(objectArray, j, objectArray2, n8 - i + n6, i);
                    System.arraycopy(objectArray, n7, objectArray2, j + n6, n8 - n7);
                    continue;
                }
                int n9 = j;
                int n10 = n7;
                int n11 = j + n6;
                while (n9 < n7 && n10 < n8) {
                    objectArray2[n11++] = objectArray[Collections.compare(objectArray[n9], objectArray[n10], comparator) <= 0 ? n9++ : n10++];
                }
                if (n9 < n7) {
                    System.arraycopy(objectArray, n9, objectArray2, n11, n7 - n9);
                    continue;
                }
                System.arraycopy(objectArray, n10, objectArray2, n11, n8 - n10);
            }
            TArray2 = objectArray;
            objectArray = objectArray2;
            objectArray2 = TArray2;
            n += n6;
            n2 += n6;
            n6 = -n6;
        }
        if (objectArray != TArray) {
            System.arraycopy(objectArray, 0, TArray, n6, n2);
        }
    }

    public static <T> List<T> asList(T ... TArray) {
        return new ArrayList<T>(TArray);
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < lArray.length; ++i) {
            int n2 = (int)(lArray[i] ^ lArray[i] >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < nArray.length; ++i) {
            n = 31 * n + nArray[i];
        }
        return n;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < sArray.length; ++i) {
            n = 31 * n + sArray[i];
        }
        return n;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < cArray.length; ++i) {
            n = 31 * n + cArray[i];
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < byArray.length; ++i) {
            n = 31 * n + byArray[i];
        }
        return n;
    }

    public static int hashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < blArray.length; ++i) {
            n = 31 * n + (blArray[i] ? 1231 : 1237);
        }
        return n;
    }

    public static int hashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < fArray.length; ++i) {
            n = 31 * n + Float.floatToIntBits(fArray[i]);
        }
        return n;
    }

    public static int hashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < dArray.length; ++i) {
            long l = Double.doubleToLongBits(dArray[i]);
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = objectArray[i] == null ? 0 : objectArray[i].hashCode();
            n = 31 * n + n2;
        }
        return n;
    }

    public static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2 = objectArray[i] == null ? 0 : (objectArray[i] instanceof boolean[] ? Arrays.hashCode((boolean[])objectArray[i]) : (objectArray[i] instanceof byte[] ? Arrays.hashCode((byte[])objectArray[i]) : (objectArray[i] instanceof char[] ? Arrays.hashCode((char[])objectArray[i]) : (objectArray[i] instanceof short[] ? Arrays.hashCode((short[])objectArray[i]) : (objectArray[i] instanceof int[] ? Arrays.hashCode((int[])objectArray[i]) : (objectArray[i] instanceof long[] ? Arrays.hashCode((long[])objectArray[i]) : (objectArray[i] instanceof float[] ? Arrays.hashCode((float[])objectArray[i]) : (objectArray[i] instanceof double[] ? Arrays.hashCode((double[])objectArray[i]) : (objectArray[i] instanceof Object[] ? Arrays.hashCode((Object[])objectArray[i]) : objectArray[i].hashCode())))))))));
            n = 31 * n + n2;
        }
        return n;
    }

    public static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2 == null;
        }
        if (objectArray2 == null || objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object == object2) continue;
            if (object == null || object2 == null) {
                return false;
            }
            boolean bl = object instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object, (boolean[])object2) : (object instanceof byte[] && object2 instanceof byte[] ? Arrays.equals((byte[])object, (byte[])object2) : (object instanceof char[] && object2 instanceof char[] ? Arrays.equals((char[])object, (char[])object2) : (object instanceof short[] && object2 instanceof short[] ? Arrays.equals((short[])object, (short[])object2) : (object instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object, (int[])object2) : (object instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object, (long[])object2) : (object instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object, (float[])object2) : (object instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object, (double[])object2) : (object instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object, (Object[])object2) : object.equals(object2)))))))));
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static String toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < blArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(blArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(byArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < cArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(cArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < sArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(sArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(nArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(lArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(fArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(dArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            cPStringBuilder.append(objectArray[i]);
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    private static void deepToString(Object[] objectArray, CPStringBuilder cPStringBuilder, HashSet hashSet) {
        cPStringBuilder.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            if (i > 0) {
                cPStringBuilder.append(", ");
            }
            if ((object = objectArray[i]) == null) {
                cPStringBuilder.append("null");
                continue;
            }
            if (object instanceof boolean[]) {
                cPStringBuilder.append(Arrays.toString((boolean[])object));
                continue;
            }
            if (object instanceof byte[]) {
                cPStringBuilder.append(Arrays.toString((byte[])object));
                continue;
            }
            if (object instanceof char[]) {
                cPStringBuilder.append(Arrays.toString((char[])object));
                continue;
            }
            if (object instanceof short[]) {
                cPStringBuilder.append(Arrays.toString((short[])object));
                continue;
            }
            if (object instanceof int[]) {
                cPStringBuilder.append(Arrays.toString((int[])object));
                continue;
            }
            if (object instanceof long[]) {
                cPStringBuilder.append(Arrays.toString((long[])object));
                continue;
            }
            if (object instanceof float[]) {
                cPStringBuilder.append(Arrays.toString((float[])object));
                continue;
            }
            if (object instanceof double[]) {
                cPStringBuilder.append(Arrays.toString((double[])object));
                continue;
            }
            if (object instanceof Object[]) {
                Object[] objectArray2 = (Object[])object;
                if (hashSet.contains(objectArray2)) {
                    cPStringBuilder.append("[...]");
                    continue;
                }
                hashSet.add(objectArray2);
                Arrays.deepToString(objectArray2, cPStringBuilder, hashSet);
                continue;
            }
            cPStringBuilder.append(object);
        }
        cPStringBuilder.append("]");
    }

    public static String deepToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        HashSet hashSet = new HashSet();
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        Arrays.deepToString(objectArray, cPStringBuilder, hashSet);
        return cPStringBuilder.toString();
    }

    public static boolean[] copyOf(boolean[] blArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(blArray, 0, n);
    }

    public static boolean[] copyOfRange(boolean[] blArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        boolean[] blArray2 = new boolean[n2 - n];
        if (n2 > blArray.length) {
            System.arraycopy(blArray, n, blArray2, 0, blArray.length - n);
            Arrays.fill(blArray2, blArray.length, blArray2.length, false);
        } else {
            System.arraycopy(blArray, n, blArray2, 0, n2 - n);
        }
        return blArray2;
    }

    public static byte[] copyOf(byte[] byArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(byArray, 0, n);
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        byte[] byArray2 = new byte[n2 - n];
        if (n2 > byArray.length) {
            System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
            Arrays.fill(byArray2, byArray.length, byArray2.length, (byte)0);
        } else {
            System.arraycopy(byArray, n, byArray2, 0, n2 - n);
        }
        return byArray2;
    }

    public static char[] copyOf(char[] cArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(cArray, 0, n);
    }

    public static char[] copyOfRange(char[] cArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        char[] cArray2 = new char[n2 - n];
        if (n2 > cArray.length) {
            System.arraycopy(cArray, n, cArray2, 0, cArray.length - n);
            Arrays.fill(cArray2, cArray.length, cArray2.length, '\u0000');
        } else {
            System.arraycopy(cArray, n, cArray2, 0, n2 - n);
        }
        return cArray2;
    }

    public static double[] copyOf(double[] dArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(dArray, 0, n);
    }

    public static double[] copyOfRange(double[] dArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        double[] dArray2 = new double[n2 - n];
        if (n2 > dArray.length) {
            System.arraycopy(dArray, n, dArray2, 0, dArray.length - n);
            Arrays.fill(dArray2, dArray.length, dArray2.length, 0.0);
        } else {
            System.arraycopy(dArray, n, dArray2, 0, n2 - n);
        }
        return dArray2;
    }

    public static float[] copyOf(float[] fArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(fArray, 0, n);
    }

    public static float[] copyOfRange(float[] fArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        float[] fArray2 = new float[n2 - n];
        if (n2 > fArray.length) {
            System.arraycopy(fArray, n, fArray2, 0, fArray.length - n);
            Arrays.fill(fArray2, fArray.length, fArray2.length, 0.0f);
        } else {
            System.arraycopy(fArray, n, fArray2, 0, n2 - n);
        }
        return fArray2;
    }

    public static int[] copyOf(int[] nArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(nArray, 0, n);
    }

    public static int[] copyOfRange(int[] nArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        int[] nArray2 = new int[n2 - n];
        if (n2 > nArray.length) {
            System.arraycopy(nArray, n, nArray2, 0, nArray.length - n);
            Arrays.fill(nArray2, nArray.length, nArray2.length, 0);
        } else {
            System.arraycopy(nArray, n, nArray2, 0, n2 - n);
        }
        return nArray2;
    }

    public static long[] copyOf(long[] lArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(lArray, 0, n);
    }

    public static long[] copyOfRange(long[] lArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        long[] lArray2 = new long[n2 - n];
        if (n2 > lArray.length) {
            System.arraycopy(lArray, n, lArray2, 0, lArray.length - n);
            Arrays.fill(lArray2, lArray.length, lArray2.length, 0L);
        } else {
            System.arraycopy(lArray, n, lArray2, 0, n2 - n);
        }
        return lArray2;
    }

    public static short[] copyOf(short[] sArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(sArray, 0, n);
    }

    public static short[] copyOfRange(short[] sArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        short[] sArray2 = new short[n2 - n];
        if (n2 > sArray.length) {
            System.arraycopy(sArray, n, sArray2, 0, sArray.length - n);
            Arrays.fill(sArray2, sArray.length, sArray2.length, (short)0);
        } else {
            System.arraycopy(sArray, n, sArray2, 0, n2 - n);
        }
        return sArray2;
    }

    public static <T> T[] copyOf(T[] TArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(TArray, 0, n);
    }

    public static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2 - n);
        if (n2 > TArray.length) {
            System.arraycopy(TArray, n, objectArray, 0, TArray.length - n);
            Arrays.fill(objectArray, TArray.length, objectArray.length, null);
        } else {
            System.arraycopy(TArray, n, objectArray, 0, n2 - n);
        }
        return objectArray;
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> clazz) {
        if (n < 0) {
            throw new NegativeArraySizeException("The array size is negative.");
        }
        return Arrays.copyOfRange(UArray, 0, n, clazz);
    }

    public static <T, U> T[] copyOfRange(U[] UArray, int n, int n2, Class<? extends T[]> clazz) {
        if (n > n2) {
            throw new IllegalArgumentException("The initial index is after the final index.");
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n2 - n);
        if (n2 > UArray.length) {
            System.arraycopy(UArray, n, objectArray, 0, UArray.length - n);
            Arrays.fill(objectArray, UArray.length, objectArray.length, null);
        } else {
            System.arraycopy(UArray, n, objectArray, 0, n2 - n);
        }
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        ArrayList(E[] EArray) {
            if (EArray == null) {
                throw new NullPointerException();
            }
            this.a = EArray;
        }

        @Override
        public E get(int n) {
            return this.a[n];
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public E set(int n, E e) {
            E e2 = this.a[n];
            this.a[n] = e;
            return e2;
        }

        @Override
        public boolean contains(Object object) {
            return this.lastIndexOf(object) >= 0;
        }

        @Override
        public int indexOf(Object object) {
            int n = this.a.length;
            for (int i = 0; i < n; ++i) {
                if (!ArrayList.equals(object, this.a[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n = this.a.length;
            while (--n >= 0) {
                if (!ArrayList.equals(object, this.a[n])) continue;
                return n;
            }
            return -1;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.a.length;
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            } else if (objectArray.length > n) {
                objectArray[n] = null;
            }
            System.arraycopy(this.a, 0, objectArray, 0, n);
            return objectArray;
        }
    }
}

