/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private int size;
    private transient E[] data;

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new Object[n];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(Collection<? extends E> collection) {
        this((int)((float)collection.size() * 1.1f));
        this.addAll(collection);
    }

    public void trimToSize() {
        if (this.size != this.data.length) {
            Object[] objectArray = new Object[this.size];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            Object[] objectArray = new Object[Math.max(n2 * 2, n)];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (!ArrayList.equals(object, this.data[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!ArrayList.equals(object, this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)super.clone();
            arrayList.data = (Object[])this.data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public E get(int n) {
        this.checkBoundExclusive(n);
        return this.data[n];
    }

    @Override
    public E set(int n, E e) {
        this.checkBoundExclusive(n);
        E e2 = this.data[n];
        this.data[n] = e;
        return e2;
    }

    @Override
    public boolean add(E e) {
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = e;
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.checkBoundInclusive(n);
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (n != this.size) {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        this.checkBoundExclusive(n);
        E e = this.data[n];
        ++this.modCount;
        if (n != --this.size) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        this.data[this.size] = null;
        return e;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.data, 0, this.size, null);
            this.size = 0;
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.checkBoundInclusive(n);
        Iterator<E> iterator = collection.iterator();
        int n2 = collection.size();
        ++this.modCount;
        if (n2 + this.size > this.data.length) {
            this.ensureCapacity(this.size + n2);
        }
        int n3 = n + n2;
        if (this.size > 0 && n != this.size) {
            System.arraycopy(this.data, n, this.data, n3, this.size - n);
        }
        this.size += n2;
        while (n < n3) {
            this.data[n] = iterator.next();
            ++n;
        }
        return n2 > 0;
    }

    @Override
    protected void removeRange(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            ++this.modCount;
            System.arraycopy(this.data, n2, this.data, n, this.size - n2);
            this.size -= n3;
        } else if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkBoundInclusive(int n) {
        if (n > this.size) {
            this.raiseBoundsError(n);
        }
    }

    private void checkBoundExclusive(int n) {
        if (n >= this.size) {
            this.raiseBoundsError(n);
        }
    }

    private void raiseBoundsError(int n) {
        throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
    }

    @Override
    boolean removeAllInternal(Collection<?> collection) {
        int n;
        for (n = 0; n < this.size && !collection.contains(this.data[n]); ++n) {
        }
        if (n == this.size) {
            return false;
        }
        ++this.modCount;
        int n2 = n++;
        while (n < this.size) {
            if (!collection.contains(this.data[n])) {
                this.data[n2++] = this.data[n];
            }
            ++n;
        }
        this.size -= n - n2;
        return true;
    }

    @Override
    boolean retainAllInternal(Collection<?> collection) {
        int n;
        for (n = 0; n < this.size && collection.contains(this.data[n]); ++n) {
        }
        if (n == this.size) {
            return false;
        }
        ++this.modCount;
        int n2 = n++;
        while (n < this.size) {
            if (collection.contains(this.data[n])) {
                this.data[n2++] = this.data[n];
            }
            ++n;
        }
        this.size -= n - n2;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.data.length;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = new Object[n];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = objectInputStream.readObject();
        }
    }
}

