/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMap<K, V>
implements Map<K, V> {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    Set<K> keys;
    Collection<V> values;

    protected AbstractMap() {
    }

    @Override
    public abstract Set<Map.Entry<K, V>> entrySet();

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractMap abstractMap = (AbstractMap)super.clone();
        abstractMap.keys = null;
        abstractMap.values = null;
        return abstractMap;
    }

    @Override
    public boolean containsKey(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractMap.equals(object, iterator.next().getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractMap.equals(object, iterator.next().getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof Map && this.entrySet().equals(((Map)object).entrySet());
    }

    @Override
    public V get(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            Map.Entry<K, V> entry = iterator.next();
            if (!AbstractMap.equals(object, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsKey(object);
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private final Iterator<Map.Entry<K, V>> map_iterator;
                        {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.map_iterator.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.keys;
    }

    @Override
    public V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator<Map.Entry<K, V>> iterator;
        Iterator<Map.Entry<K, V>> iterator2 = iterator = map.entrySet().iterator();
        int n = map.size();
        while (--n >= 0) {
            Map.Entry<K, V> entry = iterator2.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            Map.Entry<K, V> entry = iterator.next();
            if (!AbstractMap.equals(object, entry.getKey())) continue;
            V v = entry.getValue();
            iterator.remove();
            return v;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        CPStringBuilder cPStringBuilder = new CPStringBuilder("{");
        for (int i = this.size(); i > 0; --i) {
            Map.Entry<K, V> entry = iterator.next();
            cPStringBuilder.append(entry.getKey());
            cPStringBuilder.append('=');
            cPStringBuilder.append(entry.getValue());
            if (i <= 1) continue;
            cPStringBuilder.append(", ");
        }
        cPStringBuilder.append("}");
        return cPStringBuilder.toString();
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsValue(object);
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final Iterator<Map.Entry<K, V>> map_iterator;
                        {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.map_iterator.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.values;
    }

    static final boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    static final int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        K key;
        V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            if (object instanceof SimpleEntry) {
                SimpleEntry simpleEntry = (SimpleEntry)object;
                return AbstractMap.equals(this.key, simpleEntry.key) && AbstractMap.equals(this.value, simpleEntry.value);
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractMap.equals(this.key, entry.getKey()) && AbstractMap.equals(this.value, entry.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return AbstractMap.hashCode(this.key) ^ AbstractMap.hashCode(this.value);
        }

        @Override
        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 7138329143949025153L;
        K key;
        V value;

        public SimpleImmutableEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException("setValue not supported on immutable entry");
        }
    }
}

