/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractList<E>
extends AbstractCollection<E>
implements List<E> {
    protected transient int modCount;

    protected AbstractList() {
    }

    @Override
    public abstract E get(int var1);

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        int n2;
        Iterator<E> iterator = collection.iterator();
        for (int i = n2 = collection.size(); i > 0; --i) {
            this.add(n++, iterator.next());
        }
        return n2 > 0;
    }

    @Override
    public void clear() {
        this.removeRange(0, this.size());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        int n = this.size();
        if (n != ((List)object).size()) {
            return false;
        }
        Iterator<E> iterator = this.iterator();
        Iterator iterator2 = ((List)object).iterator();
        while (--n >= 0) {
            if (AbstractList.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        Iterator<E> iterator = this.iterator();
        int n2 = this.size();
        while (--n2 >= 0) {
            n = 31 * n + AbstractList.hashCode(iterator.next());
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        ListIterator<E> listIterator = this.listIterator();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!AbstractList.equals(object, listIterator.next())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int pos = 0;
            private int size = AbstractList.this.size();
            private int last = -1;
            private int knownMod;
            {
                this.knownMod = AbstractList.this.modCount;
            }

            private void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.size;
            }

            @Override
            public E next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return AbstractList.this.get(this.pos++);
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size();
        ListIterator<E> listIterator = this.listIterator(n);
        while (--n >= 0) {
            if (!AbstractList.equals(object, listIterator.previous())) continue;
            return n;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size());
        }
        return new ListIterator<E>(){
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;
            {
                this.knownMod = AbstractList.this.modCount;
                this.position = n;
                this.lastReturned = -1;
                this.size = AbstractList.this.size();
            }

            private void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public boolean hasNext() {
                return this.position < this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.position > 0;
            }

            @Override
            public E next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return AbstractList.this.get(this.position++);
            }

            @Override
            public E previous() {
                this.checkMod();
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.position;
                return AbstractList.this.get(this.lastReturned);
            }

            @Override
            public int nextIndex() {
                return this.position;
            }

            @Override
            public int previousIndex() {
                return this.position - 1;
            }

            @Override
            public void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            @Override
            public void set(E e) {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.set(this.lastReturned, e);
            }

            @Override
            public void add(E e) {
                this.checkMod();
                AbstractList.this.add(this.position++, e);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }
        };
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int n, int n2) {
        ListIterator<E> listIterator = this.listIterator(n);
        for (int i = n; i < n2; ++i) {
            listIterator.next();
            listIterator.remove();
        }
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, n, n2);
        }
        return new SubList(this, n, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RandomAccessSubList<E>
    extends SubList<E>
    implements RandomAccess {
        RandomAccessSubList(AbstractList<E> abstractList, int n, int n2) {
            super(abstractList, n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubList<E>
    extends AbstractList<E> {
        final AbstractList<E> backingList;
        final int offset;
        int size;

        SubList(AbstractList<E> abstractList, int n, int n2) {
            this.backingList = abstractList;
            this.modCount = abstractList.modCount;
            this.offset = n;
            this.size = n2 - n;
        }

        void checkMod() {
            if (this.modCount != this.backingList.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkBoundsInclusive(int n) {
            if (n < 0 || n > this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        private void checkBoundsExclusive(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        @Override
        public int size() {
            this.checkMod();
            return this.size;
        }

        @Override
        public E set(int n, E e) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            return this.backingList.set(n + this.offset, e);
        }

        @Override
        public E get(int n) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            return this.backingList.get(n + this.offset);
        }

        @Override
        public void add(int n, E e) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            this.backingList.add(n + this.offset, e);
            ++this.size;
            this.modCount = this.backingList.modCount;
        }

        @Override
        public E remove(int n) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            E e = this.backingList.remove(n + this.offset);
            --this.size;
            this.modCount = this.backingList.modCount;
            return e;
        }

        @Override
        protected void removeRange(int n, int n2) {
            this.checkMod();
            this.backingList.removeRange(this.offset + n, this.offset + n2);
            this.size -= n2 - n;
            this.modCount = this.backingList.modCount;
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            int n2 = collection.size();
            boolean bl = this.backingList.addAll(this.offset + n, collection);
            this.size += n2;
            this.modCount = this.backingList.modCount;
            return bl;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.addAll(this.size, collection);
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int n) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            return new ListIterator<E>(){
                private final ListIterator<E> i;
                private int position;
                {
                    this.i = SubList.this.backingList.listIterator(n + SubList.this.offset);
                    this.position = n;
                }

                @Override
                public boolean hasNext() {
                    return this.position < SubList.this.size;
                }

                @Override
                public boolean hasPrevious() {
                    return this.position > 0;
                }

                @Override
                public E next() {
                    if (this.position == SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                @Override
                public E previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex() - SubList.this.offset;
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex() - SubList.this.offset;
                }

                @Override
                public void remove() {
                    this.i.remove();
                    --SubList.this.size;
                    this.position = this.nextIndex();
                    SubList.this.modCount = SubList.this.backingList.modCount;
                }

                @Override
                public void set(E e) {
                    this.i.set(e);
                }

                @Override
                public void add(E e) {
                    this.i.add(e);
                    ++SubList.this.size;
                    ++this.position;
                    SubList.this.modCount = SubList.this.backingList.modCount;
                }
            };
        }
    }
}

