/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.java.lang.CPStringBuilder;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollection<E>
implements Collection<E>,
Iterable<E> {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        boolean bl = false;
        int n = collection.size();
        while (--n >= 0) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        Iterator<E> iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public boolean contains(Object object) {
        Iterator<E> iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object object) {
        Iterator<E> iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.removeAllInternal(collection);
    }

    boolean removeAllInternal(Collection<?> collection) {
        Iterator<E> iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.retainAllInternal(collection);
    }

    boolean retainAllInternal(Collection<?> collection) {
        Iterator<E> iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public Object[] toArray() {
        Iterator<E> iterator = this.iterator();
        int n = this.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        } else if (objectArray.length > n) {
            objectArray[n] = null;
        }
        Iterator<E> iterator = this.iterator();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    public String toString() {
        Iterator<E> iterator = this.iterator();
        CPStringBuilder cPStringBuilder = new CPStringBuilder("[");
        boolean bl = iterator.hasNext();
        while (bl) {
            E e = iterator.next();
            if (e == this) {
                cPStringBuilder.append("<this>");
            } else {
                cPStringBuilder.append(e);
            }
            if (!(bl = iterator.hasNext())) continue;
            cPStringBuilder.append(", ");
        }
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    static final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static final int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }
}

