/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import gnu.java.text.AttributedFormatBuffer;
import gnu.java.text.FormatBuffer;
import gnu.java.text.FormatCharacterIterator;
import gnu.java.text.StringFormatBuffer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleDateFormat
extends DateFormat {
    private transient ArrayList<Object> tokens;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCentury;
    private String pattern;
    private int serialVersionOnStream = 1;
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String standardChars = "GyMdkHmsSEDFwWahKzYeugAZvcL";
    private static final int RFC822_TIMEZONE_FIELD = 23;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.computeCenturyStart();
            this.serialVersionOnStream = 1;
        } else {
            this.set2DigitYearStart(this.defaultCenturyStart);
        }
        this.tokens = new ArrayList();
        try {
            this.compileFormat(this.pattern);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException("The stream pattern was invalid.");
        }
    }

    private void compileFormat(String string) {
        CompiledField compiledField = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = standardChars.indexOf(c);
            if (n == -1) {
                compiledField = null;
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    throw new IllegalArgumentException("Invalid letter " + c + " encountered at character " + i + ".");
                }
                if (c == '\'') {
                    int n2 = string.indexOf(39, i + 1);
                    if (n2 == i + 1) {
                        this.tokens.add("'");
                    } else {
                        CPStringBuilder cPStringBuilder = new CPStringBuilder();
                        int n3 = i + 1;
                        while (true) {
                            if (n2 == -1) {
                                throw new IllegalArgumentException("Quotes starting at character " + i + " not closed.");
                            }
                            cPStringBuilder.append(string.substring(n3, n2));
                            if (n2 + 1 >= string.length() || string.charAt(n2 + 1) != '\'') break;
                            cPStringBuilder.append('\'');
                            n3 = n2 + 2;
                            n2 = string.indexOf(39, n2 + 2);
                        }
                        this.tokens.add(cPStringBuilder.toString());
                    }
                    i = n2;
                    continue;
                }
                this.tokens.add(Character.valueOf(c));
                continue;
            }
            if (compiledField != null && n == compiledField.field) {
                ++compiledField.size;
                continue;
            }
            compiledField = new CompiledField(n, 1, c);
            this.tokens.add(compiledField);
        }
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(this.getClass().getName());
        cPStringBuilder.append("[tokens=");
        cPStringBuilder.append(this.tokens);
        cPStringBuilder.append(", formatData=");
        cPStringBuilder.append(this.formatData);
        cPStringBuilder.append(", defaultCenturyStart=");
        cPStringBuilder.append(this.defaultCenturyStart);
        cPStringBuilder.append(", defaultCentury=");
        cPStringBuilder.append(this.defaultCentury);
        cPStringBuilder.append(", pattern=");
        cPStringBuilder.append(this.pattern);
        cPStringBuilder.append(", serialVersionOnStream=");
        cPStringBuilder.append(this.serialVersionOnStream);
        cPStringBuilder.append(", standardChars=");
        cPStringBuilder.append(standardChars);
        cPStringBuilder.append("]");
        return cPStringBuilder.toString();
    }

    public SimpleDateFormat() {
        Locale locale = Locale.getDefault();
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.pattern = this.formatData.dateFormats[2] + ' ' + this.formatData.timeFormats[2];
        this.compileFormat(this.pattern);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.compileFormat(string);
        this.pattern = string;
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.calendar = new GregorianCalendar();
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        if (dateFormatSymbols == null) {
            throw new NullPointerException("formatData");
        }
        this.formatData = dateFormatSymbols;
        this.compileFormat(string);
        this.pattern = string;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        String string = this.formatData.getLocalPatternChars();
        return this.translateLocalizedPattern(this.pattern, standardChars, string);
    }

    public void applyPattern(String string) {
        this.tokens.clear();
        this.compileFormat(string);
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        String string2 = this.formatData.getLocalPatternChars();
        string = this.translateLocalizedPattern(string, string2, standardChars);
        this.applyPattern(string);
    }

    private String translateLocalizedPattern(String string, String string2, String string3) {
        int n = string.length();
        CPStringBuilder cPStringBuilder = new CPStringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (c == '\'') {
                boolean bl2 = bl = !bl;
            }
            if (!bl && (n2 = string2.indexOf(c)) >= 0) {
                c = string3.charAt(n2);
            }
            cPStringBuilder.append(c);
        }
        return cPStringBuilder.toString();
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.clear();
        this.calendar.setTime(date);
        int n = this.calendar.get(1);
        this.defaultCentury = n - n % 100;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        if (dateFormatSymbols == null) {
            throw new NullPointerException("The supplied format data was null.");
        }
        this.formatData = dateFormatSymbols;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        if (this.defaultCentury != simpleDateFormat.defaultCentury) {
            return false;
        }
        if (!this.toPattern().equals(simpleDateFormat.toPattern())) {
            return false;
        }
        return this.getDateFormatSymbols().equals(simpleDateFormat.getDateFormatSymbols());
    }

    public int hashCode() {
        return super.hashCode() ^ this.toPattern().hashCode() ^ this.defaultCentury ^ this.getDateFormatSymbols().hashCode();
    }

    private void formatWithAttribute(Date date, FormatBuffer formatBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        for (Object e : this.tokens) {
            if (e instanceof CompiledField) {
                CompiledField compiledField = (CompiledField)e;
                int n = formatBuffer.length();
                switch (compiledField.getField()) {
                    case 0: {
                        formatBuffer.append(this.formatData.eras[this.calendar.get(0)], (AttributedCharacterIterator.Attribute)DateFormat.Field.ERA);
                        break;
                    }
                    case 1: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.YEAR);
                        if (compiledField.getSize() == 2) {
                            String string = "00" + String.valueOf(this.calendar.get(1));
                            formatBuffer.append(string.substring(string.length() - 2));
                            break;
                        }
                        this.withLeadingZeros(this.calendar.get(1), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 2: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.MONTH);
                        if (compiledField.getSize() < 3) {
                            this.withLeadingZeros(this.calendar.get(2) + 1, compiledField.getSize(), formatBuffer);
                            break;
                        }
                        if (compiledField.getSize() < 4) {
                            formatBuffer.append(this.formatData.shortMonths[this.calendar.get(2)]);
                            break;
                        }
                        formatBuffer.append(this.formatData.months[this.calendar.get(2)]);
                        break;
                    }
                    case 3: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(5), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 4: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY1);
                        this.withLeadingZeros((this.calendar.get(11) + 23) % 24 + 1, compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 5: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY0);
                        this.withLeadingZeros(this.calendar.get(11), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 6: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.MINUTE);
                        this.withLeadingZeros(this.calendar.get(12), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 7: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.SECOND);
                        this.withLeadingZeros(this.calendar.get(13), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 8: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.MILLISECOND);
                        this.withLeadingZeros(this.calendar.get(14), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 9: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK);
                        if (compiledField.getSize() < 4) {
                            formatBuffer.append(this.formatData.shortWeekdays[this.calendar.get(7)]);
                            break;
                        }
                        formatBuffer.append(this.formatData.weekdays[this.calendar.get(7)]);
                        break;
                    }
                    case 10: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(6), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 11: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
                        this.withLeadingZeros(this.calendar.get(8), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 12: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(3), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 13: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(4), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 14: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.AM_PM);
                        formatBuffer.append(this.formatData.ampms[this.calendar.get(9)]);
                        break;
                    }
                    case 15: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR1);
                        this.withLeadingZeros((this.calendar.get(10) + 11) % 12 + 1, compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 16: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR0);
                        this.withLeadingZeros(this.calendar.get(10), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 17: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.TIME_ZONE);
                        TimeZone timeZone = this.calendar.getTimeZone();
                        boolean bl = this.calendar.get(16) != 0;
                        String string = timeZone.getDisplayName(bl, compiledField.getSize() > 3 ? 1 : 0);
                        formatBuffer.append(string);
                        break;
                    }
                    case 23: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.TIME_ZONE);
                        int n2 = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
                        String string = n2 < 0 ? "-" : "+";
                        n2 = Math.abs(n2);
                        int n3 = n2 / 60;
                        int n4 = n2 % 60;
                        formatBuffer.append(string);
                        this.withLeadingZeros(n3, 2, formatBuffer);
                        this.withLeadingZeros(n4, 2, formatBuffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal pattern character " + compiledField.getCharacter());
                    }
                }
                if (fieldPosition == null || formatBuffer.getDefaultAttribute() != fieldPosition.getFieldAttribute() && compiledField.getField() != fieldPosition.getField()) continue;
                fieldPosition.setBeginIndex(n);
                fieldPosition.setEndIndex(formatBuffer.length());
                continue;
            }
            formatBuffer.append(e.toString(), null);
        }
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.formatWithAttribute(date, new StringFormatBuffer(stringBuffer), fieldPosition);
        return stringBuffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new NullPointerException("null argument");
        }
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("argument should be an instance of java.util.Date");
        }
        AttributedFormatBuffer attributedFormatBuffer = new AttributedFormatBuffer();
        this.formatWithAttribute((Date)object, attributedFormatBuffer, null);
        attributedFormatBuffer.sync();
        return new FormatCharacterIterator(attributedFormatBuffer.getBuffer().toString(), attributedFormatBuffer.getRanges(), attributedFormatBuffer.getAttributes());
    }

    private void withLeadingZeros(int n, int n2, FormatBuffer formatBuffer) {
        String string = String.valueOf(n);
        n2 -= string.length();
        while (n2 > 0) {
            formatBuffer.append('0');
            --n2;
        }
        formatBuffer.append(string);
    }

    private boolean expect(String string, ParsePosition parsePosition, char c) {
        boolean bl;
        int n = parsePosition.getIndex();
        boolean bl2 = bl = n < string.length() && string.charAt(n) == c;
        if (bl) {
            parsePosition.setIndex(n + 1);
        } else {
            parsePosition.setErrorIndex(n);
        }
        return bl;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n = this.pattern.length();
        this.calendar.clear();
        boolean bl = false;
        int n2 = -1;
        boolean bl2 = false;
        try {
            for (int i = 0; i < n; ++i) {
                int n3;
                int stringArray3;
                int n4;
                int number;
                int n5;
                int n6;
                int n7;
                int n8;
                char c = this.pattern.charAt(i);
                if (c == '\'') {
                    if (i < n - 1 && this.pattern.charAt(i + 1) == '\'') {
                        if (!this.expect(string, parsePosition, c)) {
                            return null;
                        }
                        ++i;
                        continue;
                    }
                    n2 = n2 < 0 ? i : -1;
                    continue;
                }
                if (n2 != -1 || (c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) {
                    if (n2 == -1 && c == ' ') {
                        n7 = n8 = parsePosition.getIndex();
                        while (n8 < string.length() && Character.isWhitespace(string.charAt(n8))) {
                            ++n8;
                        }
                        if (n8 > n7) {
                            parsePosition.setIndex(n8);
                            continue;
                        }
                        parsePosition.setErrorIndex(n8);
                        return null;
                    }
                    if (this.expect(string, parsePosition, c)) continue;
                    return null;
                }
                n8 = 1;
                while (++i < n && this.pattern.charAt(i) == c) {
                    ++n8;
                }
                n7 = 0;
                if (i < n && standardChars.indexOf(this.pattern.charAt(i)) >= 0) {
                    n7 = 1;
                }
                --i;
                boolean bl3 = true;
                int n9 = 0;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                String[] stringArray = null;
                String[] stringArray2 = null;
                switch (c) {
                    case 'd': {
                        n6 = 5;
                        break;
                    }
                    case 'D': {
                        n6 = 6;
                        break;
                    }
                    case 'F': {
                        n6 = 8;
                        break;
                    }
                    case 'E': {
                        bl3 = false;
                        n9 = 1;
                        n6 = 7;
                        stringArray = this.formatData.getWeekdays();
                        stringArray2 = this.formatData.getShortWeekdays();
                        break;
                    }
                    case 'w': {
                        n6 = 3;
                        break;
                    }
                    case 'W': {
                        n6 = 4;
                        break;
                    }
                    case 'M': {
                        n6 = 2;
                        if (n8 <= 2) {
                            n9 = -1;
                            break;
                        }
                        bl3 = false;
                        stringArray = this.formatData.getMonths();
                        stringArray2 = this.formatData.getShortMonths();
                        break;
                    }
                    case 'y': {
                        n6 = 1;
                        if (n8 > 2) break;
                        bl4 = true;
                        break;
                    }
                    case 'K': {
                        n6 = 10;
                        break;
                    }
                    case 'h': {
                        n6 = 10;
                        bl5 = true;
                        break;
                    }
                    case 'H': {
                        n6 = 11;
                        break;
                    }
                    case 'k': {
                        n6 = 11;
                        bl6 = true;
                        break;
                    }
                    case 'm': {
                        n6 = 12;
                        break;
                    }
                    case 's': {
                        n6 = 13;
                        break;
                    }
                    case 'S': {
                        n6 = 14;
                        break;
                    }
                    case 'a': {
                        bl3 = false;
                        n6 = 9;
                        stringArray = this.formatData.getAmPmStrings();
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        bl3 = false;
                        n6 = 15;
                        String[][] stringArray4 = this.formatData.getZoneStrings();
                        n5 = stringArray4.length;
                        number = parsePosition.getIndex();
                        n4 = 0;
                        Integer n10 = this.computeOffset(string.substring(number), parsePosition);
                        if (n10 != null) {
                            n4 = 1;
                            bl = true;
                            this.calendar.set(16, 0);
                            n9 = n10;
                        } else {
                            for (int j = 0; j < n5; ++j) {
                                int n11;
                                String[] stringArray5 = stringArray4[j];
                                for (n11 = 0; n11 < stringArray5.length && !string.startsWith(stringArray5[n11], number); ++n11) {
                                }
                                if (n11 == stringArray5.length) continue;
                                n4 = 1;
                                bl = true;
                                TimeZone timeZone = TimeZone.getTimeZone(stringArray5[0]);
                                if (n11 == 3 || n11 == 4) {
                                    this.calendar.set(16, timeZone.getDSTSavings());
                                } else {
                                    this.calendar.set(16, 0);
                                }
                                n9 = timeZone.getRawOffset();
                                parsePosition.setIndex(number + stringArray5[n11].length());
                                break;
                            }
                        }
                        if (n4 != 0) break;
                        parsePosition.setErrorIndex(parsePosition.getIndex());
                        return null;
                    }
                    default: {
                        parsePosition.setErrorIndex(parsePosition.getIndex());
                        return null;
                    }
                }
                n5 = -1;
                if (bl3) {
                    this.numberFormat.setMinimumIntegerDigits(n8);
                    if (bl4) {
                        n5 = parsePosition.getIndex();
                    }
                    Number n32 = null;
                    if (n7 != 0) {
                        n4 = parsePosition.getIndex();
                        parsePosition.setIndex(0);
                        n32 = this.numberFormat.parse(string.substring(n4, n4 + n8), parsePosition);
                        parsePosition.setIndex(n4 + parsePosition.getIndex());
                    } else {
                        n32 = this.numberFormat.parse(string, parsePosition);
                    }
                    if (parsePosition == null || !(n32 instanceof Long)) {
                        return null;
                    }
                    stringArray3 = n32.intValue() + n9;
                } else if (stringArray != null) {
                    n5 = parsePosition.getIndex();
                    n4 = 0;
                    for (number = n9; number < stringArray.length; ++number) {
                        if (stringArray[number] == null || !string.toUpperCase().startsWith(stringArray[number].toUpperCase(), n5)) continue;
                        n4 = 1;
                        parsePosition.setIndex(n5 + stringArray[number].length());
                        break;
                    }
                    if (n4 == 0 && stringArray2 != null) {
                        for (number = n9; number < stringArray2.length; ++number) {
                            if (stringArray2[number] == null || !string.toUpperCase().startsWith(stringArray2[number].toUpperCase(), n5)) continue;
                            n4 = 1;
                            parsePosition.setIndex(n5 + stringArray2[number].length());
                            break;
                        }
                    }
                    if (n4 == 0) {
                        parsePosition.setErrorIndex(n5);
                        return null;
                    }
                    stringArray3 = number;
                } else {
                    stringArray3 = n9;
                }
                if (bl4 && (n3 = parsePosition.getIndex() - n5) == 2) {
                    bl2 = true;
                    stringArray3 += this.defaultCentury;
                }
                if (bl5 && stringArray3 == 12) {
                    stringArray3 = 0;
                }
                if (bl6 && stringArray3 == 24) {
                    stringArray3 = 0;
                }
                this.calendar.set(n6, stringArray3);
            }
            if (bl2) {
                int illegalArgumentException = this.calendar.get(1);
                if (this.calendar.getTime().compareTo(this.defaultCenturyStart) < 0) {
                    this.calendar.set(1, illegalArgumentException + 100);
                }
            }
            if (!bl) {
                this.calendar.clear(16);
                this.calendar.clear(15);
            }
            return this.calendar.getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
    }

    private Integer computeOffset(String string, ParsePosition parsePosition) {
        Pattern pattern2 = Pattern.compile("(GMT)?([+-])([012])?([0-9]):?([0-9]{2})");
        Matcher matcher = pattern2.matcher(string);
        boolean bl = matcher.lookingAt();
        try {
            matcher.group(2);
            matcher.group(4);
            matcher.group(5);
        }
        catch (IllegalStateException illegalStateException) {
            bl = false;
        }
        if (bl) {
            int n = matcher.group(2).equals("+") ? 1 : -1;
            int n2 = Integer.parseInt(matcher.group(4));
            if (!matcher.group(3).equals("")) {
                n2 += Integer.parseInt(matcher.group(3)) * 10;
            }
            int n3 = Integer.parseInt(matcher.group(5));
            if (n2 > 23) {
                return null;
            }
            int n4 = n * (n2 * 60 + n3) * 60000;
            parsePosition.setIndex(parsePosition.getIndex() + matcher.end());
            return n4;
        }
        if (string.startsWith("GMT")) {
            parsePosition.setIndex(parsePosition.getIndex() + 3);
            return 0;
        }
        return null;
    }

    private void computeCenturyStart() {
        int n = this.calendar.get(1);
        this.calendar.set(1, n - 80);
        this.set2DigitYearStart(this.calendar.getTime());
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.setDateFormatSymbols((DateFormatSymbols)this.formatData.clone());
        simpleDateFormat.set2DigitYearStart((Date)this.defaultCenturyStart.clone());
        return simpleDateFormat;
    }

    private class CompiledField {
        int field;
        int size;
        private char character;

        public CompiledField(int n, int n2, char c) {
            this.field = n;
            this.size = n2;
            this.character = c;
        }

        public int getField() {
            return this.field;
        }

        public int getSize() {
            return this.size;
        }

        public char getCharacter() {
            return this.character;
        }

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder(this.getClass().getName());
            cPStringBuilder.append("[field=");
            cPStringBuilder.append(this.field);
            cPStringBuilder.append(", size=");
            cPStringBuilder.append(this.size);
            cPStringBuilder.append(", character=");
            cPStringBuilder.append(this.character);
            cPStringBuilder.append("]");
            return cPStringBuilder.toString();
        }
    }
}

