/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Collator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollationKey
implements Comparable<CollationKey> {
    private Collator collator;
    private String originalText;
    private byte[] key;

    CollationKey(Collator collator, String string, byte[] byArray) {
        this.collator = collator;
        this.originalText = string;
        this.key = byArray;
    }

    @Override
    public int compareTo(CollationKey collationKey) {
        int n = Math.min(this.key.length, collationKey.key.length);
        for (int i = 0; i < n; ++i) {
            if (this.key[i] == collationKey.key[i]) continue;
            return this.key[i] - collationKey.key[i];
        }
        return this.key.length - collationKey.key.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CollationKey)) {
            return false;
        }
        CollationKey collationKey = (CollationKey)object;
        if (collationKey.collator != this.collator) {
            return false;
        }
        if (!collationKey.getSourceString().equals(this.getSourceString())) {
            return false;
        }
        return Arrays.equals(collationKey.toByteArray(), this.toByteArray());
    }

    public String getSourceString() {
        return this.originalText;
    }

    public int hashCode() {
        long l = this.originalText.hashCode();
        for (int i = this.key.length - 1; i >= 0; --i) {
            l ^= (long)(this.key[i] * (i + 1));
        }
        return (int)(l >> 32 ^ l);
    }

    public byte[] toByteArray() {
        return this.key;
    }
}

