/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Vector;

public class ChoiceFormat
extends NumberFormat {
    private String[] choiceFormats;
    private double[] choiceLimits;
    private static final int mantissaBits = 52;
    private static final int exponentBits = 11;
    private static final long serialVersionUID = 1795184449645032964L;

    public void applyPattern(String string) {
        Double d;
        int n;
        int n2 = 0;
        int n3 = string.length();
        Vector<String> vector = new Vector<String>();
        Vector<Double> vector2 = new Vector<Double>();
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while (true) {
            char c;
            n = ++n2;
            while (n2 < n3 && (c = string.charAt(n2)) != '#' && c != '\u2064' && c != '<') {
                ++n2;
            }
            if (n2 == n3) {
                throw new IllegalArgumentException("unexpected end of text");
            }
            d = Double.valueOf(string.substring(n, n2));
            if (string.charAt(n2) == '<') {
                d = ChoiceFormat.nextDouble(d);
            }
            vector2.addElement(d);
            ++n2;
            cPStringBuilder.setLength(0);
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                if (c2 == '\'' && n2 < n3 + 1 && string.charAt(n2 + 1) == '\'') {
                    cPStringBuilder.append(c2);
                    ++n2;
                } else if (c2 == '\'' && n2 < n3 + 2) {
                    cPStringBuilder.append(string.charAt(n2 + 1));
                    n2 += 2;
                } else {
                    if (c2 == '|') break;
                    cPStringBuilder.append(c2);
                }
                ++n2;
            }
            vector.addElement(cPStringBuilder.toString());
            if (n2 == n3) break;
        }
        this.choiceFormats = new String[vector.size()];
        vector.copyInto(this.choiceFormats);
        this.choiceLimits = new double[vector2.size()];
        for (n = 0; n < this.choiceLimits.length; ++n) {
            d = (Double)vector2.elementAt(n);
            this.choiceLimits[n] = d;
        }
    }

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChoiceFormat)) {
            return false;
        }
        ChoiceFormat choiceFormat = (ChoiceFormat)object;
        if (this.choiceLimits.length != choiceFormat.choiceLimits.length) {
            return false;
        }
        for (int i = this.choiceLimits.length - 1; i >= 0; --i) {
            if (this.choiceLimits[i] == choiceFormat.choiceLimits[i] && this.choiceFormats[i].equals(choiceFormat.choiceFormats[i])) continue;
            return false;
        }
        return true;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n;
        if (this.choiceLimits.length == 0) {
            return stringBuffer;
        }
        if (!Double.isNaN(d) && d >= this.choiceLimits[0]) {
            for (n = 0; !(n >= this.choiceLimits.length - 1 || this.choiceLimits[n] <= d && d < this.choiceLimits[n + 1]); ++n) {
            }
        }
        return stringBuffer.append(this.choiceFormats[n]);
    }

    public Object[] getFormats() {
        return (Object[])this.choiceFormats.clone();
    }

    public double[] getLimits() {
        return (double[])this.choiceLimits.clone();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            long l = Double.doubleToLongBits(this.choiceLimits[i]);
            n = (int)((long)n ^ (l ^ l >>> 32));
            n ^= this.choiceFormats[i].hashCode();
        }
        return n;
    }

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static double nextDouble(double d, boolean bl) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = 0xFFFFFFFFFFFFFL;
        long l3 = l & l2;
        long l4 = 2047L;
        long l5 = l >>> 52 & l4;
        if (bl ^ l < 0L) {
            if (l3 == 0xFFFFFFFFFFFFFL) {
                l3 = 0L;
                if (++l5 >= 0x10000000000000L) {
                    return l > 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                }
            } else {
                ++l3;
            }
        } else {
            if (l5 == 0L && l3 == 0L) {
                return bl ? Double.MIN_VALUE : -4.9E-324;
            }
            if (l3 == 0L) {
                l3 = 0xFFFFFFFFFFFFFL;
                --l5;
            } else {
                --l3;
            }
        }
        long l6 = l < 0L ? 1L : 0L;
        l6 = l6 << 11 | l5;
        l6 = l6 << 52 | l3;
        return Double.longBitsToDouble(l6);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            if (!string.startsWith(this.choiceFormats[i], n)) continue;
            parsePosition.setIndex(n + this.choiceFormats[i].length());
            return this.choiceLimits[i];
        }
        parsePosition.setErrorIndex(n);
        return Double.NaN;
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        if (dArray == null || stringArray == null) {
            throw new NullPointerException();
        }
        if (dArray.length != stringArray.length) {
            throw new IllegalArgumentException();
        }
        this.choiceFormats = (String[])stringArray.clone();
        this.choiceLimits = (double[])dArray.clone();
    }

    private void quoteString(CPStringBuilder cPStringBuilder, String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                cPStringBuilder.append(c);
                cPStringBuilder.append(c);
                continue;
            }
            if (c == '#' || c == '|' || c == '\u2064' || c == '<') {
                cPStringBuilder.append('\'');
                cPStringBuilder.append(c);
                cPStringBuilder.append('\'');
                continue;
            }
            cPStringBuilder.append(c);
        }
    }

    public String toPattern() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        for (int i = 0; i < this.choiceLimits.length; ++i) {
            cPStringBuilder.append(this.choiceLimits[i]);
            cPStringBuilder.append('#');
            this.quoteString(cPStringBuilder, this.choiceFormats[i]);
        }
        return cPStringBuilder.toString();
    }
}

