/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedStringIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedString {
    private StringCharacterIterator sci;
    private AttributeRange[] attribs;

    public AttributedString(String string) {
        this.sci = new StringCharacterIterator(string);
        this.attribs = new AttributeRange[0];
    }

    public AttributedString(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        this(string);
        this.attribs = new AttributeRange[1];
        this.attribs[0] = new AttributeRange(map, 0, string.length());
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator) {
        this(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this(attributedCharacterIterator, n, n2, null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (n < 0 || n2 < n || n2 > attributedCharacterIterator.getEndIndex()) {
            throw new IllegalArgumentException("Bad index values");
        }
        CPStringBuilder cPStringBuilder = new CPStringBuilder("");
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAllAttributeKeys();
        if (attributeArray != null) {
            set.retainAll(Arrays.asList(attributeArray));
        }
        char c = attributedCharacterIterator.setIndex(n);
        ArrayList<AttributeRange> arrayList = new ArrayList<AttributeRange>();
        do {
            cPStringBuilder.append(c);
            for (AttributedCharacterIterator.Attribute attribute : set) {
                AttributedCharacterIterator.Attribute attribute2;
                Object object;
                if (!(attribute instanceof AttributedCharacterIterator.Attribute) || (object = attributedCharacterIterator.getAttribute(attribute2 = attribute)) == null) continue;
                int n3 = attributedCharacterIterator.getRunLimit(attribute2);
                if (n3 > n2) {
                    n3 = n2;
                }
                n3 -= n;
                int n4 = attributedCharacterIterator.getRunStart(attribute2);
                if (n4 < attributedCharacterIterator.getIndex() && attributedCharacterIterator.getIndex() != n) continue;
                if ((n4 -= n) < 0) {
                    if (object instanceof Annotation) continue;
                    n4 = 0;
                }
                Hashtable<AttributedCharacterIterator.Attribute, Object> hashtable = new Hashtable<AttributedCharacterIterator.Attribute, Object>();
                hashtable.put(attribute2, object);
                arrayList.add(new AttributeRange(hashtable, n4, n3));
            }
            c = attributedCharacterIterator.next();
        } while (attributedCharacterIterator.getIndex() < n2);
        this.attribs = new AttributeRange[arrayList.size()];
        this.attribs = arrayList.toArray(this.attribs);
        this.sci = new StringCharacterIterator(cPStringBuilder.toString());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        this.addAttribute(attribute, object, 0, this.sci.getEndIndex());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (attribute == null) {
            throw new IllegalArgumentException("null attribute");
        }
        if (n2 <= n) {
            throw new IllegalArgumentException("Requires end > begin");
        }
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        hashMap.put(attribute, object);
        this.addAttributes(hashMap, n, n2);
    }

    public void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> map, int n, int n2) {
        if (map == null) {
            throw new NullPointerException("null attribute");
        }
        if (n < 0 || n2 > this.sci.getEndIndex() || n2 <= n) {
            throw new IllegalArgumentException("bad range");
        }
        AttributeRange[] attributeRangeArray = new AttributeRange[this.attribs.length + 1];
        System.arraycopy(this.attribs, 0, attributeRangeArray, 0, this.attribs.length);
        this.attribs = attributeRangeArray;
        this.attribs[this.attribs.length - 1] = new AttributeRange(map, n, n2);
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedStringIterator(this.sci, this.attribs, 0, this.sci.getEndIndex(), null);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getIterator(attributeArray, 0, this.sci.getEndIndex());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
        if (n < 0 || n2 > this.sci.getEndIndex() || n2 < n) {
            throw new IllegalArgumentException("bad range");
        }
        return new AttributedStringIterator(this.sci, this.attribs, n, n2, attributeArray);
    }

    final class AttributeRange {
        Map attribs;
        int beginIndex;
        int endIndex;

        AttributeRange(Map map, int n, int n2) {
            this.attribs = map;
            this.beginIndex = n;
            this.endIndex = n2;
        }
    }
}

