/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.security.OID;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.ext.CertificatePolicies;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.GeneralName;
import gnu.java.security.x509.ext.GeneralSubtree;
import gnu.java.security.x509.ext.NameConstraints;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CertSelector
implements CertSelector,
Cloneable {
    private static final String AUTH_KEY_ID = "2.5.29.35";
    private static final String SUBJECT_KEY_ID = "2.5.29.14";
    private static final String NAME_CONSTRAINTS_ID = "2.5.29.30";
    private int basicConstraints = -1;
    private X509Certificate cert;
    private BigInteger serialNo;
    private X500Principal issuer;
    private X500Principal subject;
    private byte[] subjectKeyId;
    private byte[] authKeyId;
    private boolean[] keyUsage;
    private Date certValid;
    private OID sigId;
    private PublicKey subjectKey;
    private X509EncodedKeySpec subjectKeySpec;
    private Set<String> keyPurposeSet;
    private List<GeneralName> altNames;
    private boolean matchAllNames;
    private byte[] nameConstraints;
    private Set<OID> policy;
    private List<GeneralName> pathToNames;

    private static boolean checkOid(int[] nArray) {
        return nArray != null && nArray.length > 2 && nArray[0] >= 0 && nArray[0] <= 2 && nArray[1] >= 0 && nArray[1] <= 39;
    }

    private static GeneralName makeName(int n, String string) throws IOException {
        byte[] byArray = null;
        GeneralName.Kind kind = GeneralName.Kind.forTag(n);
        switch (GeneralName.Kind.forTag(n)) {
            case dNSName: 
            case rfc822Name: 
            case uniformResourceIdentifier: {
                byArray = string.getBytes("ASCII");
                break;
            }
            case iPAddress: {
                InetAddress inetAddress = InetAddress.getByName(string);
                byArray = inetAddress.getAddress();
                break;
            }
            case registeredId: {
                OID oID = new OID(string);
                byArray = oID.getDER();
                break;
            }
            case directoryName: {
                X500Principal x500Principal = new X500Principal(string);
                byArray = x500Principal.getEncoded();
                break;
            }
            case ediPartyName: 
            case x400Address: 
            case otherName: {
                throw new IOException("cannot decode string representation of " + (Object)((Object)kind));
            }
        }
        return new GeneralName(kind, byArray);
    }

    public void addPathToName(int n, byte[] byArray) throws IOException {
        GeneralName generalName = new GeneralName(GeneralName.Kind.forTag(n), byArray);
        if (this.pathToNames == null) {
            this.pathToNames = new LinkedList<GeneralName>();
        }
        this.pathToNames.add(generalName);
    }

    public void addPathToName(int n, String string) throws IOException {
        GeneralName generalName = X509CertSelector.makeName(n, string);
        if (this.pathToNames == null) {
            this.pathToNames = new LinkedList<GeneralName>();
        }
        this.pathToNames.add(generalName);
    }

    public void addSubjectAlternativeName(int n, byte[] byArray) throws IOException {
        GeneralName generalName = new GeneralName(GeneralName.Kind.forTag(n), byArray);
        if (this.altNames == null) {
            this.altNames = new LinkedList<GeneralName>();
        }
        this.altNames.add(generalName);
    }

    public void addSubjectAlternativeName(int n, String string) throws IOException {
        GeneralName generalName = X509CertSelector.makeName(n, string);
        if (this.altNames == null) {
            this.altNames = new LinkedList<GeneralName>();
        }
        this.altNames.add(generalName);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    public byte[] getAuthorityKeyIdentifier() {
        if (this.authKeyId != null) {
            return (byte[])this.authKeyId.clone();
        }
        return null;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public Date getCertificateValid() {
        if (this.certValid != null) {
            return (Date)this.certValid.clone();
        }
        return null;
    }

    public Set<String> getExtendedKeyUsage() {
        if (this.keyPurposeSet != null) {
            return Collections.unmodifiableSet(this.keyPurposeSet);
        }
        return null;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        if (this.issuer != null) {
            return this.issuer.getEncoded();
        }
        return null;
    }

    public String getIssuerAsString() {
        if (this.issuer != null) {
            return this.issuer.getName();
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllNames;
    }

    public byte[] getNameConstraints() {
        if (this.nameConstraints != null) {
            return (byte[])this.nameConstraints.clone();
        }
        return null;
    }

    public Collection<List<?>> getPathToNames() {
        if (this.pathToNames != null) {
            ArrayList arrayList = new ArrayList(this.pathToNames.size());
            for (GeneralName generalName : this.pathToNames) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add(generalName.kind().tag());
                arrayList2.add(generalName.name());
                arrayList.add(arrayList2);
            }
            return arrayList;
        }
        return null;
    }

    public Set<String> getPolicy() {
        Set<OID> set = this.policy;
        if (set != null) {
            HashSet<String> hashSet = new HashSet<String>(set.size());
            for (OID oID : set) {
                hashSet.add(oID.toString());
            }
            return hashSet;
        }
        return null;
    }

    public Date getPrivateKeyValid() {
        return null;
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public Collection<List<?>> getSubjectAlternativeNames() {
        if (this.altNames != null) {
            ArrayList arrayList = new ArrayList(this.altNames.size());
            for (GeneralName generalName : this.altNames) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add(generalName.kind().tag());
                arrayList2.add(generalName.name());
                arrayList.add(arrayList2);
            }
            return arrayList;
        }
        return null;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        if (this.subject != null) {
            return this.subject.getEncoded();
        }
        return null;
    }

    public String getSubjectAsString() {
        if (this.subject != null) {
            return this.subject.getName();
        }
        return null;
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyId != null) {
            return (byte[])this.subjectKeyId.clone();
        }
        return null;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectKey;
    }

    public String getSubjectPublicKeyAlgID() {
        return String.valueOf(this.sigId);
    }

    @Override
    public boolean match(Certificate certificate) {
        Object object;
        Object object2;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (this.cert != null) {
            try {
                object2 = this.cert.getEncoded();
                object = x509Certificate.getEncoded();
                if (!Arrays.equals((byte[])object2, (byte[])object)) {
                    return false;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return false;
            }
        }
        if (this.serialNo != null && !this.serialNo.equals(x509Certificate.getSerialNumber())) {
            return false;
        }
        if (this.certValid != null) {
            try {
                x509Certificate.checkValidity(this.certValid);
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }
        if (this.issuer != null && !this.issuer.equals(x509Certificate.getIssuerX500Principal())) {
            return false;
        }
        if (this.subject != null && !this.subject.equals(x509Certificate.getSubjectX500Principal())) {
            return false;
        }
        if (this.sigId != null && !this.sigId.toString().equals(x509Certificate.getSigAlgOID())) {
            return false;
        }
        if (this.subjectKeyId != null && !Arrays.equals((byte[])(object2 = x509Certificate.getExtensionValue(SUBJECT_KEY_ID)), this.subjectKeyId)) {
            return false;
        }
        if (this.authKeyId != null && !Arrays.equals((byte[])(object2 = x509Certificate.getExtensionValue(AUTH_KEY_ID)), this.authKeyId)) {
            return false;
        }
        if (this.keyUsage != null && !Arrays.equals((boolean[])(object2 = (Object)x509Certificate.getKeyUsage()), this.keyUsage)) {
            return false;
        }
        if (this.basicConstraints >= 0 && x509Certificate.getBasicConstraints() != this.basicConstraints) {
            return false;
        }
        if (this.keyPurposeSet != null) {
            object2 = null;
            try {
                object2 = x509Certificate.getExtendedKeyUsage();
            }
            catch (CertificateParsingException certificateParsingException) {
                return false;
            }
            if (object2 == null) {
                return false;
            }
            object = this.keyPurposeSet.iterator();
            while (object.hasNext()) {
                if (object2.contains(object.next())) continue;
                return false;
            }
        }
        if (this.altNames != null) {
            object2 = null;
            try {
                object2 = x509Certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                return false;
            }
            if (object2 == null) {
                return false;
            }
            int n = 0;
            for (GeneralName generalName : this.altNames) {
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    List object3 = (List)iterator.next();
                    try {
                        Integer n2 = (Integer)object3.get(0);
                        Object e = object3.get(1);
                        GeneralName generalName2 = null;
                        if (e instanceof String) {
                            generalName2 = X509CertSelector.makeName(n2, (String)e);
                        } else {
                            if (!(e instanceof byte[])) continue;
                            generalName2 = new GeneralName(GeneralName.Kind.forTag(n2), (byte[])e);
                        }
                        if (!generalName.equals(generalName2)) continue;
                        ++n;
                    }
                    catch (Exception exception) {}
                }
                if (n != 0 && (!this.matchAllNames || n >= this.altNames.size())) continue;
                return false;
            }
        }
        if (this.nameConstraints != null && !Arrays.equals(this.nameConstraints, (byte[])(object2 = x509Certificate.getExtensionValue(NAME_CONSTRAINTS_ID)))) {
            return false;
        }
        if (this.policy != null) {
            object2 = null;
            if (x509Certificate instanceof GnuPKIExtension) {
                object2 = (CertificatePolicies)((GnuPKIExtension)((Object)x509Certificate)).getExtension(CertificatePolicies.ID).getValue();
            } else {
                byte[] byArray = x509Certificate.getExtensionValue(CertificatePolicies.ID.toString());
                try {
                    object2 = new CertificatePolicies(byArray);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (object2 == null) {
                return false;
            }
            if (!((CertificatePolicies)object2).getPolicies().containsAll(this.policy)) {
                return false;
            }
        }
        if (this.pathToNames != null) {
            Object object4;
            object2 = null;
            if (x509Certificate instanceof GnuPKIExtension) {
                object4 = ((GnuPKIExtension)((Object)x509Certificate)).getExtension(NameConstraints.ID);
                if (object4 != null) {
                    object2 = (NameConstraints)((Extension)object4).getValue();
                }
            } else {
                object4 = x509Certificate.getExtensionValue(NameConstraints.ID.toString());
                if (object4 != null) {
                    try {
                        object2 = new NameConstraints((byte[])object4);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (object2 == null) {
                return false;
            }
            int n = 0;
            for (GeneralName generalName : this.pathToNames) {
                for (GeneralSubtree generalSubtree : ((NameConstraints)object2).permittedSubtrees()) {
                    if (!generalName.equals(generalSubtree.base())) continue;
                    ++n;
                }
            }
            if (n == 0 || this.matchAllNames && n < this.pathToNames.size()) {
                return false;
            }
        }
        return true;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.authKeyId = byArray != null ? (byte[])byArray.clone() : null;
    }

    public void setBasicConstraints(int n) {
        if (n < -1) {
            n = -1;
        }
        this.basicConstraints = n;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public void setCertificateValid(Date date) {
        this.certValid = date != null ? (Date)date.clone() : null;
    }

    public void setExtendedKeyUsage(Set<String> set) throws IOException {
        if (set == null) {
            this.keyPurposeSet = null;
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            Object object;
            if (!(string instanceof String)) {
                throw new IOException("not a string: " + string);
            }
            try {
                OID oID = new OID(string);
                object = oID.getIDs();
                if (X509CertSelector.checkOid(object)) continue;
                throw new IOException("malformed OID: " + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = new IOException("malformed OID: " + string);
                object.initCause(illegalArgumentException);
                throw object;
            }
        }
        this.keyPurposeSet = hashSet;
    }

    public void setIssuer(byte[] byArray) throws IOException {
        if (byArray != null) {
            try {
                this.issuer = new X500Principal(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public void setIssuer(String string) throws IOException {
        if (string != null) {
            try {
                this.issuer = new X500Principal(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public void setKeyUsage(boolean[] blArray) {
        this.keyUsage = blArray != null ? (boolean[])blArray.clone() : null;
    }

    public void setMatchAllSubjectAltNames(boolean bl) {
        this.matchAllNames = bl;
    }

    public void setNameConstraints(byte[] byArray) throws IOException {
        new NameConstraints(byArray);
        this.nameConstraints = byArray != null ? (byte[])byArray.clone() : null;
    }

    public void setPathToNames(Collection<List<?>> collection) throws IOException {
        if (collection == null || collection.size() == 0) {
            this.pathToNames = null;
        } else {
            this.pathToNames = new ArrayList<GeneralName>(collection.size());
            for (List<?> list2 : collection) {
                Integer n = (Integer)list2.get(0);
                Object obj = list2.get(1);
                if (obj instanceof String) {
                    this.addPathToName((int)n, (String)obj);
                    continue;
                }
                if (obj instanceof byte[]) {
                    this.addPathToName((int)n, (byte[])obj);
                    continue;
                }
                throw new IOException("invalid name type: " + obj.getClass().getName());
            }
        }
    }

    public void setPolicy(Set<String> set) throws IOException {
        if (set != null) {
            HashSet<OID> hashSet = new HashSet<OID>(set.size());
            for (String string : set) {
                Object object;
                try {
                    OID oID = new OID(string);
                    object = oID.getIDs();
                    if (!X509CertSelector.checkOid((int[])object)) {
                        throw new IOException("invalid OID");
                    }
                    hashSet.add(oID);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    object = new IOException("invalid OID");
                    ((Throwable)object).initCause(exception);
                    throw object;
                }
            }
            this.policy = hashSet;
        } else {
            this.policy = null;
        }
    }

    public void setPrivateKeyValid(Date date) {
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNo = bigInteger;
    }

    public void setSubject(byte[] byArray) throws IOException {
        if (byArray != null) {
            try {
                this.subject = new X500Principal(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public void setSubject(String string) throws IOException {
        if (string != null) {
            try {
                this.subject = new X500Principal(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public void setSubjectAlternativeNames(Collection<List<?>> collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            this.altNames = null;
            return;
        }
        ArrayList<GeneralName> arrayList = new ArrayList<GeneralName>(collection.size());
        for (List<?> list2 : collection) {
            Integer n = (Integer)list2.get(0);
            Object obj = list2.get(1);
            GeneralName generalName = null;
            if (obj instanceof String) {
                generalName = X509CertSelector.makeName(n, (String)obj);
            } else if (obj instanceof byte[]) {
                generalName = new GeneralName(GeneralName.Kind.forTag(n), (byte[])obj);
            } else {
                throw new IOException("invalid name type: " + obj.getClass().getName());
            }
            arrayList.add(generalName);
        }
        this.altNames = arrayList;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyId = byArray != null ? (byte[])byArray.clone() : null;
    }

    public void setSubjectPublicKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            return;
        }
        try {
            this.subjectKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("X.509");
            this.subjectKey = keyFactory.generatePublic(this.subjectKeySpec);
        }
        catch (Exception exception) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public void setSubjectPublicKey(PublicKey publicKey) {
        this.subjectKey = publicKey;
        if (publicKey == null) {
            this.subjectKeySpec = null;
            return;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("X.509");
            this.subjectKeySpec = keyFactory.getKeySpec(publicKey, X509EncodedKeySpec.class);
        }
        catch (Exception exception) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
        }
    }

    public void setSubjectPublicKeyAlgID(String string) throws IOException {
        if (string != null) {
            try {
                OID oID = new OID(string);
                int[] nArray = oID.getIDs();
                if (!X509CertSelector.checkOid(nArray)) {
                    throw new IOException("malformed OID: " + string);
                }
                this.sigId = oID;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IOException iOException = new IOException("malformed OID: " + string);
                iOException.initCause(illegalArgumentException);
                throw iOException;
            }
        } else {
            this.sigId = null;
        }
    }

    public String toString() {
        int n;
        CPStringBuilder cPStringBuilder = new CPStringBuilder(X509CertSelector.class.getName());
        String string = SystemProperties.getProperty("line.separator");
        String string2 = ";" + string;
        cPStringBuilder.append(" {").append(string);
        if (this.cert != null) {
            cPStringBuilder.append("  certificate = ").append(this.cert).append(string2);
        }
        if (this.basicConstraints >= 0) {
            cPStringBuilder.append("  basic constraints = ").append(this.basicConstraints).append(string2);
        }
        if (this.serialNo != null) {
            cPStringBuilder.append("  serial number = ").append(this.serialNo).append(string2);
        }
        if (this.certValid != null) {
            cPStringBuilder.append("  valid date = ").append(this.certValid).append(string2);
        }
        if (this.issuer != null) {
            cPStringBuilder.append("  issuer = ").append(this.issuer).append(string2);
        }
        if (this.subject != null) {
            cPStringBuilder.append("  subject = ").append(this.subject).append(string2);
        }
        if (this.sigId != null) {
            cPStringBuilder.append("  signature OID = ").append(this.sigId).append(string2);
        }
        if (this.subjectKey != null) {
            cPStringBuilder.append("  subject public key = ").append(this.subjectKey).append(string2);
        }
        if (this.subjectKeyId != null) {
            cPStringBuilder.append("  subject key ID = ");
            for (n = 0; n < this.subjectKeyId.length; ++n) {
                cPStringBuilder.append(Character.forDigit((this.subjectKeyId[n] & 0xF0) >>> 8, 16));
                cPStringBuilder.append(Character.forDigit(this.subjectKeyId[n] & 0xF, 16));
                if (n >= this.subjectKeyId.length - 1) continue;
                cPStringBuilder.append(':');
            }
            cPStringBuilder.append(string2);
        }
        if (this.authKeyId != null) {
            cPStringBuilder.append("  authority key ID = ");
            for (n = 0; n < this.authKeyId.length; ++n) {
                cPStringBuilder.append(Character.forDigit((this.authKeyId[n] & 0xF0) >>> 8, 16));
                cPStringBuilder.append(Character.forDigit(this.authKeyId[n] & 0xF, 16));
                if (n >= this.authKeyId.length - 1) continue;
                cPStringBuilder.append(':');
            }
            cPStringBuilder.append(string2);
        }
        if (this.keyUsage != null) {
            cPStringBuilder.append("  key usage = ");
            for (n = 0; n < this.keyUsage.length; ++n) {
                cPStringBuilder.append(this.keyUsage[n] ? (char)'1' : '0');
            }
            cPStringBuilder.append(string2);
        }
        if (this.keyPurposeSet != null) {
            cPStringBuilder.append("  key purpose = ").append(this.keyPurposeSet).append(string2);
        }
        if (this.altNames != null) {
            cPStringBuilder.append("  alternative names = ").append(this.altNames).append(string2);
        }
        if (this.nameConstraints != null) {
            cPStringBuilder.append("  name constraints = <blob of data>").append(string2);
        }
        if (this.policy != null) {
            cPStringBuilder.append("  policy = ").append(this.policy).append(string2);
        }
        if (this.pathToNames != null) {
            cPStringBuilder.append("  pathToNames = ").append(this.pathToNames).append(string2);
        }
        cPStringBuilder.append("}").append(string);
        return cPStringBuilder.toString();
    }
}

