/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CRLSelector
implements CRLSelector,
Cloneable {
    private static final String CRL_NUMBER_ID = "2.5.29.20";
    private List issuerNames;
    private BigInteger maxCrlNumber;
    private BigInteger minCrlNumber;
    private Date date;
    private X509Certificate cert;

    public void addIssuerName(byte[] byArray) throws IOException {
        X500Principal x500Principal = null;
        try {
            x500Principal = new X500Principal(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("malformed name");
            iOException.initCause(illegalArgumentException);
            throw iOException;
        }
        if (this.issuerNames == null) {
            this.issuerNames = new LinkedList();
        }
        this.issuerNames.add(x500Principal);
    }

    public void addIssuerName(String string) throws IOException {
        X500Principal x500Principal = null;
        try {
            x500Principal = new X500Principal(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("malformed name: " + string);
            iOException.initCause(illegalArgumentException);
            throw iOException;
        }
        if (this.issuerNames == null) {
            this.issuerNames = new LinkedList();
        }
        this.issuerNames.add(x500Principal);
    }

    public void setIssuerNames(Collection<?> collection) throws IOException {
        if (collection == null) {
            this.issuerNames = null;
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (Object obj : collection) {
            if (obj instanceof X500Principal) {
                arrayList.add(obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    arrayList.add(new X500Principal((String)obj));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IOException iOException = new IOException("malformed name: " + obj);
                    iOException.initCause(illegalArgumentException);
                    throw iOException;
                }
            }
            if (obj instanceof byte[]) {
                try {
                    arrayList.add(new X500Principal((byte[])obj));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IOException iOException = new IOException("malformed name");
                    iOException.initCause(illegalArgumentException);
                    throw iOException;
                }
            }
            if (obj instanceof InputStream) {
                try {
                    arrayList.add(new X500Principal((InputStream)obj));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IOException iOException = new IOException("malformed name");
                    iOException.initCause(illegalArgumentException);
                    throw iOException;
                }
            }
            throw new IOException("not a valid name: " + (obj != null ? obj.getClass().getName() : "null"));
        }
        this.issuerNames = arrayList;
    }

    public Collection<Object> getIssuerNames() {
        if (this.issuerNames != null) {
            return Collections.unmodifiableList(this.issuerNames);
        }
        return null;
    }

    public BigInteger getMaxCRL() {
        return this.maxCrlNumber;
    }

    public BigInteger getMinCRL() {
        return this.minCrlNumber;
    }

    public void setMaxCRLNumber(BigInteger bigInteger) {
        this.maxCrlNumber = bigInteger;
    }

    public void setMinCRLNumber(BigInteger bigInteger) {
        this.minCrlNumber = bigInteger;
    }

    public Date getDateAndTime() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDateAndTime(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public X509Certificate getCertificateChecking() {
        return this.cert;
    }

    public void setCertificateChecking(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(X509CRLSelector.class.getName());
        String string = SystemProperties.getProperty("line.separator");
        String string2 = ";" + string;
        cPStringBuilder.append(" {").append(string);
        if (this.issuerNames != null) {
            cPStringBuilder.append("  issuer names = ").append(this.issuerNames).append(string2);
        }
        if (this.maxCrlNumber != null) {
            cPStringBuilder.append("  max CRL = ").append(this.maxCrlNumber).append(string2);
        }
        if (this.minCrlNumber != null) {
            cPStringBuilder.append("  min CRL = ").append(this.minCrlNumber).append(string2);
        }
        if (this.date != null) {
            cPStringBuilder.append("  date = ").append(this.date).append(string2);
        }
        if (this.cert != null) {
            cPStringBuilder.append("  certificate = ").append(this.cert).append(string2);
        }
        cPStringBuilder.append("}").append(string);
        return cPStringBuilder.toString();
    }

    @Override
    public boolean match(CRL cRL) {
        DERValue dERValue;
        byte[] byArray;
        if (!(cRL instanceof X509CRL)) {
            return false;
        }
        X509CRL x509CRL = (X509CRL)cRL;
        if (this.issuerNames != null && !this.issuerNames.contains(x509CRL.getIssuerX500Principal())) {
            return false;
        }
        BigInteger bigInteger = null;
        if (this.maxCrlNumber != null) {
            byArray = x509CRL.getExtensionValue(CRL_NUMBER_ID);
            if (byArray == null) {
                return false;
            }
            try {
                dERValue = DERReader.read(byArray);
                if (!(dERValue.getValue() instanceof BigInteger)) {
                    return false;
                }
                bigInteger = (BigInteger)dERValue.getValue();
            }
            catch (IOException iOException) {
                return false;
            }
            if (this.maxCrlNumber.compareTo(bigInteger) < 0) {
                return false;
            }
        }
        if (this.minCrlNumber != null) {
            if (bigInteger == null) {
                byArray = x509CRL.getExtensionValue(CRL_NUMBER_ID);
                if (byArray == null) {
                    return false;
                }
                try {
                    dERValue = DERReader.read(byArray);
                    if (!(dERValue.getValue() instanceof BigInteger)) {
                        return false;
                    }
                    bigInteger = (BigInteger)dERValue.getValue();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            if (this.minCrlNumber.compareTo(bigInteger) > 0) {
                return false;
            }
        }
        return this.date == null || this.date.compareTo(x509CRL.getThisUpdate()) >= 0 && this.date.compareTo(x509CRL.getNextUpdate()) <= 0;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }
}

