/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.lang.CPStringBuilder;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXBuilderParameters
extends PKIXParameters {
    private int maxPathLength;

    public PKIXBuilderParameters(KeyStore keyStore, CertSelector certSelector) throws KeyStoreException, InvalidAlgorithmParameterException {
        super(keyStore);
        this.setTargetCertConstraints(certSelector);
        this.maxPathLength = 5;
    }

    public PKIXBuilderParameters(Set<TrustAnchor> set, CertSelector certSelector) throws InvalidAlgorithmParameterException {
        super(set);
        this.setTargetCertConstraints(certSelector);
        this.maxPathLength = 5;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        this.maxPathLength = n;
    }

    @Override
    public String toString() {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(super.toString());
        cPStringBuilder.insert(cPStringBuilder.length() - 2, "; Max Path Length=" + this.maxPathLength);
        return cPStringBuilder.toString();
    }
}

