/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;

public class CertPathBuilder {
    private static final String CERT_PATH_BUILDER = "CertPathBuilder";
    private CertPathBuilderSpi cpbSpi;
    private Provider provider;
    private String algorithm;

    protected CertPathBuilder(CertPathBuilderSpi certPathBuilderSpi, Provider provider, String string) {
        this.cpbSpi = certPathBuilderSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static final String getDefaultType() {
        String string = Security.getProperty("certpathbuilder.type");
        if (string == null) {
            string = "PKIX";
        }
        return string;
    }

    public static CertPathBuilder getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return CertPathBuilder.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static CertPathBuilder getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return CertPathBuilder.getInstance(string, provider);
    }

    public static CertPathBuilder getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        CPStringBuilder cPStringBuilder = new CPStringBuilder("CertPathBuilder for algorithm [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object object = Engine.getInstance(CERT_PATH_BUILDER, string, provider);
            return new CertPathBuilder((CertPathBuilderSpi)object, provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(cPStringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertPathBuilderResult build(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        return this.cpbSpi.engineBuild(certPathParameters);
    }
}

