/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.IntersectingDomainCombiner;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.LinkedList;

final class VMAccessController {
    private static final ThreadLocal contexts = new ThreadLocal();
    private static final ThreadLocal inGetContext = new ThreadLocal();
    private static final AccessControlContext DEFAULT_CONTEXT;
    private static final boolean DEBUG = false;

    private static void debug(String string) {
        System.err.print(">>> VMAccessController: ");
        System.err.println(string);
    }

    private VMAccessController() {
    }

    static void pushContext(AccessControlContext accessControlContext) {
        LinkedList<AccessControlContext> linkedList = (LinkedList<AccessControlContext>)contexts.get();
        if (linkedList == null) {
            linkedList = new LinkedList<AccessControlContext>();
            contexts.set(linkedList);
        }
        linkedList.addFirst(accessControlContext);
    }

    static void popContext() {
        LinkedList linkedList = (LinkedList)contexts.get();
        if (linkedList != null) {
            linkedList.removeFirst();
            if (linkedList.isEmpty()) {
                contexts.set(null);
            }
        }
    }

    static AccessControlContext getContext() {
        Object object;
        Boolean bl = (Boolean)inGetContext.get();
        if (bl != null && bl.booleanValue()) {
            return DEFAULT_CONTEXT;
        }
        inGetContext.set(Boolean.TRUE);
        Object[][] objectArray = VMAccessController.getStack();
        Class[] classArray = (Class[])objectArray[0];
        String[] stringArray = (String[])objectArray[1];
        HashSet<ProtectionDomain> hashSet = new HashSet<ProtectionDomain>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        AccessControlContext accessControlContext = null;
        int n = 0;
        for (int i = 3; i < classArray.length && n < 2; ++i) {
            Object object2;
            object = classArray[i];
            String string = stringArray[i];
            ClassLoader classLoader = ((Class)object).getClassLoader();
            if (n == 1) {
                n = 2;
            }
            if (object.equals(AccessController.class) && string.equals("doPrivileged")) {
                object2 = (LinkedList)contexts.get();
                if (object2 != null) {
                    accessControlContext = (AccessControlContext)((LinkedList)object2).getFirst();
                }
                n = 1;
            }
            if ((object2 = ((Class)object).getProtectionDomain()) == null || hashSet2.contains(object2)) continue;
            hashSet2.add(object2);
            hashSet.add(new ProtectionDomain(((ProtectionDomain)object2).getCodeSource(), ((ProtectionDomain)object2).getPermissions(), classLoader, null));
        }
        ProtectionDomain[] protectionDomainArray = hashSet.toArray(new ProtectionDomain[hashSet.size()]);
        accessControlContext = accessControlContext != null ? ((object = accessControlContext.getDomainCombiner()) == null ? new AccessControlContext(IntersectingDomainCombiner.SINGLETON.combine(protectionDomainArray, accessControlContext.getProtectionDomains())) : new AccessControlContext(protectionDomainArray, accessControlContext, (DomainCombiner)object)) : new AccessControlContext(protectionDomainArray);
        inGetContext.set(Boolean.FALSE);
        return accessControlContext;
    }

    private static Object[][] getStack() {
        return new Object[][]{new Class[0], new String[0]};
    }

    static {
        CodeSource codeSource = new CodeSource(null, null);
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{new ProtectionDomain(codeSource, permissions, null, null)};
        DEFAULT_CONTEXT = new AccessControlContext(protectionDomainArray);
    }
}

