/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import gnu.java.security.provider.Gnu;
import gnu.javax.crypto.jce.GnuCrypto;
import gnu.javax.crypto.jce.GnuSasl;
import gnu.javax.net.ssl.provider.Jessie;
import gnu.javax.security.auth.callback.GnuCallbacks;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Security {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static Vector providers = new Vector();
    private static Properties secprops = new Properties();

    private Security() {
    }

    private static boolean loadProviders(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = true;
        String string3 = string + "/security/" + string2 + ".security";
        try {
            String string4;
            InputStream inputStream = new URL(string3).openStream();
            secprops.load(inputStream);
            int n = 1;
            while ((string4 = secprops.getProperty("security.provider." + n)) != null) {
                Exception exception = null;
                try {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    providers.addElement(Class.forName(string4, true, classLoader).newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    exception = classNotFoundException;
                }
                catch (InstantiationException instantiationException) {
                    exception = instantiationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = illegalAccessException;
                }
                if (exception != null) {
                    System.err.println("WARNING: Error loading security provider " + string4 + ": " + exception);
                    bl = false;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public static String getAlgorithmProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = String.valueOf(string2) + "." + String.valueOf(string);
        for (Provider provider : providers) {
            for (String string4 : provider.keySet()) {
                if (!string4.equalsIgnoreCase(string3)) continue;
                return provider.getProperty(string4);
            }
        }
        return null;
    }

    public static int insertProviderAt(Provider provider, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("insertProvider." + provider.getName());
        }
        --n;
        int n2 = providers.size();
        for (int i = 0; i < n2; ++i) {
            if (!((Provider)providers.elementAt(i)).getName().equals(provider.getName())) continue;
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        providers.insertElementAt(provider, n);
        return n + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static void removeProvider(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeProvider." + string);
        }
        int n = providers.size();
        for (int i = 0; i < n; ++i) {
            if (!((Provider)providers.elementAt(i)).getName().equals(string)) continue;
            providers.remove(i);
            break;
        }
    }

    public static Provider[] getProviders() {
        Object[] objectArray = new Provider[providers.size()];
        providers.copyInto(objectArray);
        return objectArray;
    }

    public static Provider getProvider(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        int n = providers.size();
        for (int i = 0; i < n; ++i) {
            Provider provider = (Provider)providers.elementAt(i);
            if (!provider.getName().equals(string)) continue;
            return provider;
        }
        return null;
    }

    public static String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && VMStackWalker.getCallingClassLoader() != null) {
            securityManager.checkSecurityAccess("getProperty." + string);
        }
        return secprops.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setProperty." + string);
        }
        if (string2 == null) {
            secprops.remove(string);
        } else {
            secprops.put(string, string2);
        }
    }

    public static Set<String> getAlgorithms(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null || string.length() == 0) {
            return hashSet;
        }
        if ((string = string.trim()).length() == 0) {
            return hashSet;
        }
        string = string.toUpperCase() + ".";
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Enumeration<?> enumeration = providerArray[i].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = ((String)enumeration.nextElement()).trim();
                if (!string2.toUpperCase().startsWith(string)) continue;
                int n = (string2 = string2.substring(string.length()).trim()).indexOf(32);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                hashSet.add(string2);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static Provider[] getProviders(String string) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return Security.getProviders();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        int n = string.indexOf(58);
        if (n == -1) {
            hashMap.put(string, "");
        } else {
            hashMap.put(string.substring(0, n), string.substring(n + 1));
        }
        return Security.getProviders(hashMap);
    }

    public static Provider[] getProviders(Map<String, String> map) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (map == null) {
            return Security.getProviders();
        }
        Set<String> set = map.keySet();
        if (set == null || set.isEmpty()) {
            return Security.getProviders();
        }
        LinkedHashSet<Provider> linkedHashSet = new LinkedHashSet<Provider>(providers);
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        for (String string : set) {
            String string2;
            String string3;
            String string4;
            if (string == null || (string = string.trim()).length() == 0) continue;
            int n = string.indexOf(46);
            if (n == -1) {
                throw new InvalidParameterException("missing dot in '" + String.valueOf(string) + "'");
            }
            String string5 = map.get(string);
            if (string5 == null || string5.trim().length() == 0) {
                string5 = null;
                string4 = null;
                string3 = string.substring(0, n).trim();
                string2 = string.substring(n + 1).trim();
            } else {
                int n2 = string.indexOf(32);
                if (n2 == -1) {
                    throw new InvalidParameterException("value (" + String.valueOf(string5) + ") is not empty, but querry (" + String.valueOf(string) + ") is missing at least one space character");
                }
                string5 = string5.trim();
                string4 = string.substring(n2 + 1).trim();
                if (string4.indexOf(46) != -1) {
                    throw new InvalidParameterException("attribute_name (" + String.valueOf(string4) + ") in querry (" + String.valueOf(string) + ") contains a dot");
                }
                string = string.substring(0, n2).trim();
                string3 = string.substring(0, n).trim();
                string2 = string.substring(n + 1).trim();
            }
            if (string3.length() == 0) {
                throw new InvalidParameterException("<crypto_service> in querry (" + String.valueOf(string) + ") is empty");
            }
            if (string2.length() == 0) {
                throw new InvalidParameterException("<algorithm_or_type> in querry (" + String.valueOf(string) + ") is empty");
            }
            Security.selectProviders(string3, string2, string4, string5, linkedHashSet, linkedHashSet2);
            linkedHashSet.retainAll(linkedHashSet2);
            if (!linkedHashSet.isEmpty()) continue;
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        return linkedHashSet.toArray(new Provider[linkedHashSet.size()]);
    }

    private static void selectProviders(String string, String string2, String string3, String string4, LinkedHashSet linkedHashSet, LinkedHashSet linkedHashSet2) {
        linkedHashSet2.clear();
        for (Provider provider : linkedHashSet) {
            if (!Security.provides(provider, string, string2, string3, string4)) continue;
            linkedHashSet2.add(provider);
        }
    }

    private static boolean provides(Provider provider, String string, String string2, String string3, String string4) {
        String string5 = null;
        String string62 = null;
        boolean bl = false;
        block0: for (int i = 0; i < 3; ++i) {
            string5 = (string + "." + String.valueOf(string2)).trim();
            for (String string62 : provider.keySet()) {
                if (string62.equalsIgnoreCase(string5)) {
                    bl = true;
                    break block0;
                }
                if (!string62.equalsIgnoreCase(ALG_ALIAS + string5)) continue;
                string2 = provider.getProperty(string62);
                continue block0;
            }
        }
        if (!bl) {
            return false;
        }
        if (string4 == null) {
            return true;
        }
        int n = string5.length() + 1;
        for (String string62 : provider.keySet()) {
            String string7;
            if (string62.length() <= n || !string62.substring(0, n).equalsIgnoreCase(string5 + " ") || !(string7 = string62.substring(n).trim()).equalsIgnoreCase(string3)) continue;
            String string8 = provider.getProperty(string62);
            if (string8 == null) {
                return false;
            }
            if (string4.equalsIgnoreCase(string8 = string8.trim())) {
                return true;
            }
            return Integer.parseInt(string4) >= Integer.parseInt(string8);
        }
        return false;
    }

    static {
        String string = SystemProperties.getProperty("gnu.classpath.home.url");
        String string2 = SystemProperties.getProperty("gnu.classpath.vm.shortname");
        boolean bl = Security.loadProviders(string, string2);
        if (!Security.loadProviders(string, "classpath") && !bl && providers.size() == 0) {
            providers.addElement(new Gnu());
            providers.addElement(new GnuCrypto());
            providers.addElement(new GnuSasl());
            providers.addElement(new Jessie());
            providers.addElement(new GnuCallbacks());
        }
    }
}

