/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.Engine;
import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.jce.prng.Sha160RandomSpi;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final long serialVersionUID = 4940670005562187L;
    long counter = 0L;
    Provider provider = null;
    byte[] randomBytes = null;
    int randomBytesUsed = 0;
    SecureRandomSpi secureRandomSpi = null;
    byte[] state = null;
    private String algorithm;
    private boolean isSeeded = false;

    public SecureRandom() {
        Provider[] providerArray = Security.getProviders();
        String string = null;
        for (int i = 0; i < providerArray.length; ++i) {
            Enumeration<?> enumeration = providerArray[i].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith("SECURERANDOM.") || (string = providerArray[i].getProperty(string2)) == null) continue;
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(string).newInstance();
                    this.provider = providerArray[i];
                    this.algorithm = string2.substring(13);
                    return;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                }
            }
        }
        this.secureRandomSpi = new Sha160RandomSpi();
        this.algorithm = "Sha160";
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, "unknown");
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String string) {
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return SecureRandom.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
                continue;
            }
        }
        if (noSuchAlgorithmException != null) {
            throw noSuchAlgorithmException;
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return SecureRandom.getInstance(string, provider);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        Throwable throwable;
        CPStringBuilder cPStringBuilder = new CPStringBuilder("SecureRandom for algorithm [").append(string).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object object = Engine.getInstance(SECURE_RANDOM, string, provider);
            return new SecureRandom((SecureRandomSpi)object, provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getCause();
            if (throwable instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)throwable;
            }
            if (throwable == null) {
                throwable = invocationTargetException;
            }
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(cPStringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
        this.isSeeded = true;
    }

    public void setSeed(long l) {
        if (this.secureRandomSpi != null) {
            byte[] byArray = new byte[]{(byte)(0xFFL & l >> 56), (byte)(0xFFL & l >> 48), (byte)(0xFFL & l >> 40), (byte)(0xFFL & l >> 32), (byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l)};
            this.secureRandomSpi.engineSetSeed(byArray);
            this.isSeeded = true;
        }
    }

    public void nextBytes(byte[] byArray) {
        if (!this.isSeeded) {
            this.setSeed(SecureRandom.getSeed(32));
        }
        this.randomBytesUsed += byArray.length;
        ++this.counter;
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    protected final int next(int n) {
        if (n == 0) {
            return 0;
        }
        byte[] byArray = new byte[(n + 7) / 8];
        this.nextBytes(byArray);
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n2 |= (byArray[i] & 0xFF) << 8 * i;
        }
        long l = (1L << n) - 1L;
        return (int)((long)n2 & l);
    }

    public static byte[] getSeed(int n) {
        return SecureRandomAdapter.getSeed(n);
    }

    public byte[] generateSeed(int n) {
        return this.secureRandomSpi.engineGenerateSeed(n);
    }
}

