/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.util.Properties;

public abstract class Provider
extends Properties
implements Serializable {
    private static final long serialVersionUID = -4298000515446427739L;
    private String info;
    private String name;
    private double version;

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    public Object put(Object object, Object object2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("putProviderProperty." + this.name);
        }
        return super.put(this.toCanonicalKey(object), object2);
    }

    public Object get(Object object) {
        return super.get(this.toCanonicalKey(object));
    }

    public Object remove(Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeProviderProperty." + this.name);
        }
        return super.remove(this.toCanonicalKey(object));
    }

    public void clear() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("clearProviderProperties." + this.name);
        }
        super.clear();
    }

    public String toString() {
        return this.getClass().getName() + ": name=" + this.getName() + " version=" + this.version;
    }

    private Object toCanonicalKey(Object object) {
        if (object.getClass().isAssignableFrom(String.class)) {
            return ((String)object).toUpperCase();
        }
        return object;
    }
}

